/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.resp.InvWhAreaRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.out.service.OutService;
import com.elitesland.pur.dto.ItmItemuomConvRatioQueryParm;
import com.elitesland.pur.dto.PurPoDVO;
import com.elitesland.pur.entity.QPurSsDO;
import com.elitesland.pur.repo.PurSsDRepoProc;
import com.elitesland.pur.repo.PurSsRepo;
import com.elitesland.pur.repo.PurSsRepoProc;
import com.elitesland.pur.service.PurGrService;
import com.elitesland.pur.service.PurSs2Service;
import com.elitesland.pur.service.PurSsDService;
import com.elitesland.pur.service.PurSsService;
import com.elitesland.pur.vo.param.PurPoDUpdateParamVO;
import com.elitesland.pur.vo.param.PurSsParamVO;
import com.elitesland.pur.vo.resp.PurGrRespVO;
import com.elitesland.pur.vo.resp.PurPoDRespVO;
import com.elitesland.pur.vo.resp.PurPoRespVO;
import com.elitesland.pur.vo.resp.PurSsDRespVO;
import com.elitesland.pur.vo.resp.PurSsRespVO;
import com.elitesland.pur.vo.resp.PurSuppRespVO;
import com.elitesland.pur.vo.save.PurGrDSaveVO;
import com.elitesland.pur.vo.save.PurGrSaveVO;
import com.elitesland.pur.vo.save.PurPoSaveVO;
import com.elitesland.pur.vo.save.PurSsDSaveVO;
import com.elitesland.pur.vo.save.PurSsEmailSaveVO;
import com.elitesland.pur.vo.save.PurSsSaveVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="purSs2Service")
public class PurSs2ServiceImpl
implements PurSs2Service {
    private static final Logger log = LoggerFactory.getLogger(PurSs2ServiceImpl.class);
    private final PurSsRepo purSsRepo;
    private final PurSsRepoProc purSsRepoProc;
    private final PurSsDRepoProc purSsDRepoProc;
    private final PurSsService purSsDervice;
    private final PurSsDService purSsDService;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;
    private final PurGrService purGrService;
    private final InvWhAreaService invWhAreaService;
    private final SysNumberRuleService sysNumberRuleService;
    private final OutService outService;

    @SysCodeProc
    public PagingVO<PurSsRespVO> searchPurSs(PurSsParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.purSsRepoProc.select(null).where(this.purSsRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        this.purSsRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QPurSsDO.purSsDO);
        List lists = jpaQuery.fetch();
        this.translate(lists);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    private void translate(List<PurSsRespVO> lists) {
        if (lists == null || lists.size() == 0) {
            return;
        }
        List<Long> ouIds = lists.stream().map(PurSsRespVO::getOuId).distinct().collect(Collectors.toList());
        List<Long> suppIds = lists.stream().map(PurSsRespVO::getSuppId).distinct().collect(Collectors.toList());
        List whIds = lists.stream().map(PurSsRespVO::getWhId).distinct().collect(Collectors.toList());
        List<PurSuppRespVO> orgSuppList = this.outService.findSuppByIdBatch(suppIds);
        List orgWhList = this.invWhService.findIdBatch(whIds);
        List<OrgOuVO> orgOuList = this.outService.findOusByBatch(ouIds);
        lists.forEach(VO -> {
            Optional<InvWhRespVO> orgWhVOOptional;
            Optional<PurSuppRespVO> suppVOOptional;
            Optional<OrgOuVO> ouVOOptional = orgOuList.stream().filter(v -> v.getId().equals(VO.getOuId())).findFirst();
            if (ouVOOptional.isPresent()) {
                OrgOuVO orgOuVO = ouVOOptional.get();
                VO.setOuCode(orgOuVO.getCode());
                VO.setOuName(orgOuVO.getName());
            }
            if ((suppVOOptional = orgSuppList.stream().filter(v -> v.getId().equals(VO.getSuppId())).findFirst()).isPresent()) {
                PurSuppRespVO invSuppVO = suppVOOptional.get();
                VO.setSuppCode(invSuppVO.getSuppCode());
                VO.setSuppName(invSuppVO.getSuppName());
            }
            if ((orgWhVOOptional = orgWhList.stream().filter(v -> v.getId().equals(VO.getWhId())).findFirst()).isPresent()) {
                InvWhRespVO orgWhVO = orgWhVOOptional.get();
                VO.setWhCode(orgWhVO.getWhCode());
                VO.setWhName(orgWhVO.getWhName());
                VO.setWhName(orgWhVO.getWhName());
                VO.setWhType(orgWhVO.getWhType());
            }
        });
    }

    @Transactional
    public void deleteBatchPurSs(List<Long> list) {
        list.forEach(id -> {
            Optional optional = this.purSsDervice.findIdOne(id);
            if (optional.isPresent()) {
                PurSsRespVO purSsRespVO = (PurSsRespVO)optional.get();
                if (!UdcEnum.PUR_SS_STATUS_DR.getValueCode().equals(purSsRespVO.getDocStatus())) {
                    throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u7533\u8bf7\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u7533\u8bf7\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
            }
            PurSsRespVO purSsRespVO2 = new PurSsRespVO();
            purSsRespVO2.setId(id);
            purSsRespVO2.setDocStatus(UdcEnum.PUR_SS_STATUS_CL.getValueCode());
            this.purSsDervice.update(purSsRespVO2);
        });
    }

    @SysCodeProc
    public Optional<PurSsRespVO> findPurSsOne(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        JPAQuery<PurSsRespVO> jpaQuery = this.purSsRepoProc.select(null);
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        PurSsRespVO vo = (PurSsRespVO)jpaQuery.fetchOne();
        if (vo != null) {
            this.translate(List.of(vo));
            ArrayList<String> docNos = new ArrayList<String>();
            docNos.add(vo.getRelateDocNo());
            List<PurPoRespVO> purPoDocNoBatch = this.outService.findPurPoDocNoBatch(docNos);
            if (!CollectionUtils.isEmpty(purPoDocNoBatch)) {
                Optional poVOOptional = purPoDocNoBatch.stream().findFirst();
                poVOOptional.ifPresent(i -> vo.setSuppDocNo1(i.getSuppDocNo()));
            }
            vo.setPurSsDRespVOList(this.purSsDService.findByMasId(id));
        }
        return Optional.ofNullable(vo);
    }

    @Transactional
    public Long createPurSs(PurSsSaveVO createParam) {
        this.whTypeVerify(createParam);
        this.poVerify(createParam);
        PurSsRespVO purSsRespVO = (PurSsRespVO)BeanUtil.copyProperties((Object)createParam, PurSsRespVO.class);
        purSsRespVO.setDocStatus(UdcEnum.PUR_SS_STATUS_DR.getValueCode());
        Long masId = purSsRespVO.getId();
        Double totalQty = createParam.getPurSsDSaveVOList().stream().map(PurSsDSaveVO::getQty).reduce(0.0, Double::sum);
        purSsRespVO.setQty(totalQty);
        String suppTaxCode = this.outService.findIdPurSuppOne(createParam.getSuppId()).map(PurSuppRespVO::getTaxCode).orElse(null);
        purSsRespVO.setTaxRateNo(suppTaxCode);
        if (masId != null && this.purSsRepo.existsById(purSsRespVO.getId())) {
            this.purSsDervice.update(purSsRespVO);
            this.purSsDService.deleteByMasId(masId);
        } else {
            ArrayList<String> runtimeValues = new ArrayList<String>();
            String ouCode = this.outService.findOrgOuVOById(createParam.getOuId()) == null ? "18010" : this.outService.findOrgOuVOById(createParam.getOuId()).getCode();
            runtimeValues.add(ouCode.substring(ouCode.length() - 3));
            String purSsCode = this.sysNumberRuleService.generateCode("SS", runtimeValues);
            purSsRespVO.setDocNo(purSsCode);
            masId = this.purSsDervice.createOne(purSsRespVO);
        }
        if (createParam.getPurSsDSaveVOList() == null) {
            return masId;
        }
        List purSsDSaveVOS = createParam.getPurSsDSaveVOList();
        StringBuilder erRecord = new StringBuilder();
        Long finalMasId = masId;
        AtomicDouble linoNo = new AtomicDouble(0.0);
        List purPrDVOS = purSsDSaveVOS.stream().map(d -> {
            PurSsDRespVO purSsDRespVO = (PurSsDRespVO)BeanUtil.copyProperties((Object)d, PurSsDRespVO.class);
            purSsDRespVO.setMasId(finalMasId);
            purSsDRespVO.setLineNo(Double.valueOf(linoNo.addAndGet(1.0)));
            purSsDRespVO.setTaxRateNo(suppTaxCode);
            return purSsDRespVO;
        }).collect(Collectors.toList());
        this.purSsDService.createBatch(purPrDVOS);
        return masId;
    }

    private void lotNoVerify(PurSsSaveVO createParam) {
        List purSsDSaveVOS = createParam.getPurSsDSaveVOList();
        if (purSsDSaveVOS == null || purSsDSaveVOS.size() == 0) {
            return;
        }
        ArrayList params = purSsDSaveVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurSsDSaveVO>(Comparator.comparing(o -> o.getLotNo() + ";" + o.getItemId()))), ArrayList::new));
        if (params.size() != purSsDSaveVOS.size()) {
            throw new BusinessException(ApiCode.FAIL, "\u5b58\u5728\u76f8\u540c\u5546\u54c1\u76f8\u540c\u6279\u6b21\u7684\u591a\u6761\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5!");
        }
    }

    private void deterVerify(PurSsSaveVO createParam) {
        List purSsDSaveVOS = createParam.getPurSsDSaveVOList();
        if (purSsDSaveVOS == null || purSsDSaveVOS.size() == 0) {
            return;
        }
        createParam.setDeter3(null);
        Map<String, List<PurSsDSaveVO>> deter2Map = purSsDSaveVOS.stream().filter(purSsDVO -> purSsDVO.getDeter2() != null).collect(Collectors.groupingBy(PurSsDSaveVO::getDeter2));
        if (deter2Map.keySet().size() > 1) {
            throw new BusinessException(ApiCode.FAIL, "\u5b58\u5728\u591a\u4e2a\u529f\u80fd\u533a\uff0c\u8bf7\u68c0\u67e5");
        }
        purSsDSaveVOS.forEach(i -> i.setDeter3(null));
        List orgWhAreaVOS = this.invWhAreaService.findByWhId(createParam.getWhId());
    }

    private void deter3Verify(PurSsSaveVO createParam) {
        List purSsDSaveVOS;
        if (createParam.getDeter3() != null) {
            createParam.setDeter1(null);
            createParam.setDeter2(null);
            purSsDSaveVOS = createParam.getPurSsDSaveVOList();
            if (purSsDSaveVOS == null || purSsDSaveVOS.size() == 0) {
                return;
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u5ba2\u6237\u6807\u8bc6\u6570\u636e\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        purSsDSaveVOS.forEach(param -> {
            param.setDeter3(createParam.getDeter3());
            param.setDeter1(null);
            param.setDeter2(null);
        });
        purSsDSaveVOS = createParam.getPurSsDSaveVOList();
        if (purSsDSaveVOS == null || purSsDSaveVOS.size() == 0) {
            return;
        }
        List orgWhAreaVOS = this.invWhAreaService.findByWhId(createParam.getWhId());
        List orgWhAreaVOS1 = purSsDSaveVOS.stream().map(i -> {
            List orgWhAreaVOS2 = orgWhAreaVOS.stream().filter(whAreaVo -> !StringUtils.isEmpty((CharSequence)whAreaVo.getDeter3())).collect(Collectors.toList());
            Optional<InvWhAreaRespVO> orgWhAreaVO = orgWhAreaVOS2.stream().filter(whArea -> whArea.getDeter3().equals(i.getDeter3())).findFirst();
            InvWhAreaRespVO orgWhAreaVO1 = null;
            if (!orgWhAreaVO.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u672a\u67e5\u5230" + i.getItemId() + "\u5546\u54c1\u8be6\u60c5\u5bf9\u5e94\u7684\u5916\u90e8\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5");
            }
            orgWhAreaVO1 = orgWhAreaVO.get();
            return orgWhAreaVO1;
        }).collect(Collectors.toList());
        Map<String, List<InvWhAreaRespVO>> WhAreaMap = orgWhAreaVOS1.stream().filter(orgWhAreaVO -> orgWhAreaVO.getOuterCode() != null).collect(Collectors.groupingBy(InvWhAreaRespVO::getOuterCode));
        if (WhAreaMap.keySet().size() > 1) {
            throw new BusinessException(ApiCode.FAIL, "\u5b58\u5728\u591a\u4e2a\u4e0d\u540c\u5916\u90e8\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    @Transactional
    public Long submitPurSs(PurSsSaveVO createParam) {
        Long masId;
        this.verifiesNumber(createParam);
        Optional optional = this.purSsDervice.findIdOne(createParam.getId());
        if (optional.isEmpty()) {
            masId = this.createPurSs(createParam);
        } else if (UdcEnum.PUR_SS_STATUS_DR.getValueCode().equals(((PurSsRespVO)optional.get()).getDocStatus())) {
            masId = this.createPurSs(createParam);
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u5355\u636e\u624d\u53ef\u63d0\u4ea4");
        }
        PurSsRespVO purSsRespVO1 = new PurSsRespVO();
        purSsRespVO1.setId(masId);
        purSsRespVO1.setDocStatus(UdcEnum.PUR_SS_STATUS_CF.getValueCode());
        this.purSsDervice.update(purSsRespVO1);
        Optional purSsVOOptional = this.purSsDervice.findIdOne(masId);
        if (purSsVOOptional.isPresent()) {
            PurSsRespVO purSsRespVO2 = (PurSsRespVO)purSsVOOptional.get();
            purSsRespVO2.setShipmentEmpId(createParam.getShipmentEmpId());
            List purSsDRespVOS = this.purSsDService.findByMasId(masId);
            this.addShippedQty(purSsRespVO2, purSsDRespVOS);
            this.addOnePurGr(purSsRespVO2, purSsDRespVOS);
        }
        return masId;
    }

    @Transactional
    public Long salDosubmitPurSs(PurSsSaveVO createParam) {
        Long masId;
        this.verifiesNumber(createParam);
        Optional optional = this.purSsDervice.findIdOne(createParam.getId());
        if (optional.isEmpty()) {
            masId = this.createPurSs(createParam);
        } else if (UdcEnum.PUR_SS_STATUS_DR.getValueCode().equals(((PurSsRespVO)optional.get()).getDocStatus())) {
            masId = this.createPurSs(createParam);
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u5355\u636e\u624d\u53ef\u63d0\u4ea4");
        }
        PurSsRespVO purSsRespVOS = new PurSsRespVO();
        purSsRespVOS.setId(masId);
        purSsRespVOS.setDocStatus(UdcEnum.PUR_SS_STATUS_CF.getValueCode());
        this.purSsDervice.update(purSsRespVOS);
        Optional purSsVOOptional = this.purSsDervice.findIdOne(masId);
        if (purSsVOOptional.isPresent()) {
            PurSsRespVO purSsRespVO = (PurSsRespVO)purSsVOOptional.get();
            List purSsDRespVOS = this.purSsDService.findByMasId(masId);
            this.addShippedQty(purSsRespVO, purSsDRespVOS);
            this.addOnePurGrsaldo(purSsRespVO, purSsDRespVOS);
        }
        return masId;
    }

    private void verifiesNumber(PurSsSaveVO createParam) {
        List purSsDSaveVOS = createParam.getPurSsDSaveVOList();
        if ((purSsDSaveVOS = purSsDSaveVOS.stream().filter(purSsDSaveVO -> purSsDSaveVO.getQty() != 0.0).collect(Collectors.toList())).size() == 0) {
            throw new BusinessException(ApiCode.FAIL, "\u660e\u7ec6\u884c\u6570\u91cf\u5747\u4e3a0\uff0c\u8bf7\u68c0\u67e5");
        }
        createParam.setPurSsDSaveVOList(purSsDSaveVOS);
    }

    private void addShippedQty(PurSsRespVO purSsRespVO, List<PurSsDRespVO> purSsDRespVOS) {
        Long relateDocId = purSsRespVO.getRelateDocId();
        String relateDocCls = purSsRespVO.getRelateDocCls();
        if (!UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(relateDocCls)) {
            return;
        }
        double shippedQtySum = 0.0;
        List<Long> poDids = purSsDRespVOS.stream().map(PurSsDRespVO::getRelateDocDid).collect(Collectors.toList());
        List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDInfoByBatch(poDids);
        for (PurSsDRespVO d : purSsDRespVOS) {
            PurPoDUpdateParamVO purPoDSaveVO = new PurPoDUpdateParamVO();
            if (CollectionUtils.isEmpty(purPoDVOS)) continue;
            Optional<PurPoDRespVO> purPoDVOOptional = purPoDVOS.stream().filter(poDVO -> poDVO.getId().equals(d.getRelateDocDid())).findFirst();
            if (purPoDVOOptional.isPresent()) {
                PurPoDRespVO purPoDVO = purPoDVOOptional.get();
                double uomRatio = this.getUomRatio(purPoDVO.getItemCode(), purPoDVO.getItemName(), d.getUom(), purPoDVO.getUom());
                double shippedQty = d.getQty() * uomRatio;
                shippedQtySum += shippedQty;
                purPoDSaveVO.setId(d.getRelateDocDid());
                purPoDSaveVO.setShippedQty(Double.valueOf(shippedQty));
                this.outService.addShippedQty(purPoDSaveVO);
                continue;
            }
            throw new BusinessException(ApiCode.FAIL, "\u53d1\u8d27\u5355\u5173\u8054\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38,\u8bf7\u68c0\u67e5");
        }
        PurPoSaveVO purPoVO = new PurPoSaveVO();
        purPoVO.setId(relateDocId);
        purPoVO.setShippedQty(Double.valueOf(shippedQtySum));
        if (!UdcEnum.PUR_PO_STATUS_RSVING.getValueCode().equals(purPoVO.getDocStatus())) {
            purPoVO.setDocStatus(UdcEnum.PUR_PO_STATUS_SHIPPED.getValueCode());
        }
        this.outService.updatePurPoQty(purPoVO);
    }

    private void addOnePurGr(PurSsRespVO purSsRespVO, List<PurSsDRespVO> purSsDRespVOS) {
        PurGrSaveVO purGrSaveVO = this.purSsVOConvertGrCreateParam(purSsRespVO);
        ArrayList<PurGrDSaveVO> purGrDSaveVOS = new ArrayList<PurGrDSaveVO>();
        List itemIds = purSsDRespVOS.stream().map(PurSsDRespVO::getItemId).collect(Collectors.toList());
        List itmItemVOS = Collections.emptyList();
        for (PurSsDRespVO purSsDRespVO : purSsDRespVOS) {
            purGrDSaveVOS.add(this.purSsDVOConvertGrDCreateParam(purSsDRespVO));
        }
        if (purGrSaveVO.getIntfFlag() == 1) {
            purGrDSaveVOS.forEach(i -> i.setQty(Double.valueOf(0.0)));
        }
        purGrSaveVO.setPurGrDSaveVOList(purGrDSaveVOS);
        this.purGrService.createPurGr(purGrSaveVO);
    }

    private void addOnePurGrsaldo(PurSsRespVO purSsRespVO, List<PurSsDRespVO> purSsDRespVOS) {
        PurGrSaveVO purGrSaveVO = this.purSsVOConvertGrCreateParam(purSsRespVO);
        ArrayList<PurGrDSaveVO> purGrDSaveVOS = new ArrayList<PurGrDSaveVO>();
        List itemIds = purSsDRespVOS.stream().map(PurSsDRespVO::getItemId).collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIds);
        List<ItmItemDTO> itmItemVOS = this.outService.itmItemAllSearch(partParam);
        for (PurSsDRespVO purSsDRespVO : purSsDRespVOS) {
            purGrDSaveVOS.add(this.purSsDVOConvertGrDCreateParam(purSsDRespVO));
        }
        purGrSaveVO.setPurGrDSaveVOList(purGrDSaveVOS);
        purGrSaveVO.setRecvDate(LocalDateTime.now());
        Long purGr = this.purGrService.createPurGr(purGrSaveVO);
    }

    private PurGrSaveVO purSsVOConvertGrCreateParam(PurSsRespVO purSsRespVO) {
        if (purSsRespVO == null) {
            return null;
        }
        PurGrSaveVO purGrSaveVO = new PurGrSaveVO();
        BeanUtils.copyProperties((Object)purSsRespVO, (Object)purGrSaveVO);
        purGrSaveVO.setOuId(purSsRespVO.getOuId());
        purGrSaveVO.setBuId(purSsRespVO.getBuId());
        purGrSaveVO.setPoId(purSsRespVO.getPoId());
        purGrSaveVO.setSuppId(purSsRespVO.getSuppId());
        purGrSaveVO.setWhId(purSsRespVO.getWhId());
        purGrSaveVO.setDeter1(purSsRespVO.getDeter1());
        purGrSaveVO.setDeter2(purSsRespVO.getDeter2());
        purGrSaveVO.setDeter3(purSsRespVO.getDeter3());
        purGrSaveVO.setSuppDocNo(purSsRespVO.getSuppDocNo());
        purGrSaveVO.setCrosswhFlag(purSsRespVO.getCrosswhFlag());
        purGrSaveVO.setQty(purSsRespVO.getQty());
        purGrSaveVO.setRecvDate(purSsRespVO.getEtaDate());
        purGrSaveVO.setRecvEmpId(purSsRespVO.getShipmentEmpId());
        purGrSaveVO.setRelateDoc2Id(purSsRespVO.getId());
        purGrSaveVO.setRelateDoc2No(purSsRespVO.getDocNo());
        purGrSaveVO.setSuppDocNo(purSsRespVO.getDocNo());
        purGrSaveVO.setIntfFlag(purSsRespVO.getIntfFlag());
        purGrSaveVO.setDeter2(purSsRespVO.getDeter2());
        purGrSaveVO.setDeter3(purSsRespVO.getDeter3());
        purGrSaveVO.setRemark(purSsRespVO.getRemark());
        return purGrSaveVO;
    }

    public PurGrDSaveVO purSsDVOConvertGrDCreateParam(PurSsDRespVO purSsDRespVO) {
        if (purSsDRespVO == null) {
            return null;
        }
        PurGrDSaveVO purGrDSaveVO = new PurGrDSaveVO();
        purGrDSaveVO.setPoDId(purSsDRespVO.getPoDId());
        purGrDSaveVO.setItemId(purSsDRespVO.getItemId());
        purGrDSaveVO.setPoQty(purSsDRespVO.getPoQty());
        purGrDSaveVO.setSsQty(purSsDRespVO.getQty());
        purGrDSaveVO.setQty(purSsDRespVO.getQty());
        purGrDSaveVO.setUom(purSsDRespVO.getUom());
        purGrDSaveVO.setWhId(purSsDRespVO.getWhId());
        purGrDSaveVO.setBarcode(purSsDRespVO.getBarcode());
        purGrDSaveVO.setDeter1(purSsDRespVO.getDeter1());
        purGrDSaveVO.setDeter2(purSsDRespVO.getDeter2());
        purGrDSaveVO.setDeter3(purSsDRespVO.getDeter3());
        if (StringUtils.isNotEmpty((CharSequence)purSsDRespVO.getLotNo())) {
            purGrDSaveVO.setLotNo(purSsDRespVO.getLotNo());
        } else if (purSsDRespVO.getManuDate() != null && purSsDRespVO.getExpireDate() != null) {
            String newLotNo = purSsDRespVO.getManuDate().toLocalDate().format(DateTimeFormatter.ofPattern("yyMMdd")) + "/" + purSsDRespVO.getExpireDate().toLocalDate().format(DateTimeFormatter.ofPattern("yyMMdd"));
            purGrDSaveVO.setLotNo(newLotNo);
        }
        purGrDSaveVO.setMenuLotNo(purSsDRespVO.getMenuLotNo());
        purGrDSaveVO.setManuDate(purSsDRespVO.getManuDate());
        purGrDSaveVO.setExpireDate(purSsDRespVO.getExpireDate());
        purGrDSaveVO.setExpireDays(purSsDRespVO.getExpireDays());
        purGrDSaveVO.setUntilExpireDays(purSsDRespVO.getUntilExpireDays());
        purGrDSaveVO.setDemandFreshPercent(purSsDRespVO.getDemandFreshPercent());
        purGrDSaveVO.setActualFreshPercent(purSsDRespVO.getActualFreshPercent());
        purGrDSaveVO.setDemandAapDays(purSsDRespVO.getDemandAapDays());
        purGrDSaveVO.setIsFressValid(purSsDRespVO.getIsFressValid());
        purGrDSaveVO.setBarcode(purSsDRespVO.getBarcode());
        purGrDSaveVO.setRelateDoc2Did(purSsDRespVO.getId());
        purGrDSaveVO.setSsDId(purSsDRespVO.getId());
        purGrDSaveVO.setDbrand(purSsDRespVO.getDbrand());
        return purGrDSaveVO;
    }

    private void poVerify(PurSsSaveVO createParam) {
        if (createParam.getPurSsDSaveVOList() == null) {
            return;
        }
        if (UdcEnum.COM_DOC_CLS_RNS.getValueCode().equals(createParam.getRelateDocCls())) {
            return;
        }
        double overSsPercent = 0.0;
        String relateDocNo = createParam.getRelateDocNo();
        Optional<PurPoRespVO> purPoVOOptional = this.outService.findPurByCodeOne(relateDocNo);
        if (purPoVOOptional.isPresent()) {
            PurPoRespVO purPoVO = purPoVOOptional.get();
            if (!(UdcEnum.PUR_PO_STATUS_CF.getValueCode().equals(purPoVO.getDocStatus()) || UdcEnum.PUR_PO_STATUS_SHIPPED.getValueCode().equals(purPoVO.getDocStatus()) || UdcEnum.PUR_PO_STATUS_RSVING.getValueCode().equals(purPoVO.getDocStatus()))) {
                throw new BusinessException(ApiCode.FAIL, "\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u4e0d\u53ef\u53d1\u8d27");
            }
            createParam.setRelateDocId(purPoVO.getId());
            createParam.setRelateDocNo(purPoVO.getDocNo());
            createParam.setRelateDocCls(UdcEnum.COM_DOC_CLS_PO.getValueCode());
            createParam.setOuId(purPoVO.getOuId());
            createParam.setSuppId(purPoVO.getSuppId());
            createParam.setHomeCurr(purPoVO.getHomeCurr());
            createParam.setCurrCode(purPoVO.getCurrCode());
            createParam.setCurrRate(purPoVO.getCurrRate());
            createParam.setTaxCode(purPoVO.getTaxCode());
        }
        List purSsDSaveVOList = createParam.getPurSsDSaveVOList();
        List<Long> purPoDIds = purSsDSaveVOList.stream().map(PurSsDSaveVO::getRelateDocDid).distinct().collect(Collectors.toList());
        List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDInfoByBatch(purPoDIds);
        List itemIds = purSsDSaveVOList.stream().map(PurSsDSaveVO::getItemId).distinct().collect(Collectors.toList());
        ItmItemPartParam partParam = new ItmItemPartParam();
        partParam.setIds(itemIds);
        List<ItmItemDTO> itemVOS = this.outService.itmItemAllSearch(partParam);
        AtomicDouble lineNo = new AtomicDouble(0.0);
        for (PurSsDSaveVO ssd : purSsDSaveVOList) {
            Optional<PurPoDRespVO> purPoDVOOptional = purPoDVOS.stream().filter(pod -> pod.getId().equals(ssd.getRelateDocDid())).findFirst();
            Optional<ItmItemDTO> itmItemVOOptional = itemVOS.stream().filter(item -> item.getId().equals(ssd.getItemId())).findFirst();
            if (!purPoDVOOptional.isPresent()) continue;
            PurPoDRespVO purPoDVO = purPoDVOOptional.get();
            ssd.setRelateDocCls(UdcEnum.COM_DOC_CLS_PO.getValueCode());
            ssd.setRelateDocId(purPoDVO.getMasId());
            ssd.setRelateDocNo(relateDocNo);
            ssd.setRelateDocDid(purPoDVO.getId());
            ssd.setRelateDocLineno(Double.valueOf(purPoDVO.getLineNo().intValue()));
            ssd.setNetPrice(purPoDVO.getNetPrice());
            ssd.setPrice(purPoDVO.getPrice());
            ssd.setCurrNetPrice(purPoDVO.getCurrNetPrice());
            ssd.setCurrPrice(purPoDVO.getCurrPrice());
            ssd.setPbPrice(purPoDVO.getPbPrice());
            ssd.setPbCurr(purPoDVO.getPbCurr());
            ssd.setPbUom(purPoDVO.getPbUom());
            ssd.setTaxCode(purPoDVO.getTaxCode());
            ssd.setTaxRate(purPoDVO.getTaxRate());
            ssd.setAmt(purPoDVO.getPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(ssd.getQty())).setScale(2, RoundingMode.HALF_UP));
            ssd.setNetAmt(purPoDVO.getNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(ssd.getQty())).setScale(2, RoundingMode.HALF_UP));
            ssd.setCurrAmt(purPoDVO.getCurrPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(ssd.getQty())).setScale(2, RoundingMode.HALF_UP));
            ssd.setCurrNetAmt(purPoDVO.getCurrNetPrice().setScale(4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(ssd.getQty())).setScale(2, RoundingMode.HALF_UP));
            ssd.setTaxAmt(ssd.getCurrAmt().subtract(ssd.getCurrNetAmt()).setScale(2, RoundingMode.HALF_UP));
            ssd.setCurrCode(purPoDVO.getCurrCode());
            ssd.setCurrRate(purPoDVO.getCurrRate());
            createParam.setTaxAmt((createParam.getTaxAmt() == null ? BigDecimal.ZERO : createParam.getTaxAmt()).add(ssd.getTaxAmt()));
            createParam.setAmt((createParam.getAmt() == null ? BigDecimal.ZERO : createParam.getAmt()).add(ssd.getAmt()));
            createParam.setNetAmt((createParam.getNetAmt() == null ? BigDecimal.ZERO : createParam.getNetAmt()).add(ssd.getNetAmt()));
            createParam.setCurrAmt((createParam.getCurrAmt() == null ? BigDecimal.ZERO : createParam.getCurrAmt()).add(ssd.getCurrAmt()));
            createParam.setCurrNetAmt((createParam.getCurrNetAmt() == null ? BigDecimal.ZERO : createParam.getCurrNetAmt()).add(ssd.getCurrNetAmt()));
        }
    }

    private void overSsVerify(Double overSsPercent, List<PurSsDSaveVO> purSsDSaveVOList, List<PurPoDVO> purPoDVOS, List<ItmItemVO> itemVOS) {
        Map<Long, List<PurSsDSaveVO>> groupByRelateDocDidMap = purSsDSaveVOList.stream().collect(Collectors.groupingBy(PurSsDSaveVO::getRelateDocDid));
        for (Long relateDocDid : groupByRelateDocDidMap.keySet()) {
            List<PurSsDSaveVO> purSsDCreateParamsPart = groupByRelateDocDidMap.get(relateDocDid);
            double shippedQtySum = 0.0;
            Optional<PurPoDVO> purPoVOOptional = purPoDVOS.stream().filter(poDId -> poDId.getId().equals(relateDocDid)).findFirst();
            if (purPoVOOptional.isEmpty()) {
                throw new BusinessException(ApiCode.FAIL, "\u53d1\u8d27\u5355\u5546\u54c1\u4e0d\u5c5e\u4e8e\u6b64\u91c7\u8d2d\u5355");
            }
            PurPoDVO purPoDVO = purPoVOOptional.get();
            for (PurSsDSaveVO purSsDSaveVO : purSsDCreateParamsPart) {
                Optional<ItmItemVO> itmItemVOOptional = itemVOS.stream().filter(i -> i.getId().equals(purSsDSaveVO.getItemId())).findFirst();
                if (itmItemVOOptional.isEmpty()) {
                    throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u4e3b\u6570\u636e\u5f02\u5e38");
                }
                shippedQtySum += purSsDSaveVO.getQty().doubleValue();
            }
            double d = purPoDVO.getShippedQty() == null ? 0.0 : purPoDVO.getShippedQty();
            if (!(shippedQtySum + d > purPoDVO.getQty() * (1.0 + overSsPercent))) continue;
            throw new BusinessException(ApiCode.FAIL, "\u5546\u54c1\u3010" + purPoDVO.getItemName() + "\u3011\u53d1\u8d27\u6570\u5df2\u8d85\u8fc7\u8ba2\u5355\u5269\u4f59\u53ef\u53d1\u8d27\u6570\uff08\u5141\u8bb8\u8d85\u53d1" + overSsPercent * 100.0 + "%\uff09");
        }
    }

    private Double getUomRatio(String itemCode, String itemName, String fromUom, String toUom) {
        double uomRatio = 1.0;
        if (fromUom == null || toUom == null || fromUom.equals(toUom)) {
            return uomRatio;
        }
        ItmItemuomConvRatioQueryParm queryParm = new ItmItemuomConvRatioQueryParm();
        queryParm.setItemCode(itemCode);
        queryParm.setFromUom(fromUom);
        queryParm.setToUom(toUom);
        return 1.0;
    }

    public void whTypeVerify(PurSsSaveVO createParam) {
        Long whId = createParam.getWhId();
        Integer crosswhFlag = createParam.getCrosswhFlag();
        if (crosswhFlag == null) {
            return;
        }
        Optional orgWhVOOptional = this.invWhService.findIdOne(whId);
        if (orgWhVOOptional.isPresent()) {
            InvWhRespVO orgWhVO = (InvWhRespVO)orgWhVOOptional.get();
            String whType = orgWhVO.getWhType();
            if (crosswhFlag.equals(0) && UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(whType)) {
                throw new BusinessException(ApiCode.FAIL, "\u5df2\u9009\u62e9\u7684\u8d8a\u5e93\u6807\u8bc6\u4e3a\u201c\u662f\u201d\uff0c\u8bf7\u9009\u62e9\u903b\u8f91\u4ed3\u4f5c\u4e3a\u6536\u8d27\u4ed3\u5e93");
            }
            if (crosswhFlag.equals(1) && !UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(whType)) {
                throw new BusinessException(ApiCode.FAIL, "\u5df2\u9009\u62e9\u7684\u8d8a\u5e93\u6807\u8bc6\u4e3a\u201c\u5426\u201d\uff0c\u8bf7\u9009\u62e9\u7269\u7406\u4ed3\u4f5c\u4e3a\u6536\u8d27\u4ed3\u5e93");
            }
            if (UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(whType)) {
                this.deterVerify(createParam);
            } else {
                this.deter3Verify(createParam);
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u8be5\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
    }

    public void sendMail(PurSsEmailSaveVO param) {
        for (Long masId : param.getMasIds()) {
            StringBuilder htmlHead = new StringBuilder().append("<html>").append("<body>").append("<h2 align ='center'>\u91c7\u8d2d\u5230\u8d27\u5165\u5e93\u901a\u77e5</h2>").append("<table align ='left' border = '0px' width='1200'>");
            Optional optional = this.purSsDervice.findPurSsOne(masId);
            if (optional.isPresent()) {
                PurGrRespVO purGrRespVO;
                PurSsRespVO purSsRespVO = (PurSsRespVO)optional.get();
                String outerNo = null;
                if (this.purGrService.findByRelateDoc2No(purSsRespVO.getDocNo()) != null && this.purGrService.findByRelateDoc2No(purSsRespVO.getDocNo()).size() > 0 && (purGrRespVO = (PurGrRespVO)this.purGrService.findByRelateDoc2No(purSsRespVO.getDocNo()).get(0)) != null) {
                    outerNo = purGrRespVO.getOuterNo();
                }
                htmlHead.append("<tr>").append("<td > <b>\u4f9b\u5e94\u5546\u540d\u79f0:</b> </td><td>").append(purSsRespVO.getSuppName() == null ? "" : purSsRespVO.getSuppName()).append("</td>").append("<td > <b>\u4ed3\u5e93\u7f16\u7801:</b></td><td >").append(purSsRespVO.getWhCode() == null ? "" : purSsRespVO.getWhCode()).append("</td>").append("<td > <b>\u4f9b\u5e94\u5546\u8ba2\u5355\u53f7:</b></td><td >").append(purSsRespVO.getSuppDocNo1() == null ? "" : purSsRespVO.getSuppDocNo1()).append("</td>").append("</tr><tr>").append("<td > <b>\u9884\u8ba1\u5230\u8d27\u65e5\u671f:</b></td><td >").append(purSsRespVO.getEtaDate() == null ? "" : purSsRespVO.getEtaDate().toLocalDate()).append("</td>").append("<td > <b>\u53d1\u8d27\u65e5\u671f:</b></td><td>").append(purSsRespVO.getShipmentDate() == null ? "" : purSsRespVO.getShipmentDate().toLocalDate()).append("</td>").append("<td > <b>\u53d1\u8d27\u72b6\u6001:</b></td><td >").append(purSsRespVO.getDocStatusName() == null ? "" : purSsRespVO.getDocStatusName()).append("</td>").append("</tr><tr>").append("<td > <b>\u6536\u8d27\u5730\u5740:</b></td><td >").append(purSsRespVO.getRecvAddr() == null ? "" : purSsRespVO.getRecvAddr()).append("</td>").append("<td > <b>\u5916\u90e8\u5355\u636e\u7f16\u53f7:</b></td><td >").append(outerNo == null ? "" : outerNo).append("</td>").append("<td > <b>\u5907\u6ce8:</b></td><td >").append(purSsRespVO.getRemark() == null ? "" : purSsRespVO.getRemark()).append("</td>").append("</tr>");
            }
            htmlHead.append("</table><table align ='center' border = '1px' width = '100%' cellspacing = '0px'>");
            String title = "<tr><th>\u884c\u53f7</th><th>\u5546\u54c1\u7f16\u7801</th><th>\u5546\u54c1\u540d\u79f0</th><th>\u5546\u54c1\u89c4\u683c</th><th>\u9700\u53d1\u8d27\u6570\u91cf</th><th>\u8ba2\u8d27\u5355\u4f4d</th><th>\u751f\u4ea7\u65e5\u671f</th><th>\u5931\u6548\u65e5\u671f</th><th>\u6279\u6b21</th><th>\u6761\u7801</th><th>\u6e29\u5c42</th><th>\u529f\u80fd\u533a</th><th>\u5ba2\u6237\u6807\u8bc6</th><th>\u5907\u6ce8</th></tr>";
            htmlHead.append(title);
            StringBuilder htmlTail = new StringBuilder().append("</table>").append("</body>").append("</html>");
            if (optional.isPresent()) {
                PurSsRespVO purSsRespVO = (PurSsRespVO)optional.get();
                List purSsDRespVOList = purSsRespVO.getPurSsDRespVOList();
                for (PurSsDRespVO purSsDRespVO : purSsDRespVOList) {
                    htmlHead.append("<tr>").append("<td>").append(purSsDRespVO.getLineNo() == null ? "" : Integer.valueOf(purSsDRespVO.getLineNo().intValue())).append("</td>").append("<td>").append(purSsDRespVO.getItemCode() == null ? "" : purSsDRespVO.getItemCode()).append("</td>").append("<td>").append(purSsDRespVO.getItemName() == null ? "" : purSsDRespVO.getItemName()).append("</td>").append("<td>").append(purSsDRespVO.getItemSpec() == null ? "" : purSsDRespVO.getItemSpec()).append("</td>").append("<td>").append(purSsDRespVO.getQty() == null ? "" : purSsDRespVO.getQty()).append("</td>").append("<td>").append(purSsDRespVO.getUomName() == null ? "" : purSsDRespVO.getUomName()).append("</td>").append("<td>").append(purSsDRespVO.getManuDate() == null ? "" : purSsDRespVO.getManuDate().toLocalDate()).append("</td>").append("<td>").append(purSsDRespVO.getExpireDate() == null ? "" : purSsDRespVO.getExpireDate().toLocalDate()).append("</td>").append("<td>").append(purSsDRespVO.getLotNo() == null ? "" : purSsDRespVO.getLotNo()).append("</td>").append("<td>").append(purSsDRespVO.getBarcode() == null ? "" : purSsDRespVO.getBarcode()).append("</td>").append("<td>").append(purSsDRespVO.getDeter1Name() == null ? "" : purSsDRespVO.getDeter1Name()).append("</td>").append("<td>").append(purSsDRespVO.getDeter2Name() == null ? "" : purSsDRespVO.getDeter2Name()).append("</td>").append("<td>").append(purSsDRespVO.getDeter3() == null ? "" : purSsDRespVO.getDeter3()).append("</td>").append("<td>").append(purSsDRespVO.getRemark() == null ? "" : purSsDRespVO.getRemark()).append("</td>").append("</tr>");
                }
                htmlHead.append((CharSequence)htmlTail);
                continue;
            }
            throw new BusinessException(ApiCode.FAIL, "\u4f9b\u5e94\u5546\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    public PurSs2ServiceImpl(PurSsRepo purSsRepo, PurSsRepoProc purSsRepoProc, PurSsDRepoProc purSsDRepoProc, PurSsService purSsDervice, PurSsDService purSsDService, InvWhService invWhService, OrgOuService orgOuService, PurGrService purGrService, InvWhAreaService invWhAreaService, SysNumberRuleService sysNumberRuleService, OutService outService) {
        this.purSsRepo = purSsRepo;
        this.purSsRepoProc = purSsRepoProc;
        this.purSsDRepoProc = purSsDRepoProc;
        this.purSsDervice = purSsDervice;
        this.purSsDService = purSsDService;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
        this.purGrService = purGrService;
        this.invWhAreaService = invWhAreaService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.outService = outService;
    }
}

