/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.out.service.OutService;
import com.elitesland.pur.convert.PurSsDConvert;
import com.elitesland.pur.entity.PurSsDDO;
import com.elitesland.pur.entity.QPurSsDDO;
import com.elitesland.pur.repo.PurSsDRepo;
import com.elitesland.pur.repo.PurSsDRepoProc;
import com.elitesland.pur.service.PurGrDService;
import com.elitesland.pur.service.PurSsDService;
import com.elitesland.pur.vo.param.PurSsDParamVO;
import com.elitesland.pur.vo.resp.PurPoDRespVO;
import com.elitesland.pur.vo.resp.PurSsDRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemPartParam;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="purSsDService")
public class PurSsDServiceImpl
implements PurSsDService {
    private final PurSsDRepo purSsDRepo;
    private final PurSsDRepoProc purSsDRepoProc;
    private final PurGrDService purGrDService;
    private final OutService outService;

    @SysCodeProc
    public PagingVO<PurSsDRespVO> search(PurSsDParamVO param) {
        JPAQuery<PurSsDRespVO> jpaQuery = this.purSsDRepoProc.select(param);
        long dataCount = jpaQuery.fetchCount();
        this.purSsDRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QPurSsDDO.purSsDDO);
        List lists = jpaQuery.fetch();
        this.translate(lists);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public Optional<PurSsDRespVO> findCodeOne(String itemCode) {
        JPAQuery<PurSsDRespVO> jpaQuery = this.purSsDRepoProc.select(null);
        PurSsDRespVO vo = (PurSsDRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<PurSsDRespVO> findIdOne(Long id) {
        JPAQuery<PurSsDRespVO> jpaQuery = this.purSsDRepoProc.select(null);
        QPurSsDDO jpaQDo = QPurSsDDO.purSsDDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        PurSsDRespVO vo = (PurSsDRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public List<PurSsDRespVO> findIdBatch(List<Long> idList) {
        QPurSsDDO jpaQDo = QPurSsDDO.purSsDDO;
        JPAQuery where = (JPAQuery)this.purSsDRepoProc.select(null).where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @SysCodeProc
    public List<PurSsDRespVO> findByMasId(Long masId) {
        PurSsDParamVO param = new PurSsDParamVO();
        param.setMasId(masId);
        JPAQuery<PurSsDRespVO> jpaQuery = this.purSsDRepoProc.select(param);
        List purSsDRespVOS = jpaQuery.fetch();
        this.translate(purSsDRespVOS);
        return purSsDRespVOS;
    }

    private void translate(List<PurSsDRespVO> purSsDRespVOS) {
        if (purSsDRespVOS == null || purSsDRespVOS.size() == 0) {
            return;
        }
        List itemIds = purSsDRespVOS.stream().map(PurSsDRespVO::getItemId).distinct().collect(Collectors.toList());
        ItmItemPartParam itmItemPartParam = new ItmItemPartParam();
        itmItemPartParam.setIds(itemIds);
        List<ItmItemDTO> itemVOS = this.outService.itmItemAllSearch(itmItemPartParam);
        Optional<Long> relateDocIdOptional = purSsDRespVOS.stream().map(PurSsDRespVO::getRelateDocId).findFirst();
        List<PurPoDRespVO> purPoDVOS = this.outService.findPurPoDByMasId(relateDocIdOptional.get());
        purSsDRespVOS.forEach(VO -> {
            Optional<PurPoDRespVO> purPoDVOOptional;
            Optional<ItmItemDTO> itmItemVOOptional = itemVOS.stream().filter(i -> i.getId().equals(VO.getItemId())).findFirst();
            if (itmItemVOOptional.isPresent()) {
                ItmItemDTO itmItemVO = itmItemVOOptional.get();
                VO.setItemCode(itmItemVO.getItemCode());
                VO.setItemName(itmItemVO.getItemName());
                VO.setItemSpec(itmItemVO.getPackageSpec());
                VO.setBarcode(itmItemVO.getBarCode());
                if (!StringUtils.isEmpty((Object)VO.getDeter2()) && StringUtils.isEmpty((Object)VO.getDeter1())) {
                    VO.setDeter1(itmItemVO.getTempType());
                }
            }
            if (UdcEnum.COM_DOC_CLS_PO.getValueCode().equals(VO.getRelateDocCls()) && (purPoDVOOptional = purPoDVOS.stream().filter(pod -> pod.getId().equals(VO.getRelateDocDid())).findFirst()).isPresent()) {
                PurPoDRespVO purPoDVO = purPoDVOOptional.get();
                VO.setPoQty(purPoDVO.getQty());
                VO.setAcceptQty(purPoDVO.getAcceptQty());
                VO.setAcceptUom(purPoDVO.getAcceptUom());
                VO.setShippedQty(purPoDVO.getShippedQty());
                VO.setShipmentUom(purPoDVO.getShipmentUom());
                VO.setAcUnshipQty(purPoDVO.getAcUnshipQty());
            }
        });
    }

    @Transactional
    public Long createOne(PurSsDRespVO purSsDRespVO) {
        return ((PurSsDDO)this.purSsDRepo.save(PurSsDConvert.INSTANCE.voToDO(purSsDRespVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<PurSsDRespVO> list) {
        return this.purSsDRepo.saveAll(list.stream().map(PurSsDConvert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(PurSsDRespVO objVo) {
        PurSsDDO purSsDDO = PurSsDConvert.INSTANCE.voToDO(objVo);
        Optional optional = this.purSsDRepo.findById(purSsDDO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objVo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objVo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objVo));
        this.purSsDRepo.save((PurSsDDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QPurSsDDO jpaQDo = QPurSsDDO.purSsDDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.purSsDRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        PurSsDDO do1 = (PurSsDDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.purSsDRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.purSsDRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(arg_0 -> ((PurSsDRepo)this.purSsDRepo).deleteById(arg_0));
    }

    public void deleteByMasId(Long masId) {
        this.purSsDRepo.deleteByMasId(masId);
    }

    public PurSsDServiceImpl(PurSsDRepo purSsDRepo, PurSsDRepoProc purSsDRepoProc, PurGrDService purGrDService, OutService outService) {
        this.purSsDRepo = purSsDRepo;
        this.purSsDRepoProc = purSsDRepoProc;
        this.purGrDService = purGrDService;
        this.outService = outService;
    }
}

