/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.dto.InvSuppVO;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.org.vo.OrgOuVO;
import com.elitesland.pur.convert.PurSsConvert;
import com.elitesland.pur.entity.PurSsDO;
import com.elitesland.pur.entity.QPurSsDO;
import com.elitesland.pur.repo.PurSsRepo;
import com.elitesland.pur.repo.PurSsRepoProc;
import com.elitesland.pur.service.PurSsDService;
import com.elitesland.pur.service.PurSsService;
import com.elitesland.pur.vo.param.PurSsParamVO;
import com.elitesland.pur.vo.resp.PurSsRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purSsService")
public class PurSsServiceImpl
implements PurSsService {
    private final PurSsRepo purSsRepo;
    private final PurSsRepoProc purSsRepoProc;
    private final PurSsDService purSsDService;
    private final InvWhService invWhService;
    private final OrgOuService orgOuService;

    @SysCodeProc
    public PagingVO<PurSsRespVO> search(PurSsParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.purSsRepoProc.select(null).where(this.purSsRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        this.purSsRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QPurSsDO.purSsDO);
        List lists = jpaQuery.fetch();
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    @SysCodeProc
    public Optional<PurSsRespVO> findCodeOne(String docNo) {
        JPAQuery<PurSsRespVO> jpaQuery = this.purSsRepoProc.select(null);
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        jpaQuery.where((Predicate)jpaQDo.docNo.eq((Object)docNo));
        PurSsRespVO vo = (PurSsRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<PurSsRespVO> findIdOne(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        JPAQuery<PurSsRespVO> jpaQuery = this.purSsRepoProc.select(null);
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        PurSsRespVO vo = (PurSsRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public List<PurSsRespVO> findIdBatch(List<Long> idList) {
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        JPAQuery where = (JPAQuery)this.purSsRepoProc.select(null).where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @Transactional
    public Long createOne(PurSsRespVO purSsRespVO) {
        return ((PurSsDO)this.purSsRepo.save(PurSsConvert.INSTANCE.voToDO(purSsRespVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<PurSsRespVO> list) {
        return this.purSsRepo.saveAll(list.stream().map(PurSsConvert.INSTANCE::voToDO).collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(PurSsRespVO objVo) {
        Optional optional = this.purSsRepo.findById(objVo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objVo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objVo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objVo));
        this.purSsRepo.save((PurSsDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.purSsRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        PurSsDO do1 = (PurSsDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.purSsRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.purSsRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(arg_0 -> ((PurSsRepo)this.purSsRepo).deleteById(arg_0));
    }

    @SysCodeProc
    public Optional<PurSsRespVO> findPurSsOne(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        JPAQuery<PurSsRespVO> jpaQuery = this.purSsRepoProc.select(null);
        QPurSsDO jpaQDo = QPurSsDO.purSsDO;
        jpaQuery.where((Predicate)jpaQDo.id.eq((Object)id));
        PurSsRespVO vo = (PurSsRespVO)jpaQuery.fetchOne();
        if (vo != null) {
            this.translate(List.of(vo));
            ArrayList<String> docNos = new ArrayList<String>();
            docNos.add(vo.getRelateDocNo());
            Optional poVOOptional = null;
            poVOOptional.ifPresent(i -> vo.setSuppDocNo1(i.getSuppDocNo()));
            vo.setPurSsDRespVOList(this.purSsDService.findByMasId(id));
        }
        return Optional.ofNullable(vo);
    }

    public List<PurSsRespVO> findByRelateDocIds(List<Long> longs) {
        return this.purSsRepo.findByRelateDocIdIn(longs).stream().map(PurSsConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    private void translate(List<PurSsRespVO> lists) {
        if (lists == null || lists.size() == 0) {
            return;
        }
        List ouIds = lists.stream().map(PurSsRespVO::getOuId).distinct().collect(Collectors.toList());
        List suppIds = lists.stream().map(PurSsRespVO::getSuppId).distinct().collect(Collectors.toList());
        List whIds = lists.stream().map(PurSsRespVO::getWhId).distinct().collect(Collectors.toList());
        List orgSuppList = Collections.emptyList();
        List orgWhList = this.invWhService.findIdBatch(whIds);
        List orgOuList = Collections.emptyList();
        lists.forEach(VO -> {
            Optional<InvWhRespVO> orgWhVOOptional;
            Optional<InvSuppVO> suppVOOptional;
            Optional<OrgOuVO> ouVOOptional = orgOuList.stream().filter(v -> v.getId().equals(VO.getOuId())).findFirst();
            if (ouVOOptional.isPresent()) {
                OrgOuVO orgOuVO = ouVOOptional.get();
                VO.setOuCode(orgOuVO.getCode());
                VO.setOuName(orgOuVO.getName());
            }
            if ((suppVOOptional = orgSuppList.stream().filter(v -> v.getId().equals(VO.getSuppId())).findFirst()).isPresent()) {
                InvSuppVO invSuppVO = suppVOOptional.get();
                VO.setSuppCode(invSuppVO.getSuppCode());
                VO.setSuppName(invSuppVO.getSuppName());
            }
            if ((orgWhVOOptional = orgWhList.stream().filter(v -> v.getId().equals(VO.getWhId())).findFirst()).isPresent()) {
                InvWhRespVO orgWhVO = orgWhVOOptional.get();
                VO.setWhCode(orgWhVO.getWhCode());
                VO.setWhName(orgWhVO.getWhName());
                VO.setWhName(orgWhVO.getWhName());
                VO.setWhType(orgWhVO.getWhType());
            }
        });
    }

    public PurSsServiceImpl(PurSsRepo purSsRepo, PurSsRepoProc purSsRepoProc, PurSsDService purSsDService, InvWhService invWhService, OrgOuService orgOuService) {
        this.purSsRepo = purSsRepo;
        this.purSsRepoProc = purSsRepoProc;
        this.purSsDService = purSsDService;
        this.invWhService = invWhService;
        this.orgOuService = orgOuService;
    }
}

