/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.pur.service;

import com.elitesland.core.exception.BusinessException;
import com.elitesland.pur.service.PurTaskService;
import com.elitesland.pur.vo.constant.TaskEnum;
import com.elitesland.util.RedisUtils;
import com.elitesland.util.UUIDUtil;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service(value="purTaskService")
public class PurTaskServiceImpl
implements PurTaskService {
    private final RedisUtils redisUtils;

    public String applyTask(TaskEnum taskModel) {
        return this.applyTask(taskModel, 1);
    }

    public String applyTask(TaskEnum taskModel, Integer taskSize) {
        taskSize = Objects.isNull(taskSize) || taskSize == 0 ? 1 : taskSize;
        String taskId = UUIDUtil.getUUID();
        HashMap<String, Integer> sizeMap = new HashMap<String, Integer>();
        sizeMap.put("total", taskSize);
        sizeMap.put("progress", taskSize);
        boolean success = this.redisUtils.hmset(this.buildTaskKey(taskModel, taskId), sizeMap);
        if (!success) {
            taskId = null;
        }
        return taskId;
    }

    public boolean appenErrorMsg(TaskEnum taskModel, String taskId, String errorMsg) {
        return this.errorMsg(taskModel, taskId, errorMsg, true);
    }

    public boolean errorMsg(TaskEnum taskModel, String taskId, String errorMsg, Boolean append) {
        String taskKey = this.buildTaskKey(taskModel, taskId);
        boolean exist = this.redisUtils.hasKey(taskKey);
        if (exist) {
            if (append.booleanValue()) {
                Object error = this.redisUtils.hget(taskKey, "error");
                if (!Objects.isNull(error)) {
                    error = error + ",";
                }
                errorMsg = (Objects.isNull(error) ? "" : error) + (String)errorMsg;
            }
            return this.redisUtils.hset(taskKey, "error", errorMsg);
        }
        return false;
    }

    public boolean updateProgress(TaskEnum taskModel, String taskId) {
        String taskKey = this.buildTaskKey(taskModel, taskId);
        boolean exist = this.redisUtils.hasKey(taskKey);
        if (!exist) {
            throw new BusinessException("\u4efb\u52a1[" + taskKey + "]\u4e0d\u5b58\u5728\uff01");
        }
        Object redisData = this.redisUtils.hget(taskKey, "progress");
        Integer progress = Integer.valueOf(redisData.toString().replace(".0", ""));
        if (progress == 0) {
            throw new BusinessException("\u4efb\u52a1[" + taskKey + "]\u5df2\u7ed3\u675f\uff01");
        }
        return this.redisUtils.hset(taskKey, "progress", (Object)(progress - 1));
    }

    private String buildTaskKey(TaskEnum taskModel, String taskId) {
        return taskModel.getTaskModel() + "_" + taskId;
    }

    public PurTaskServiceImpl(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }
}

