/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.ComC2VO;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.service.InvItemPkgService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.resp.InvItemPkgRespVO;
import com.elitesland.item.vo.InvItemPkgVO;
import com.elitesland.sal.convert.SalDodCovert;
import com.elitesland.sal.entity.QSalDoDDO;
import com.elitesland.sal.entity.QSalSoDDO;
import com.elitesland.sal.entity.SalDoDDO;
import com.elitesland.sal.entity.SalSoAllocDO;
import com.elitesland.sal.param.SalDoDQueryParamVO;
import com.elitesland.sal.repo.SalDoDRepo;
import com.elitesland.sal.repo.SalDoDRepoProc;
import com.elitesland.sal.repo.SalSoAllocRepo;
import com.elitesland.sal.service.SalDoDService;
import com.elitesland.sal.service.SalDoService;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.service.SalSoDService;
import com.elitesland.sal.vo.resp.SalDoDRespVO;
import com.elitesland.sal.vo.resp.SalDoRespVO;
import com.elitesland.sal.vo.resp.SalRdoDRespVO;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.sal.vo.resp.SalSoDRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.entity.SysUserDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="salDoDService")
public class SalDoDServiceImpl
implements SalDoDService {
    private final SalDoDRepo salDodRepo;
    private final SalDoDRepoProc salDoDRepoproc;
    private SalDoService salDoService;
    private SalSoAllocService salSoAllocService;
    private final SalSoDService salSoDService;
    private final SalSoAllocRepo salSoAllocRepo;
    private final InvItemPkgService invItemPkgService;

    SalDoDRespVO trancreatesaldod(SalSoDRespVO a) {
        SalDoDRespVO salDodVo = new SalDoDRespVO();
        salDodVo.setOuId(a.getOuId() != null ? a.getOuId() : null);
        salDodVo.setRelateDocLineno(a.getLineNo() != null ? a.getLineNo() : null);
        salDodVo.setLineType(a.getLineType());
        salDodVo.setRecvWhId(a.getRecvWhId());
        salDodVo.setRecvDeter1(a.getRecvDeter1());
        salDodVo.setRecvDeter2(a.getRecvDeter2());
        salDodVo.setRecvDeter3(a.getRecvDeter3());
        salDodVo.setVolume(a.getVolume());
        salDodVo.setRelateDocCls(UdcEnum.COM_DOC_CLS_SO.getValueCode());
        salDodVo.setBuId(a.getBuId());
        salDodVo.setBdId(a.getBdId());
        salDodVo.setPcId(a.getPcId());
        salDodVo.setTransPrice(a.getTransPrice());
        salDodVo.setItemCode(a.getItemCode());
        salDodVo.setItemName(a.getItemName());
        salDodVo.setBarcode(a.getBarcode());
        salDodVo.setItemId(a.getItemId());
        salDodVo.setCurrCode(a.getCurrCode());
        salDodVo.setCurrRate(a.getCurrRate());
        salDodVo.setPackUom(a.getPackUom());
        salDodVo.setPackQty(a.getPackQty());
        salDodVo.setUomRatio(a.getUomRatio());
        salDodVo.setCostPrice(a.getCostPrice());
        salDodVo.setEs1(a.getEs1());
        salDodVo.setNetWeight(a.getNetWeight());
        salDodVo.setCreateTime(LocalDateTime.now());
        salDodVo.setModifyTime(LocalDateTime.now());
        salDodVo.setItemCsCode(a.getItemCsCode() != null ? a.getItemCsCode() : null);
        salDodVo.setModifyUserId(a.getModifyUserId() != null ? a.getModifyUserId() : null);
        salDodVo.setGrossWeight(a.getGrossWeight() != null ? a.getGrossWeight() : null);
        salDodVo.setDeter1(a.getDeter1() != null ? a.getDeter1() : null);
        salDodVo.setDeter2(a.getDeter2() != null ? a.getDeter2() : null);
        salDodVo.setDeter3(a.getDeter3() != null ? a.getDeter3() : null);
        if (a.getCancelQty() == null) {
            a.setCancelQty(Double.valueOf(0.0));
        }
        if (a.getShippedQty() == null) {
            a.setShippedQty(Double.valueOf(0.0));
        }
        salDodVo.setMasId(a.getMasId() != null ? a.getMasId() : null);
        salDodVo.setItemId(a.getItemId() != null ? a.getItemId() : null);
        salDodVo.setRelateDocNo(a.getRelateDocNo() != null ? a.getRelateDocNo() : null);
        salDodVo.setRelateDocId(a.getMasId() != null ? a.getMasId() : null);
        salDodVo.setRelateDocDid(a.getId() != null ? a.getId() : null);
        salDodVo.setTransPrice(a.getTransPrice() != null ? a.getTransPrice() : new BigDecimal(0.0));
        salDodVo.setTaxRate(Double.valueOf(a.getTaxRate() != null ? a.getTaxRate() : 0.0));
        salDodVo.setNetPrice(a.getNetPrice() != null ? a.getNetPrice() : new BigDecimal(0.0));
        salDodVo.setBasePrice(a.getBasePrice());
        salDodVo.setCostPrice(a.getCostPrice());
        BigDecimal multiply3 = new BigDecimal(salDodVo.getTaxRate()).multiply(salDodVo.getTransPrice());
        salDodVo.setTransTaxPrice(salDodVo.getTransPrice().add(multiply3));
        BigDecimal multiply2 = new BigDecimal(salDodVo.getTaxRate()).multiply(salDodVo.getNetPrice());
        salDodVo.setPrice(salDodVo.getNetPrice().add(multiply2));
        return salDodVo;
    }

    SalDoDRespVO salSoAllocTranSalDoD(SalSoAllocRespVO salSoAllocVO, SalDoDRespVO salDodRespVO, BigDecimal price) {
        salDodRespVO.setLotNo(salSoAllocVO.getLotNo() != null ? salSoAllocVO.getLotNo() : null);
        salDodRespVO.setSoAllocId(salSoAllocVO.getId() != null ? salSoAllocVO.getId() : null);
        salDodRespVO.setWhId(salSoAllocVO.getWhId() != null ? salSoAllocVO.getWhId() : null);
        salDodRespVO.setDeter2(salSoAllocVO.getDeter2() != null ? salSoAllocVO.getDeter2() : null);
        salDodRespVO.setWhLoc(salSoAllocVO.getWhLoc() != null ? salSoAllocVO.getWhLoc() : null);
        salDodRespVO.setWhPosi(salSoAllocVO.getWhPosi() != null ? salSoAllocVO.getWhPosi() : null);
        if (salSoAllocVO.getAllocQty() == null) {
            salSoAllocVO.setAllocQty(Double.valueOf(0.0));
        }
        if (salSoAllocVO.getShippedQty() == null) {
            salSoAllocVO.setShippedQty(Double.valueOf(0.0));
        }
        List<SalDoDRespVO> byrelateDocDidqty = this.findByrelateDocDidqty(salSoAllocVO.getId());
        double saldodqty = 0.0;
        if (byrelateDocDidqty != null) {
            saldodqty = byrelateDocDidqty.stream().filter(saldodd -> saldodd.getQty() != null).mapToDouble(SalDoDRespVO::getQty).sum();
        }
        salDodRespVO.setQty(Double.valueOf(salSoAllocVO.getAllocQty() != null && salSoAllocVO.getShippedQty() != null ? salSoAllocVO.getAllocQty() - salSoAllocVO.getShippedQty() - saldodqty : 0.0));
        salDodRespVO.setSoQty(Double.valueOf(salDodRespVO.getSoQty() != null ? salDodRespVO.getSoQty() : 0.0));
        salDodRespVO.setUomRatio(Double.valueOf(salDodRespVO.getUomRatio() != null ? salDodRespVO.getUomRatio() : 0.0));
        salDodRespVO.setUomQty(salDodRespVO.getUomRatio() != null && salDodRespVO.getQty() != null ? Double.valueOf(salDodRespVO.getQty() / salDodRespVO.getUomRatio()) : null);
        salDodRespVO.setUntilExpireDays(salSoAllocVO.getUntilExpireDays() != null ? salSoAllocVO.getUntilExpireDays() : null);
        salDodRespVO.setFressType(salSoAllocVO.getFressType() != null ? salSoAllocVO.getFressType() : null);
        salDodRespVO.setAapFlag(salSoAllocVO.getAapFlag() != null ? salSoAllocVO.getAapFlag() : null);
        salDodRespVO.setNetAmt(salDodRespVO.getQty() != null && salDodRespVO.getTransPrice() != null ? BigDecimal.valueOf(salDodRespVO.getQty()).multiply(salDodRespVO.getTransPrice()) : null);
        salDodRespVO.setAmt(salDodRespVO.getQty() != null && price != null ? BigDecimal.valueOf(salDodRespVO.getQty()).multiply(price) : null);
        salDodRespVO.setTaxAmt(salDodRespVO.getAmt() != null && salDodRespVO.getNetAmt() != null ? salDodRespVO.getAmt().subtract(salDodRespVO.getNetAmt()) : null);
        return salDodRespVO;
    }

    private SalDoDRespVO salSodTranQtySalDo(SalSoDRespVO a, SalDoDRespVO salDodVo, BigDecimal price) {
        if (salDodVo.getSoQty() == null) {
            salDodVo.setSoQty(Double.valueOf(0.0));
        }
        if (salDodVo.getCancelQty() == null) {
            salDodVo.setCancelQty(Double.valueOf(0.0));
        }
        List<SalDoDRespVO> byrelateDocDidqty = this.findByrelateDocDidqty(a.getId());
        double saldodqty = 0.0;
        if (byrelateDocDidqty != null) {
            saldodqty = byrelateDocDidqty.stream().filter(saldodd -> saldodd.getQty() != null).mapToDouble(SalDoDRespVO::getQty).sum();
        }
        salDodVo.setQty(salDodVo.getSoQty() != null && salDodVo.getCancelQty() != null ? Double.valueOf(salDodVo.getSoQty() - salDodVo.getCancelQty() - saldodqty) : null);
        salDodVo.setUomQty(salDodVo.getUomRatio() != null && salDodVo.getQty() != null ? Double.valueOf(salDodVo.getQty() / salDodVo.getUomRatio()) : null);
        salDodVo.setNetAmt(salDodVo.getQty() != null && salDodVo.getTransPrice() != null ? BigDecimal.valueOf(salDodVo.getQty()).multiply(salDodVo.getTransPrice()) : null);
        salDodVo.setAmt(salDodVo.getQty() != null && price != null ? BigDecimal.valueOf(salDodVo.getQty()).multiply(price) : null);
        salDodVo.setTaxAmt(salDodVo.getAmt() != null && salDodVo.getNetAmt() != null ? salDodVo.getAmt().subtract(salDodVo.getNetAmt()) : null);
        return salDodVo;
    }

    @Override
    @SysCodeProc
    public List<SalDoDRespVO> createsaldod(Long id) throws ExecutionException, InterruptedException {
        List<SalSoDRespVO> records = this.salSoDService.findmaxIdOne(id);
        List<Long> collect = records.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<Object> salSoAllocVoS = new ArrayList();
        try {
            salSoAllocVoS = this.salSoAllocService.findLotNoSodIdBatch(collect);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SalDoDRespVO> salDodVos = new ArrayList<SalDoDRespVO>();
        List<Object> finalSalSoAllocVoS = salSoAllocVoS;
        records.stream().forEach(a -> {
            SalDoDRespVO salDodVo = this.trancreatesaldod((SalSoDRespVO)a);
            BigDecimal multiply = new BigDecimal(salDodVo.getTaxRate()).multiply(salDodVo.getTransPrice());
            BigDecimal price = salDodVo.getTransPrice().add(multiply);
            finalSalSoAllocVoS.stream().forEach(salSoAllocVO -> {
                if (salSoAllocVO.getSoDId().equals(a.getId())) {
                    salDodVo.setSoAllocId(salSoAllocVO.getId());
                    SalDoDRespVO salDodVo2 = new SalDoDRespVO();
                    BeanUtils.copyProperties((Object)salDodVo, (Object)salDodVo2);
                    salDodVos.add(this.salSoAllocTranSalDoD((SalSoAllocRespVO)salSoAllocVO, salDodVo2, price));
                }
            });
            if (salDodVo.getSoAllocId() == null) {
                salDodVos.add(this.salSodTranQtySalDo((SalSoDRespVO)a, salDodVo, price));
            }
        });
        return salDodVos;
    }

    @Override
    public List<Long> findMasIdByLike(String keyword) {
        JPAQuery<Long> where = this.salDoDRepoproc.selectMasId(keyword);
        return where.fetch();
    }

    @Override
    public List<Long> findReturnedQtyEqQty2Ids() {
        List salDodDoS = ((JPAQuery)this.salDoDRepoproc.select(null).where((Predicate)QSalDoDDO.salDoDDO.returnedQty.isNotNull().and((Predicate)QSalDoDDO.salDoDDO.qty2.isNotNull()).and((Predicate)QSalDoDDO.salDoDDO.qty2.loe(QSalDoDDO.salDoDDO.returnedQty)).or((Predicate)QSalDoDDO.salDoDDO.qty2.eq((Object)0.0).or((Predicate)QSalDoDDO.salDoDDO.qty2.isNull())))).fetch();
        return salDodDoS.stream().map(salDodRespVO -> salDodRespVO.getMasId()).distinct().collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<SalDoDRespVO> findByMasId(List<Long> ids) throws ExecutionException, InterruptedException {
        SalDoDQueryParamVO param = new SalDoDQueryParamVO();
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoDRepoproc.select(null).where((Predicate)salDod.masId.in(ids));
        List lists = jpaQuery.fetch();
        this.proceMas(lists);
        return lists;
    }

    @Override
    @SysCodeProc
    public List<SalRdoDRespVO> findByrMasId(List<Long> ids) throws ExecutionException, InterruptedException {
        SalDoDQueryParamVO param = new SalDoDQueryParamVO();
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoDRepoproc.selectR(null).where((Predicate)salDod.masId.in(ids));
        List lists = jpaQuery.fetch();
        this.proceRmas(lists);
        return lists;
    }

    @Override
    @SysCodeProc
    public List<SalRdoDRespVO> findByRmasId(List<Long> ids) throws ExecutionException, InterruptedException {
        SalDoDQueryParamVO param = new SalDoDQueryParamVO();
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoDRepoproc.selectR(null).where((Predicate)salDod.masId.in(ids));
        List lists = jpaQuery.fetch();
        this.proceRmas(lists);
        return lists;
    }

    @SysCodeProc
    List<SalDoDRespVO> proceMas(List<SalDoDRespVO> lists) throws ExecutionException, InterruptedException {
        List itemIds = lists.stream().map(SalDoDRespVO::getItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List modifyUserIds = lists.stream().map(SalDoDRespVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List masId = lists.stream().map(SalDoDRespVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List soalloc = lists.stream().map(SalDoDRespVO::getSoAllocId).filter(Objects::nonNull).collect(Collectors.toList());
        List lotNoS = lists.stream().map(v -> v.getItemId() + "_" + v.getVariId() + "_" + v.getLotNo()).filter(Objects::nonNull).collect(Collectors.toList());
        List brandids = lists.stream().map(SalDoDRespVO::getBrand).filter(Objects::nonNull).collect(Collectors.toList());
        List salSoAllocVOList = this.salSoAllocRepo.findAllById(soalloc);
        ArrayList itmItemVoS = new ArrayList();
        List itmItemPkgVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(itemIds)) {
            try {
                itmItemPkgVoS = this.invItemPkgService.findByItemIdIn(itemIds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(modifyUserIds)) {
            // empty if block
        }
        ArrayList byAndItemIdAndLotNo = new ArrayList();
        if (!CollectionUtils.isEmpty(lotNoS)) {
            // empty if block
        }
        List finalItmItemPkgVoS = itmItemPkgVoS;
        lists.stream().forEach(v -> {
            Optional<SalSoAllocDO> first;
            if (v.getSoAllocId() != null && (first = salSoAllocVOList.stream().filter(o -> v.getSoAllocId().equals(o.getId())).findFirst()).isPresent()) {
                v.setLotNo(first.get().getLotNo());
                v.setShipQty(first.get().getShippedQty());
            }
            if (v.getModifyUserId() != null && (first = sysUserDoS.stream().filter(e -> v.getModifyUserId().equals(e.getId())).findFirst()).isPresent()) {
                v.setEmpName(((SysUserDO)first.get()).getUsername());
            }
            if (v.getItemId() != null) {
                Optional<InvItemPkgRespVO> first2;
                first = itmItemVoS.stream().filter(i -> v.getItemId().equals(i.getId())).findFirst();
                if (first.isPresent()) {
                    v.setBrand(((ItmItemVO)first.get()).getBrand());
                    v.setBrandName(((ItmItemVO)first.get()).getBrandName());
                    v.setBrand2(((ItmItemVO)first.get()).getBrand2());
                    v.setBrand2Name(((ItmItemVO)first.get()).getBrand2Name());
                    v.setAgency(((ItmItemVO)first.get()).getAgency());
                    v.setItemCode(((ItmItemVO)first.get()).getItemCode());
                    v.setItemName(((ItmItemVO)first.get()).getItemName());
                    v.setItemSpec(((ItmItemVO)first.get()).getPackageSpec());
                    v.setUom(((ItmItemVO)first.get()).getUom());
                }
                if ((first2 = finalItmItemPkgVoS.stream().filter(t -> v.getItemId().equals(t.getItemId())).findFirst()).isPresent()) {
                    if (first2.get().getVolume() != null) {
                        v.setVolume(Double.valueOf(String.valueOf(first2.get().getVolume())));
                    }
                    v.setWeightUom(first2.get().getWeightUom());
                }
            }
            if ((first = byAndItemIdAndLotNo.stream().filter(b -> (v.getLotNo() + v.getVariId() + v.getItemId()).equals(b.getLotNo() + b.getVariId() + b.getItemId())).findFirst()).isPresent()) {
                v.setManuDate(((InvLotVO)first.get()).getManuDate());
                v.setExpireDate(((InvLotVO)first.get()).getExpireDate());
            }
        });
        return lists;
    }

    @SysCodeProc
    List<SalRdoDRespVO> proceRmas(List<SalRdoDRespVO> lists) throws ExecutionException, InterruptedException {
        List itemIds = lists.stream().map(SalRdoDRespVO::getItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List modifyUserIds = lists.stream().map(SalRdoDRespVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List masId = lists.stream().map(SalRdoDRespVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List soalloc = lists.stream().map(SalRdoDRespVO::getSoAllocId).filter(Objects::nonNull).collect(Collectors.toList());
        List lotNoS = lists.stream().map(v -> v.getItemId() + "_" + v.getVariId() + "_" + v.getLotNo()).filter(Objects::nonNull).collect(Collectors.toList());
        List brandids = lists.stream().map(SalRdoDRespVO::getBrand).filter(Objects::nonNull).collect(Collectors.toList());
        List salSoAllocVOList = this.salSoAllocRepo.findAllById(soalloc);
        ArrayList itmItemVoS = new ArrayList();
        ArrayList itmItemPkgVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(itemIds)) {
            // empty if block
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(modifyUserIds)) {
            // empty if block
        }
        ArrayList byAndItemIdAndLotNo = new ArrayList();
        if (!CollectionUtils.isEmpty(lotNoS)) {
            // empty if block
        }
        lists.stream().forEach(v -> {
            Optional<SalSoAllocDO> first;
            if (v.getSoAllocId() != null && (first = salSoAllocVOList.stream().filter(o -> v.getSoAllocId().equals(o.getId())).findFirst()).isPresent()) {
                v.setLotNo(first.get().getLotNo());
                v.setShipQty(first.get().getShippedQty());
            }
            if (v.getModifyUserId() != null && (first = sysUserDoS.stream().filter(e -> v.getModifyUserId().equals(e.getId())).findFirst()).isPresent()) {
                v.setEmpName(((SysUserDO)first.get()).getUsername());
            }
            if (v.getItemId() != null) {
                Optional<InvItemPkgVO> first2;
                first = itmItemVoS.stream().filter(i -> v.getItemId().equals(i.getId())).findFirst();
                if (first.isPresent()) {
                    v.setBrand(((ItmItemVO)first.get()).getBrand());
                    v.setBrandName(((ItmItemVO)first.get()).getBrandName());
                    v.setBrand2(((ItmItemVO)first.get()).getBrand2());
                    v.setBrand2Name(((ItmItemVO)first.get()).getBrand2Name());
                    v.setAgency(((ItmItemVO)first.get()).getAgency());
                    v.setItemCode(((ItmItemVO)first.get()).getItemCode());
                    v.setItemName(((ItmItemVO)first.get()).getItemName());
                    v.setItemSpec(((ItmItemVO)first.get()).getPackageSpec());
                    v.setUom(((ItmItemVO)first.get()).getUom());
                }
                if ((first2 = itmItemPkgVoS.stream().filter(t -> v.getItemId().equals(t.getItemId())).findFirst()).isPresent()) {
                    if (first2.get().getVolume() != null) {
                        v.setVolume(Double.valueOf(String.valueOf(first2.get().getVolume())));
                    }
                    v.setWeightUom(first2.get().getWeightUom());
                }
            }
            if ((first = byAndItemIdAndLotNo.stream().filter(b -> (v.getLotNo() + v.getVariId() + v.getItemId()).equals(b.getLotNo() + b.getVariId() + b.getItemId())).findFirst()).isPresent()) {
                v.setManuDate(((InvLotVO)first.get()).getManuDate());
                v.setExpireDate(((InvLotVO)first.get()).getExpireDate());
            }
        });
        List brands = lists.stream().map(SalRdoDRespVO::getBrand).filter(Objects::nonNull).collect(Collectors.toList());
        List brands2 = lists.stream().map(SalRdoDRespVO::getBrand2).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList comC2VO = new ArrayList();
        if (!CollectionUtils.isEmpty(brands)) {
            // empty if block
        }
        ArrayList comC2Vo2 = new ArrayList();
        if (!CollectionUtils.isEmpty(brands2)) {
            // empty if block
        }
        lists.stream().forEach(v -> {
            Optional<ComC2VO> first;
            if (!StringUtils.isEmpty((Object)v.getBrand()) && (first = comC2VO.stream().filter(o -> v.getBrand().equals(o.getC2Code())).findFirst()).isPresent()) {
                v.setBrandName(first.get().getC2Name());
            }
            if (v.getBrand2() != null && (first = comC2Vo2.stream().filter(o -> v.getBrand2().equals(o.getC2Code())).findFirst()).isPresent()) {
                v.setBrand2Name(first.get().getC2Name());
            }
        });
        return lists;
    }

    @Autowired
    @Lazy
    public void setSalDodService(SalDoService salDoService) {
        this.salDoService = salDoService;
    }

    @Override
    @SysCodeProc
    public List<SalDoDRespVO> findByMasId(Long id) throws ExecutionException, InterruptedException {
        SalDoDQueryParamVO param = new SalDoDQueryParamVO();
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoDRepoproc.select(null).where((Predicate)salDod.masId.eq((Object)id));
        List lists = jpaQuery.fetch();
        lists.stream().forEach(v -> {
            v.setSoQty(v.getQty());
            v.setQty(Double.valueOf(v.getQty() != null ? v.getQty() : 0.0));
            v.setUomRatio(Double.valueOf(v.getUomRatio() != null ? v.getUomRatio() : 0.0));
            v.setUomQty(v.getUomRatio() != null && v.getQty() != null ? Double.valueOf(v.getQty() / v.getUomRatio()) : null);
        });
        this.proceMas(lists);
        return lists;
    }

    @Override
    @SysCodeProc
    public List<SalRdoDRespVO> findByrMasId(Long id) throws ExecutionException, InterruptedException {
        SalDoDQueryParamVO param = new SalDoDQueryParamVO();
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoDRepoproc.selectR(null).where((Predicate)salDod.masId.eq((Object)id));
        List lists = jpaQuery.fetch();
        lists.stream().forEach(v -> {
            v.setSoQty(v.getQty());
            v.setQty(Double.valueOf(v.getQty() != null ? v.getQty() : 0.0));
            v.setUomRatio(Double.valueOf(v.getUomRatio() != null ? v.getUomRatio() : 0.0));
            v.setUomQty(v.getUomRatio() != null && v.getQty() != null ? Double.valueOf(v.getQty() / v.getUomRatio()) : null);
        });
        this.proceRmas(lists);
        return lists;
    }

    @Override
    public List<SalDoDRespVO> findByRelateDocIds(List<Long> relateDocIds) {
        List lists = ((JPAQuery)this.salDoDRepoproc.selectRelateDocId(null).where((Predicate)QSalDoDDO.salDoDDO.relateDocId.in(relateDocIds))).fetch();
        List<Long> collect1 = lists.stream().map(SalDoDRespVO::getMasId).collect(Collectors.toList());
        List<SalDoRespVO> byIds = this.salDoService.findByIds(collect1);
        ArrayList<SalDoDRespVO> salDodVoS = new ArrayList<SalDoDRespVO>();
        if (collect1.size() > 0) {
            lists.stream().forEach(v -> byIds.stream().forEachOrdered(o -> {
                if (v.getMasId().equals(o.getId()) && UdcEnum.SAL_DO_STATUS_WT.getValueCode().equals(o.getDocStatus())) {
                    v.setQty(Double.valueOf(v.getQty() == null ? 0.0 : v.getQty()));
                    salDodVoS.add((SalDoDRespVO)v);
                }
            }));
        }
        return salDodVoS;
    }

    @Override
    public List<SalDoDRespVO> findByrelateDocDidqty(Long id) {
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        JPAQuery where = (JPAQuery)this.salDoDRepoproc.selectRelateDocId(null).where((Predicate)salDod.soAllocId.eq((Object)id));
        List lists = where.fetch();
        List<Long> collect1 = lists.stream().map(SalDoDRespVO::getMasId).collect(Collectors.toList());
        List<SalDoRespVO> byIds = this.salDoService.findByIds(collect1);
        ArrayList<SalDoDRespVO> salDodVoS = new ArrayList<SalDoDRespVO>();
        if (collect1.size() > 0) {
            lists.stream().forEach(v -> byIds.stream().forEachOrdered(o -> {
                if (v.getMasId().equals(o.getId()) && UdcEnum.SAL_DO_STATUS_WT.getValueCode().equals(o.getDocStatus())) {
                    salDodVoS.add((SalDoDRespVO)v);
                }
            }));
        }
        return salDodVoS;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalDoDRespVO> search(SalDoDQueryParamVO param) {
        Page ret = this.salDodRepo.findAll(this.salDoDRepoproc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().map(SalDodCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(collect).build();
    }

    @Override
    @SysCodeProc
    public Optional<SalDoDRespVO> findIdOne(Long id) {
        return this.salDodRepo.findById(id).map(SalDodCovert.INSTANCE::doToRespVO);
    }

    @Override
    public List<SalDoDRespVO> findIdBatch(List<Long> idList) {
        return this.salDodRepo.findAllById(idList).stream().map(SalDodCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.salDodRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.salDodRepo.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        BooleanExpression predicate = salDod.isNotNull();
        Optional optionalItem = this.salDodRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salDod.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalDoDDO do1 = (SalDoDDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salDodRepo.save(do1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        ids.forEach(id -> {
            QSalDoDDO salDod = QSalDoDDO.salDoDDO;
            BooleanExpression predicate = salDod.isNotNull();
            Optional optionalItem = this.salDodRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salDod.id.eq(id))));
            if (!optionalItem.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
            }
            SalDoDDO do1 = (SalDoDDO)optionalItem.get();
            do1.setDeleteFlag(1);
            this.salDodRepo.save(do1);
        });
    }

    @Override
    public void deleteByMasId(Long masId) {
        this.salDodRepo.deleteByMasId(masId);
    }

    @Override
    public List<SalDoDRespVO> findByMasIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        JPAQuery<SalDoDRespVO> jpaQuery = this.salDoDRepoproc.select(null);
        QSalDoDDO salDod = QSalDoDDO.salDoDDO;
        jpaQuery.where((Predicate)salDod.deleteFlag.eq((Object)0).or((Predicate)salDod.deleteFlag.isNull()));
        jpaQuery.where((Predicate)salDod.masId.in(idList));
        return jpaQuery.fetch();
    }

    @Override
    @SysCodeProc
    public List<Long> findItemNameByLike(String itemName) {
        ArrayList itmItemVOList = new ArrayList();
        List<Long> itemIds = itmItemVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        QSalSoDDO jpaQDo = QSalSoDDO.salSoDDO;
        JPAQuery<Long> where = this.salDoDRepoproc.selectItemId(itemIds);
        return where.fetch();
    }

    public SalDoDServiceImpl(SalDoDRepo salDodRepo, SalDoDRepoProc salDoDRepoproc, SalSoDService salSoDService, SalSoAllocRepo salSoAllocRepo, InvItemPkgService invItemPkgService) {
        this.salDodRepo = salDodRepo;
        this.salDoDRepoproc = salDoDRepoproc;
        this.salSoDService = salSoDService;
        this.salSoAllocRepo = salSoAllocRepo;
        this.invItemPkgService = invItemPkgService;
    }
}

