/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.repo.InvLotRepo;
import com.elitesland.inv.service.InvLotCommonService;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.inv.vo.save.InvLotSaveVO;
import com.elitesland.sal.constant.SalEnum;
import com.elitesland.sal.entity.QSalSoDDO;
import com.elitesland.sal.entity.SalDoDDO;
import com.elitesland.sal.entity.SalDoDO;
import com.elitesland.sal.entity.SalSoDDO;
import com.elitesland.sal.entity.SalSoDO;
import com.elitesland.sal.repo.SalDoDRepo;
import com.elitesland.sal.repo.SalDoDRepoProc;
import com.elitesland.sal.repo.SalDoRepo;
import com.elitesland.sal.repo.SalDoRepoProc;
import com.elitesland.sal.repo.SalSoAllocRepo;
import com.elitesland.sal.repo.SalSoAllocRepoProc;
import com.elitesland.sal.repo.SalSoDRepo;
import com.elitesland.sal.repo.SalSoDRepoProc;
import com.elitesland.sal.repo.SalSoRepo;
import com.elitesland.sal.repo.SalSoRepoProc;
import com.elitesland.sal.service.SalDoReturnService;
import com.elitesland.sal.vo.resp.SalSoDRespVO;
import com.elitesland.sal.vo.save.ReturnConfirmParam;
import com.elitesland.sal.vo.save.SalRdoDSaveVO;
import com.elitesland.sal.vo.save.SalRdoSaveVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="SalDoReturnService")
public class SalDoReturnServiceImpl
implements SalDoReturnService {
    private final SalDoRepo salDoRepo;
    private final SalDoRepoProc salDoRepoProc;
    private final SalDoDRepo salDoDRepo;
    private final SalDoDRepoProc salDoDRepoProc;
    private final SalSoRepo salSoRepo;
    private final SalSoRepoProc salSoRepoProc;
    private final SalSoDRepo salSoDRepo;
    private final SalSoDRepoProc salSoDRepoProc;
    private final SalSoAllocRepo salSoAllocRepo;
    private final SalSoAllocRepoProc salSoAllocRepoProc;
    private final InvLotRepo invLotRepo;
    private final InvWhService invWhService;
    private final InvLotService invLotService;
    private final InvLotCommonService invLotCommonService;
    private final InvStkCommonService invStkCommonService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmCause(SalRdoSaveVO param) throws ExecutionException, InterruptedException {
        SalSoDO salSoDO;
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u786e\u8ba4\u539f\u56e0\u7801\u5f02\u5e38\uff0c\u9000\u8d27\u5165\u5e93\u5355ID\u4e3a\u7a7a");
        }
        Long id = param.getId();
        SalDoDO salDoDO = new SalDoDO();
        try {
            Optional salDoDoOptional = this.salDoRepo.findById(id);
            if (salDoDoOptional.isPresent()) {
                salDoDO = (SalDoDO)salDoDoOptional.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (salDoDO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u5230\u9000\u8d27\u5165\u5e93\u5355");
        }
        if (!UdcEnum.SAL_RDO_STATUS_WR.getValueCode().equals(salDoDO.getDocStatus())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u5f85\u786e\u8ba4\u72b6\u6001\u624d\u53ef\u786e\u8ba4\u539f\u56e0\u7801");
        }
        if (!StringUtils.isEmpty((Object)param.getReturnReasonCode())) {
            salDoDO.setReturnReasonCode(param.getReturnReasonCode());
        }
        this.salDoRepo.save(salDoDO);
        Long rsoId = salDoDO.getRelateDocId();
        this.salSoRepoProc.updateReturnReasonCodeById(param.getReturnReasonCode(), id);
        if (SalEnum.SAL_SE17.getCode().equals(salDoDO.getSoScene())) {
            this.salDoRepoProc.updateDocAndLogisStatusById(salDoDO.getId(), UdcEnum.SAL_RSO_STATUS_DONE.getValueCode(), null);
            List salRdodSaveVOList = param.getSalRdodSaleList();
            if (!CollectionUtils.isEmpty((Collection)salRdodSaveVOList)) {
                for (SalRdoDSaveVO salDodCreateParam : salRdodSaveVOList) {
                    this.salDoDRepoProc.updateReturnReasonCodeById(salDodCreateParam.getReturnReasonCode(), salDodCreateParam.getId());
                    this.salSoDRepoProc.updateReturnReasonCodeById(salDodCreateParam.getReturnReasonCode(), salDodCreateParam.getRelateDocDid());
                }
            }
            if ((salSoDO = this.salSoRepoProc.findSalSoDoById(salDoDO.getRelateDocId())) == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2salSoDO\u5931\u8d25");
            }
        } else {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u4e0d\u652f\u6301\u7684\u9000\u8d27\u7c7b\u578b\uff1a" + salDoDO.getSoScene());
        }
        this.salSoRepoProc.updateDocAndLogisStatusById(id, UdcEnum.SAL_RSO_STATUS_DONE.getValueCode(), null);
        this.updateReturnedQtyAndInvStk(salSoDO, this.salSoDRepoProc.findSalSodDosByMasId(salSoDO.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handOverSalRdo(Long id) {
        boolean isWhPhysical;
        if (id == null) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional salDodoOptional = this.salDoRepo.findById(id);
        if (!salDodoOptional.isPresent()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u5230\u5339\u914d\u6570\u636e");
        }
        SalDoDO salDoDO = (SalDoDO)salDodoOptional.get();
        Optional whDO = this.invWhService.findIdOne(salDoDO.getWhId());
        if (whDO.isEmpty()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u4ed3\u5e93\u4e3a\u7a7a");
        }
        String whType = ((InvWhRespVO)whDO.get()).getWhType2();
        if (UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(whType) || UdcEnum.INV_WH_TYPE_LOGICAL.getValueCode().equals(whType)) {
            isWhPhysical = true;
        } else if (UdcEnum.INV_WH_TYPE_CONSIGMENT.getValueCode().equals(whType)) {
            isWhPhysical = false;
        } else {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u4ed3\u5e93\u7c7b\u578b\u53ea\u652f\u6301\u7269\u7406\u4ed3\u3001\u5bc4\u552e\u4ed3\u548c\u865a\u62df\u4ed3");
        }
        if (SalEnum.SAL_SE18.getCode().equals(salDoDO.getSoScene()) || SalEnum.SAL_SE22.getCode().equals(salDoDO.getSoScene())) {
            if (!isWhPhysical) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u652f\u6301\u7684\u4ea4\u63a5\u7c7b\u578b\uff1a" + salDoDO.getSoScene());
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u652f\u6301\u7684\u9000\u8d27\u7c7b\u578b\uff1a" + salDoDO.getSoScene());
        }
        SalSoDO salSoDO = this.salSoRepoProc.findSalSoDoById(salDoDO.getRelateDocId());
        this.salDoRepoProc.updateDocAndLogisStatusById(salDoDO.getId(), null, UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
        this.salSoRepoProc.updateDocAndLogisStatusById(salSoDO.getId(), null, UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
    }

    private void updateReturnedQtyAndInvStk(SalSoDO salSoDO, List<SalSoDDO> salSodDoS) {
        if (salSoDO == null) {
            return;
        }
        if (CollectionUtils.isEmpty(salSodDoS)) {
            return;
        }
        Long rsoId = salSoDO.getId();
        List<SalDoDDO> rSalDodDoS = this.salDoDRepo.findByRelateDocId(rsoId);
        Double rdoSumReturnedQty = 0.0;
        HashMap<Long, Double> rdodQty2Map = new HashMap<Long, Double>(16);
        HashMap<Long, BigDecimal> rdodAmtMap = new HashMap<Long, BigDecimal>(16);
        HashMap sodReturnQtyMap = new HashMap(16);
        for (SalDoDDO rSalDodDO : rSalDodDoS) {
            Double qty2 = rSalDodDO.getQty2() == null ? 0.0 : rSalDodDO.getQty2();
            BigDecimal amt = rSalDodDO.getAmt() == null ? BigDecimal.ZERO : rSalDodDO.getAmt();
            Long relateDocDid = rSalDodDO.getRelateDocDid();
            if (rdodQty2Map.containsKey(relateDocDid)) {
                rdodQty2Map.put(relateDocDid, (Double)rdodQty2Map.get(relateDocDid) + qty2);
            } else {
                rdodQty2Map.put(relateDocDid, qty2);
            }
            if (rdodAmtMap.containsKey(relateDocDid)) {
                rdodAmtMap.put(relateDocDid, amt.add((BigDecimal)rdodAmtMap.get(relateDocDid)));
                continue;
            }
            rdodAmtMap.put(relateDocDid, amt);
        }
        SalDoDO salDoDO = null;
        List<SalDoDO> rSalDoDos = this.salDoRepo.findByRelateDocId(rsoId);
        if (!CollectionUtils.isEmpty(rSalDoDos)) {
            salDoDO = rSalDoDos.get(0);
            salDoDO.setDocTime(LocalDateTime.now());
            this.salDoRepo.save(salDoDO);
        }
        Double rsoSumReturnedQty = 0.0;
        BigDecimal rsoSumCoAmt = BigDecimal.ZERO;
        for (SalSoDDO rSalSodDO : salSodDoS) {
            if (rdodQty2Map.containsKey(rSalSodDO.getId())) {
                rSalSodDO.setReturnedQty((Double)rdodQty2Map.get(rSalSodDO.getId()));
            }
            if (rdodAmtMap.containsKey(rSalSodDO.getId())) {
                rSalSodDO.setCoAmt((BigDecimal)rdodAmtMap.get(rSalSodDO.getId()));
            }
            rsoSumReturnedQty = rsoSumReturnedQty + (rSalSodDO.getReturnedQty() == null ? 0.0 : rSalSodDO.getReturnedQty());
            rsoSumCoAmt = rsoSumCoAmt.add(rSalSodDO.getCoAmt() == null ? BigDecimal.ZERO : rSalSodDO.getCoAmt());
            Long dodId = rSalSodDO.getRelateDocDid();
            if ("SE17".equals(salSoDO.getSoScene())) {
                this.salDoDRepo.findById(dodId).ifPresent(o -> {
                    o.setReturnedQty((o.getReturnedQty() == null ? 0.0 : o.getReturnedQty()) + Math.abs(rSalSodDO.getReturnedQty()));
                    this.salDoDRepo.save(o);
                    QSalSoDDO salSod = QSalSoDDO.salSoDDO;
                    JPAQuery salDoRespJpa = (JPAQuery)this.salSoDRepoProc.selectQue(null).where((Predicate)salSod.id.eq((Object)o.getRelateDocDid()));
                    SalSoDRespVO salSodDO = (SalSoDRespVO)salDoRespJpa.fetchOne();
                    if (salSodDO != null) {
                        salSodDO.setCoAmt((salSodDO.getCoAmt() == null ? BigDecimal.ZERO : salSodDO.getCoAmt()).add(rSalSodDO.getCoAmt().abs()));
                        salSodDO.setReturnedQty(Double.valueOf((salSodDO.getReturnedQty() == null ? 0.0 : salSodDO.getReturnedQty()) + Math.abs(rSalSodDO.getReturnedQty())));
                        this.salSoDRepoProc.updateReturnedQtyAndCoAmtById(salSodDO.getReturnedQty(), salSodDO.getCoAmt(), salSodDO.getId());
                        sodReturnQtyMap.put(salSodDO.getId(), Math.abs(rSalSodDO.getReturnedQty()));
                    }
                });
            }
            this.salSoDRepoProc.updateReturnedQtyAndCoAmtById(rSalSodDO.getReturnedQty(), rSalSodDO.getCoAmt(), rSalSodDO.getId());
        }
        salSoDO.setQty2(rsoSumReturnedQty);
        salSoDO.setRefundAmt(rsoSumCoAmt);
        this.salSoRepo.save(salSoDO);
        this.changeInvStk4(salDoDO, rSalDodDoS);
    }

    private void changeInvStk4(SalDoDO salDoDO, List<SalDoDDO> salDodDoS) {
        ArrayList<InvStkCommon28InVO> invStkCommon28InVoS = new ArrayList<InvStkCommon28InVO>();
        for (SalDoDDO salDodDO : salDodDoS) {
            InvStkCommon28InVO invStkCommon28InVO = new InvStkCommon28InVO();
            invStkCommon28InVO.setQty(Double.valueOf(Math.abs(salDodDO.getQty2())));
            if (invStkCommon28InVO.getQty() == 0.0) continue;
            invStkCommon28InVO.setDocNo(salDoDO.getDocNo());
            invStkCommon28InVO.setLineNo(salDodDO.getLineNo());
            invStkCommon28InVO.setOpDate(LocalDateTime.now());
            invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.I_TYPE_06);
            invStkCommon28InVO.setInvStk28Enum2(null);
            invStkCommon28InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_RSO.getValueCode());
            invStkCommon28InVO.setSrcDocId(salDoDO.getId());
            invStkCommon28InVO.setSrcDocDid(salDodDO.getRelateDocDid());
            invStkCommon28InVO.setItemId(salDodDO.getItemId());
            if (salDodDO.getVariId() != null && salDodDO.getVariId() == 0L) {
                salDodDO.setVariId(null);
            }
            invStkCommon28InVO.setVariId(salDodDO.getVariId());
            invStkCommon28InVO.setWhId(salDoDO.getWhId());
            invStkCommon28InVO.setUom(salDodDO.getUom());
            if (!StringUtils.isEmpty((Object)salDoDO.getDeter3())) {
                invStkCommon28InVO.setDeter3(salDoDO.getDeter3());
            } else {
                invStkCommon28InVO.setDeter1(salDodDO.getDeter1());
                invStkCommon28InVO.setDeter2(salDodDO.getDeter2());
            }
            invStkCommon28InVO.setSrcDocCls(salDoDO.getDocCls());
            invStkCommon28InVO.setDocNo(salDoDO.getDocNo());
            invStkCommon28InVO.setSrcDocDid(salDodDO.getId());
            invStkCommon28InVO.setSrcDocId(salDoDO.getId());
            invStkCommon28InVO.setLotNo(salDodDO.getLotNo());
            invStkCommon28InVoS.add(invStkCommon28InVO);
        }
        this.invStkCommonService.invStkCommon28(invStkCommon28InVoS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRdodInfo(SalRdoSaveVO salDoCreateParam) {
        Long id = salDoCreateParam.getId();
        if (id == null) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List salDodCreateParamList = salDoCreateParam.getSalRdodSaleList();
        if (CollectionUtils.isEmpty((Collection)salDodCreateParamList)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570salDoDCreateParamList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SalDoDO salDoDO = this.salDoRepoProc.findSalDoDoById(id);
        if (salDoDO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u5339\u914d\u6570\u636e");
        }
        if (salDoDO.getIntfFlag().booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u5355\u636e\u4e0d\u652f\u6301\u624b\u52a8\u9000\u8d27\u786e\u8ba4");
        }
        if (!UdcEnum.SAL_RDO_STATUS_WF.getValueCode().equals(salDoDO.getDocStatus())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u5f85\u9000\u8d27\u786e\u8ba4\u72b6\u6001\u624d\u53ef\u7f16\u8f91");
        }
        if (!UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode().equals(salDoDO.getLogisStatus())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5b8c\u6210\u4ea4\u63a5");
        }
        this.salDoDRepo.deleteByMasId(id);
        ArrayList<SalDoDDO> salDodDoS = new ArrayList<SalDoDDO>();
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumNetAmt = BigDecimal.ZERO;
        for (SalRdoDSaveVO salDodCreateParam : salDodCreateParamList) {
            if (salDodCreateParam.getQty2() == null) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u5b9e\u9000\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a! \u884c\u53f7:" + salDodCreateParam.getLineNo());
            }
            if (salDodCreateParam.getQty2() < 0.0) {
                if (StringUtils.isEmpty((Object)salDodCreateParam.getLotNo())) {
                    throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a! \u884c\u53f7:" + salDodCreateParam.getLineNo());
                }
                this.addInvLot(salDodCreateParam.getItemId(), salDodCreateParam.getLotNo());
            }
            SalDoDDO salDodDO = new SalDoDDO();
            BeanUtils.copyProperties((Object)salDodCreateParam, (Object)salDodDO);
            salDodDoS.add(salDodDO);
            sumTaxAmt = sumTaxAmt.add(salDodDO.getTaxAmt());
            sumAmt = sumAmt.add(salDodDO.getAmt());
            sumNetAmt = sumNetAmt.add(salDodDO.getNetAmt());
        }
        this.salDoDRepo.saveAll(salDodDoS);
        salDoDO.setTaxAmt(sumTaxAmt);
        salDoDO.setAmt(sumAmt);
        salDoDO.setNetAmt(sumNetAmt);
        this.salDoRepo.save(salDoDO);
        SalSoDO salSoDO = this.salSoRepoProc.findSalSoDoById(salDoDO.getRelateDocId());
        this.salDoRepoProc.updateDocAndLogisStatusById(salDoDO.getId(), UdcEnum.SAL_RDO_STATUS_DONE.getValueCode(), null);
        if (salSoDO != null) {
            this.salSoRepoProc.updateDocAndLogisStatusById(salSoDO.getId(), UdcEnum.SAL_RDO_STATUS_DONE.getValueCode(), null);
        }
        this.updateReturnedQtyAndInvStk(salSoDO, this.salSoDRepoProc.findSalSodDosByMasId(salSoDO.getId()));
    }

    private void addInvLot(Long itemId, String lotNo) {
        ReturnConfirmParam returnParam = new ReturnConfirmParam();
        returnParam.setLotNo(lotNo);
        returnParam.setLotNoItemId(itemId);
        this.addInvLot(Arrays.asList(returnParam));
    }

    private void addInvLot(List<ReturnConfirmParam> returnConfirmParams) {
        if (CollectionUtils.isEmpty(returnConfirmParams)) {
            return;
        }
        for (ReturnConfirmParam returnParam : returnConfirmParams) {
            InvLotParam queryParam = new InvLotParam();
            Long itemId = returnParam.getLotNoItemId();
            String lotNo = returnParam.getLotNo();
            if (StringUtils.isEmpty((Object)itemId)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)lotNo)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            queryParam.setItemId(itemId);
            queryParam.setLotNo(lotNo);
            List invLotList = this.invLotService.findByParams(queryParam);
            if (!CollectionUtils.isEmpty((Collection)invLotList)) continue;
            ArrayList<InvLotSaveVO> invLotDoS = new ArrayList<InvLotSaveVO>();
            InvLotSaveVO invLotDO = new InvLotSaveVO();
            returnParam.setManuDate(LocalDateTime.now());
            invLotDO.setItemId(returnParam.getLotNoItemId());
            invLotDO.setLotNo(returnParam.getLotNo());
            invLotDO.setExpireDate(returnParam.getExpireDate());
            invLotDO.setManuDate(returnParam.getManuDate());
            invLotDO.setExpireDays(returnParam.getExpireDays());
            invLotDoS.add(invLotDO);
            this.invLotCommonService.createInvLotInfo(invLotDoS);
        }
    }

    public SalDoReturnServiceImpl(SalDoRepo salDoRepo, SalDoRepoProc salDoRepoProc, SalDoDRepo salDoDRepo, SalDoDRepoProc salDoDRepoProc, SalSoRepo salSoRepo, SalSoRepoProc salSoRepoProc, SalSoDRepo salSoDRepo, SalSoDRepoProc salSoDRepoProc, SalSoAllocRepo salSoAllocRepo, SalSoAllocRepoProc salSoAllocRepoProc, InvLotRepo invLotRepo, InvWhService invWhService, InvLotService invLotService, InvLotCommonService invLotCommonService, InvStkCommonService invStkCommonService) {
        this.salDoRepo = salDoRepo;
        this.salDoRepoProc = salDoRepoProc;
        this.salDoDRepo = salDoDRepo;
        this.salDoDRepoProc = salDoDRepoProc;
        this.salSoRepo = salSoRepo;
        this.salSoRepoProc = salSoRepoProc;
        this.salSoDRepo = salSoDRepo;
        this.salSoDRepoProc = salSoDRepoProc;
        this.salSoAllocRepo = salSoAllocRepo;
        this.salSoAllocRepoProc = salSoAllocRepoProc;
        this.invLotRepo = invLotRepo;
        this.invWhService = invWhService;
        this.invLotService = invLotService;
        this.invLotCommonService = invLotCommonService;
        this.invStkCommonService = invStkCommonService;
    }
}

