/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.ComC2VO;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.dto.OrgCustVO;
import com.elitesland.inv.param.InvLotParam;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvStkCommonService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.InvLotVO;
import com.elitesland.inv.vo.InvStk28Enum;
import com.elitesland.inv.vo.InvStkCommon28InVO;
import com.elitesland.inv.vo.PurPoVO;
import com.elitesland.inv.vo.resp.InvAddrAddressVO;
import com.elitesland.inv.vo.resp.InvLotRespVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.item.vo.InvItemPkgVO;
import com.elitesland.org.vo.OrgBuVO;
import com.elitesland.pur.dto.PurPoDVO;
import com.elitesland.pur.service.PurSs2Service;
import com.elitesland.pur.vo.save.PurSsDSaveVO;
import com.elitesland.pur.vo.save.PurSsSaveVO;
import com.elitesland.sal.constant.SalEnum;
import com.elitesland.sal.convert.SalDoCovert;
import com.elitesland.sal.convert.SalDodCovert;
import com.elitesland.sal.entity.QSalDoDO;
import com.elitesland.sal.entity.QSalSoDDO;
import com.elitesland.sal.entity.SalDoDDO;
import com.elitesland.sal.entity.SalDoDO;
import com.elitesland.sal.entity.SalSoAllocDO;
import com.elitesland.sal.entity.SalSoDDO;
import com.elitesland.sal.entity.SalSoDO;
import com.elitesland.sal.entity.importentity.SalDoExImport;
import com.elitesland.sal.param.SalDoQueryParamVO;
import com.elitesland.sal.repo.SalDoDRepo;
import com.elitesland.sal.repo.SalDoRepo;
import com.elitesland.sal.repo.SalDoRepoProc;
import com.elitesland.sal.repo.SalSoAllocRepo;
import com.elitesland.sal.repo.SalSoAllocRepoProc;
import com.elitesland.sal.repo.SalSoDRepo;
import com.elitesland.sal.repo.SalSoDRepoProc;
import com.elitesland.sal.repo.SalSoRepo;
import com.elitesland.sal.repo.SalSoRepoProc;
import com.elitesland.sal.service.SalDoDService;
import com.elitesland.sal.service.SalDoService;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.service.SalSoDService;
import com.elitesland.sal.service.SalSoService;
import com.elitesland.sal.vo.resp.SalDoDRespVO;
import com.elitesland.sal.vo.resp.SalDoRespVO;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.sal.vo.resp.SalSoDRespVO;
import com.elitesland.sal.vo.resp.SalSoRespVO;
import com.elitesland.sal.vo.save.SalDoDSaveVO;
import com.elitesland.sal.vo.save.SalDoSaveVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.entity.SysUserDO;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.util.ExcelWriteUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="salDoService")
public class SalDoServiceImpl
implements SalDoService {
    private static final Logger log = LoggerFactory.getLogger(SalDoServiceImpl.class);
    private final SalDoRepo salDoRepo;
    private final SalSoRepo salSoRepo;
    private final SalSoAllocRepoProc salSoAllocRepoProc;
    private final SalDoRepoProc salDoRepoproc;
    private final SalDoDService salDoDService;
    private final SalSoAllocRepo salSoAllocRepo;
    private final SalSoService salSoService;
    private final SalSoRepoProc salSoRepoProc;
    private final SalSoDRepo salSodRepo;
    private final SalSoDRepoProc salSoDRepoProc;
    private final SalDoDRepo salDoDRepo;
    private final SalSoDService salSoDService;
    private final InvWhService invWhService;
    private final SalSoAllocService salSoAllocService;
    private final InvStkCommonService invStkCommonService;
    private final InvStkCommonService InvStkCommonService;
    private final SysNumberRuleService sysNumberRuleService;
    private final InvLotService invLotService;
    private final PurSs2Service purSs2Service;

    private String getInvAjDocNo(SalDoDO salDoDO) {
        String docNo = null;
        docNo = this.sysNumberRuleService.generateCode("DOSO", List.of(String.valueOf(salDoDO.getOuId())));
        return docNo;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SalDoExImport> exportSearchsalDo(SalDoQueryParamVO param, List<SalDoRespVO> records) throws ExecutionException, InterruptedException {
        ArrayList<SalDoExImport> salDoExImports = new ArrayList<SalDoExImport>();
        records.forEach(salDoVO -> {
            List salDodVoPagingVo2 = salDoVO.getSalDodRespVOList();
            if (salDodVoPagingVo2 != null) {
                salDodVoPagingVo2.forEach(salDodVO -> {
                    if (StringUtils.isEmpty((Object)salDoVO.getOuterOu())) {
                        salDoVO.setOuterOu("");
                    }
                    if (StringUtils.isEmpty((Object)salDoVO.getOuterType())) {
                        salDoVO.setOuterType("");
                    }
                    if (StringUtils.isEmpty((Object)salDoVO.getOuterNo())) {
                        salDoVO.setOuterNo("");
                    }
                    salDoVO.setOuterOuTypeNo(salDoVO.getOuterOu() + salDoVO.getOuterType() + salDoVO.getOuterNo());
                    SalDoExImport salDoExImport = new SalDoExImport();
                    BeanCopyUtil.beanCopy(salDoVO, salDoExImport);
                    BeanCopyUtil.beanCopy(salDodVO, salDoExImport);
                    salDoExImport.setModifyTime1(salDoVO.getModifyTime());
                    salDoExImport.setEmpName1(salDoVO.getEmpName());
                    salDoExImports.add(salDoExImport);
                });
            } else {
                SalDoExImport salDoExImport = new SalDoExImport();
                BeanCopyUtil.beanCopy(salDoVO, salDoExImport);
                salDoExImports.add(salDoExImport);
            }
        });
        return salDoExImports;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(SalDoSaveVO param) throws ExecutionException, InterruptedException {
        SalDoDO salDoDo1 = new SalDoDO();
        Long id = 0L;
        this.testsalDo(param);
        id = param.getId() != null ? this.updateSubmitsaldo(param) : this.createsubmitsaldo(param);
        if (UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode().equals(salDoDo1.getLogisStatus())) {
            // empty if block
        }
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long splicPurSs(PurPoVO purPoVO, SalDoRespVO salDoVO) {
        ArrayList purPodVoList = new ArrayList();
        PurSsSaveVO purSsCreateParam = new PurSsSaveVO();
        purSsCreateParam.setPoId(purPoVO.getId());
        purSsCreateParam.setSuppId(purPoVO.getSuppId());
        purSsCreateParam.setWhId(purPoVO.getWhId());
        purSsCreateParam.setOuId(purPoVO.getOuId());
        purSsCreateParam.setRecvAddr(purPoVO.getRecvAddr());
        purSsCreateParam.setEtaDate(purPoVO.getDocTime());
        purSsCreateParam.setCrosswhFlag(salDoVO.getCrosswhFlag());
        purSsCreateParam.setIntfFlag(salDoVO.getCrosswhFlag());
        purSsCreateParam.setRelateDocId(purPoVO.getId());
        purSsCreateParam.setRelateDocCls(UdcEnum.COM_DOC_CLS_PO.getValueCode());
        purSsCreateParam.setRelateDocNo(purPoVO.getDocNo());
        purSsCreateParam.setRelateDoc2Cls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
        purSsCreateParam.setRelateDoc2Id(salDoVO.getId());
        purSsCreateParam.setRelateDoc2Type(salDoVO.getDocType());
        purSsCreateParam.setRelateDoc2No(salDoVO.getDocNo());
        purSsCreateParam.setRemark(purPoVO.getRemark());
        purSsCreateParam.setDeter1(salDoVO.getRecvDeter1());
        purSsCreateParam.setDeter2(salDoVO.getRecvDeter2());
        purSsCreateParam.setDeter3(salDoVO.getRecvDeter3());
        ArrayList purSsdCreateParamList = new ArrayList();
        List salDodVoS = salDoVO.getSalDodRespVOList();
        List itemIds = salDodVoS.stream().map(SalDoDRespVO::getItemId).distinct().collect(Collectors.toList());
        ArrayList itemVoS = new ArrayList();
        salDodVoS.forEach(v -> {
            PurSsDSaveVO purSsdSaveVo = new PurSsDSaveVO();
            InvLotParam queryParam = new InvLotParam();
            Optional<ItmItemVO> itmItemVO = itemVoS.stream().filter(itemVO -> itemVO.getId().equals(v.getItemId())).findFirst();
            itmItemVO.ifPresent(itemVO -> purSsdSaveVo.setDbrand(itemVO.getBrand()));
            purSsdSaveVo.setItemId(v.getItemId());
            purSsdSaveVo.setQty(v.getQty());
            purSsdSaveVo.setUom(v.getUom());
            purSsdSaveVo.setRemark(v.getRemark());
            purSsdSaveVo.setDeter1(v.getRecvDeter1());
            purSsdSaveVo.setDeter2(v.getRecvDeter2());
            purSsdSaveVo.setDeter3(v.getRecvDeter3());
            purSsdSaveVo.setLotNo(v.getLotNo());
            queryParam.setItemId(v.getItemId());
            queryParam.setLotNo(v.getLotNo());
            List invLotVoS = this.invLotService.findByParams(queryParam);
            if (invLotVoS != null && invLotVoS.size() == 1) {
                purSsdSaveVo.setManuDate(((InvLotRespVO)invLotVoS.get(0)).getManuDate());
                purSsdSaveVo.setExpireDate(((InvLotRespVO)invLotVoS.get(0)).getExpireDate());
            }
            purSsdSaveVo.setRelateDocCls(UdcEnum.COM_DOC_CLS_PO.getValueCode());
            purSsdSaveVo.setRelateDocId(purPoVO.getId());
            purSsdSaveVo.setRelateDocNo(purPoVO.getDocNo());
            Optional<PurPoDVO> purPodVo = purPodVoList.stream().filter(podVo -> podVo.getRelateDocDid().equals(v.getRelateDocDid())).findFirst();
            if (purPodVo.isPresent()) {
                purSsdSaveVo.setRelateDocDid(purPodVo.get().getId());
                purSsdSaveVo.setRelateDocLineno(Double.valueOf(purPodVo.get().getLineNo().intValue()));
            }
            purSsdSaveVo.setRelateDoc2Cls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
            purSsdSaveVo.setRelateDoc2Id(salDoVO.getId());
            purSsdSaveVo.setRelateDoc2Type(salDoVO.getDocType());
            purSsdSaveVo.setRelateDoc2No(salDoVO.getDocNo());
            purSsdSaveVo.setRelateDoc2Did(v.getId());
            purSsdSaveVo.setRelateDoc2Lineno(v.getLineNo());
            purSsdCreateParamList.add(purSsdSaveVo);
        });
        purSsCreateParam.setPurSsDSaveVOList(purSsdCreateParamList);
        return this.purSs2Service.submitPurSs(purSsCreateParam);
    }

    private Optional<SalDoRespVO> findDoByIdGroup(Long id) {
        Optional<SalDoRespVO> salDoVO = this.salDoRepo.findById(id).map(SalDoCovert.INSTANCE::doToRespVO);
        List salDodVoList = this.salDoDRepo.findByMasId(id).stream().map(v -> (SalDoDRespVO)BeanUtil.copyProperties((Object)v, SalDoDRespVO.class)).collect(Collectors.toList());
        if (salDoVO.isPresent()) {
            salDoVO.get().setSalDodRespVOList(salDodVoList);
            return salDoVO;
        }
        return Optional.empty();
    }

    @Transactional(rollbackFor={Exception.class})
    Long createsubmitsaldo(SalDoSaveVO param) {
        ArrayList<SalDoDDO> salDods = new ArrayList<SalDoDDO>();
        ArrayList<SalSoDDO> salSodDoList = new ArrayList<SalSoDDO>();
        ArrayList<SalSoAllocDO> salSoAllocList = new ArrayList<SalSoAllocDO>();
        ArrayList deliveryCompletedList = new ArrayList();
        Long id = 0L;
        this.testWhType(param);
        SalDoDO salDoDO = new SalDoDO();
        BeanUtils.copyProperties((Object)param, (Object)salDoDO);
        salDoDO.setGenType(UdcEnum.COM_DOC_GEN_TYPE_MANU.getValueCode());
        salDoDO.setDocNo(this.getInvAjDocNo(salDoDO));
        salDoDO.setDocDate(LocalDateTime.now());
        salDoDO.setDocCls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
        id = ((SalDoDO)this.salDoRepo.save(salDoDO)).getId();
        List salDodCreateParamList = param.getSalDodSaleList();
        for (Object sal : salDodCreateParamList) {
            SalDoDDO salDoDdO = new SalDoDDO();
            BeanUtils.copyProperties((Object)sal, (Object)salDoDdO);
            this.submitsaldod(salDoDdO, salDoDO);
            salDoDdO.setMasId(id);
            salDods.add(salDoDdO);
            if (!salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) continue;
            this.salSodAndSoAlloc(salDoDdO, salSodDoList, salSoAllocList);
        }
        Integer deliveryCompleteds = 0;
        for (Integer deliveryCompleted : deliveryCompletedList) {
            deliveryCompleteds = deliveryCompleteds + deliveryCompleted;
        }
        int s = deliveryCompletedList.size();
        if (!CollectionUtils.isEmpty(salSodDoList)) {
            salSodDoList.stream().forEach(salSod -> this.salSoDRepoProc.updateSodById(salSod.getShippedQty(), salSod.getAmt(), salSod.getId()));
        }
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            this.countSalSo(param.getRelateDocId());
        }
        this.countsaldo(salDods, salDoDO);
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            this.changeInvStk(salDoDO, salDods);
        }
        if (!CollectionUtils.isEmpty(salDods)) {
            this.salDoDRepo.saveAll(salDods);
        }
        return salDoDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    void salSodAndSoAlloc(SalDoDDO salDoDdO, List<SalSoDDO> salSodDoList, List<SalSoAllocDO> salSoAllocList) {
        Optional<SalSoAllocRespVO> salSoAlloc2;
        SalSoAllocRespVO salSoAllocVO;
        Optional<SalSoDRespVO> salSodDO = this.salSoDService.findIdOne(salDoDdO.getRelateDocDid());
        SalSoDRespVO salSodVO = salSodDO.get();
        SalSoDDO salSodDo1 = new SalSoDDO();
        BeanUtils.copyProperties((Object)salSodVO, (Object)salSodDo1);
        if (salDoDdO.getQty2() == null) {
            salDoDdO.setQty2(0.0);
        }
        if (salSodDo1.getShippedQty() == null) {
            salSodDo1.setShippedQty(0.0);
        }
        salSodDo1.setShippedQty(salSodDo1.getShippedQty() + salDoDdO.getQty2());
        salSodDo1.setTransPrice(salSodDo1.getTransPrice() == null ? BigDecimal.ZERO : salSodDo1.getTransPrice());
        salSodDo1.setTaxRate(salSodDo1.getTaxRate() == null ? 0.0 : salSodDo1.getTaxRate());
        BigDecimal doamtNew = new BigDecimal(1.0 + salSodDo1.getTaxRate()).multiply(salSodDo1.getTransPrice()).multiply(new BigDecimal(salDoDdO.getQty()));
        salSodDo1.setDoAmt(salSodDo1.getDoAmt() == null ? BigDecimal.ZERO : salSodDo1.getDoAmt());
        salSodDo1.setDoAmt(salSodDo1.getDoAmt().add(doamtNew));
        if (salSodDo1.getCancelQty() == null) {
            salSodDo1.setCancelQty(0.0);
        }
        salSodDoList.add(salSodDo1);
        if (salDoDdO.getSoAllocId() != null && salDoDdO.getSoAllocId() != 0L && (salSoAllocVO = (salSoAlloc2 = this.salSoAllocService.findIdOne(salDoDdO.getSoAllocId())).get()) != null) {
            if (salSoAllocVO.getShippedQty() == null) {
                salSoAllocVO.setShippedQty(Double.valueOf(0.0));
            }
            if (salDoDdO.getQty2() == null) {
                salDoDdO.setQty2(0.0);
            }
            this.salSoAllocRepoProc.updateShippedQtyById(salSoAllocVO.getShippedQty() + salDoDdO.getQty2(), salSoAllocVO.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void countsaldo(List<SalDoDDO> salDodCreateParams, SalDoDO salDoDO) {
        BigDecimal taxAmts = new BigDecimal(0);
        BigDecimal netAmts = new BigDecimal(0);
        BigDecimal amts = new BigDecimal(0);
        Double qtys = 0.0;
        Double qty2s = 0.0;
        Double volumes = 0.0;
        Double grossWeights = 0.0;
        for (SalDoDDO salDodVO : salDodCreateParams) {
            salDodVO.setQty(salDodVO.getQty() != null ? salDodVO.getQty() : 0.0);
            salDodVO.setNetAmt(salDodVO.getNetAmt() != null ? salDodVO.getNetAmt() : BigDecimal.ZERO);
            salDodVO.setTaxAmt(salDodVO.getTaxAmt() != null ? salDodVO.getTaxAmt() : BigDecimal.ZERO);
            salDodVO.setAmt(salDodVO.getAmt() != null ? salDodVO.getAmt() : BigDecimal.ZERO);
            salDodVO.setVolume(salDodVO.getVolume() != null ? salDodVO.getVolume() : 0.0);
            salDodVO.setGrossWeight(salDodVO.getGrossWeight() != null ? salDodVO.getGrossWeight() : 0.0);
            salDodVO.setQty2(salDodVO.getQty2() != null ? salDodVO.getQty2() : 0.0);
            qtys = qtys + salDodVO.getQty();
            qty2s = qty2s + salDodVO.getQty2();
            taxAmts = taxAmts.add(salDodVO.getTaxAmt());
            amts = amts.add(salDodVO.getAmt());
            netAmts = netAmts.add(salDodVO.getNetAmt());
            volumes = volumes + salDodVO.getVolume();
            grossWeights = grossWeights + salDodVO.getGrossWeight();
        }
        salDoDO.setTaxAmt(taxAmts);
        salDoDO.setNetAmt(netAmts);
        salDoDO.setAmt(amts);
        salDoDO.setQty(qtys);
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            salDoDO.setQty2(qty2s);
        }
        salDoDO.setVolume(volumes);
        salDoDO.setGrossWeight(grossWeights);
        this.update(salDoDO);
    }

    @Transactional(rollbackFor={Exception.class})
    void submitsaldod(SalDoDDO salDoDdO, SalDoDO salDoDO) {
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            salDoDdO.setQty2(salDoDdO.getQty());
        } else {
            salDoDdO.setQty2(0.0);
        }
        salDoDdO.setTransPrice(salDoDdO.getTransPrice() == null ? BigDecimal.ZERO : salDoDdO.getTransPrice());
        salDoDdO.setNetAmt(salDoDdO.getQty() != null && salDoDdO.getTransPrice() != null ? BigDecimal.valueOf(salDoDdO.getQty()).multiply(salDoDdO.getTransPrice()) : null);
        BigDecimal multiply = new BigDecimal(salDoDdO.getTaxRate()).multiply(salDoDdO.getTransPrice());
        BigDecimal price = salDoDdO.getTransPrice().add(multiply);
        salDoDdO.setAmt(salDoDdO.getQty() != null && price != null ? BigDecimal.valueOf(salDoDdO.getQty()).multiply(price) : null);
        salDoDdO.setTaxAmt(salDoDdO.getAmt() != null && salDoDdO.getNetAmt() != null ? salDoDdO.getAmt().subtract(salDoDdO.getNetAmt()) : null);
        salDoDdO.setQty(salDoDdO.getQty() != null ? salDoDdO.getQty() : 0.0);
        salDoDdO.setCostPrice(salDoDdO.getCostPrice() != null ? salDoDdO.getCostPrice() : BigDecimal.ZERO);
        salDoDdO.setCostAmt(salDoDdO.getCostPrice().multiply(new BigDecimal(salDoDdO.getQty())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    void testWhType(SalDoSaveVO salDoDO) {
        if (salDoDO.getWhId() == null) throw new BusinessException("\u8bf7\u8f93\u5165\u4ed3\u5e93");
        Optional orgWh = this.invWhService.findIdOne(Long.valueOf(salDoDO.getWhId() == null ? 0L : salDoDO.getWhId()));
        if (!orgWh.isPresent()) throw new BusinessException("\u8bf7\u8f93\u5165\u4ed3\u5e93");
        if (UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(((InvWhRespVO)orgWh.get()).getWhType2())) {
            salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
            salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_WT.getValueCode());
            return;
        } else if (UdcEnum.INV_WH_TYPE_CONSIGMENT.getValueCode().equals(((InvWhRespVO)orgWh.get()).getWhType2())) {
            salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
            salDoDO.setDocTime(LocalDateTime.now());
            salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_CF.getValueCode());
            return;
        } else if (UdcEnum.INV_WH_TYPE_LOGICAL.getValueCode().equals(((InvWhRespVO)orgWh.get()).getWhType2())) {
            if (SalEnum.SAL_SE06.getCode().equals(salDoDO.getSoScene())) {
                salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
                salDoDO.setDocTime(LocalDateTime.now());
                salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_CF.getValueCode());
                return;
            } else {
                salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
                salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_WT.getValueCode());
            }
            return;
        } else {
            salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
            salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_WT.getValueCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    Long updateSubmitsaldo(SalDoSaveVO param) {
        Long id = 0L;
        ArrayList<SalDoDDO> salDodDoS = new ArrayList<SalDoDDO>();
        ArrayList<SalDoDDO> salDodDoS2 = new ArrayList<SalDoDDO>();
        ArrayList<SalSoAllocDO> salSoAllocList = new ArrayList<SalSoAllocDO>();
        ArrayList<SalSoDDO> salSodDolist = new ArrayList<SalSoDDO>();
        this.testWhType(param);
        param.setDocDate(LocalDateTime.now());
        SalDoDO salDoDO = new SalDoDO();
        BeanUtils.copyProperties((Object)param, (Object)salDoDO);
        this.update(salDoDO);
        List salDodSaveVOList = param.getSalDodSaleList();
        for (SalDoDSaveVO v : salDodSaveVOList) {
            SalDoDDO salDodDO = new SalDoDDO();
            BeanUtils.copyProperties((Object)v, (Object)salDodDO);
            this.submitsaldodd(salDodDO, salDoDO);
            if (v.getId() != null) {
                salDodDoS.add(salDodDO);
            } else {
                salDodDoS2.add(salDodDO);
            }
            if (!salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) continue;
            this.salSodAndSoAlloc(salDodDO, salSodDolist, salSoAllocList);
        }
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            if (!CollectionUtils.isEmpty(salDodDoS2)) {
                this.changeInvStk(salDoDO, salDodDoS2);
            }
            if (!CollectionUtils.isEmpty(salDodDoS2)) {
                this.changeInvStk(salDoDO, salDodDoS2);
            }
        }
        if (CollectionUtils.isEmpty(salSodDolist) && !CollectionUtils.isEmpty(salSodDolist)) {
            salSodDolist.stream().forEach(salSod -> this.salSoDRepoProc.updateSodById(salSod.getShippedQty(), salSod.getAmt(), salSod.getId()));
        }
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            this.countSalSo(param.getRelateDocId());
        }
        this.countSalDo(salDodDoS, salDodDoS2, salDoDO);
        if (salDodDoS2.size() > 0) {
            this.salDoDRepo.saveAll(salDodDoS2);
        }
        if (salDodDoS.size() > 0) {
            this.updateSalDodBatch(salDodDoS);
        }
        return param.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    void countSalSo(Long relateDocId) {
        ArrayList deliveryCompletedList = new ArrayList();
        Optional salSo = this.salSoRepo.findById(relateDocId);
        SalSoDO salSoDO = (SalSoDO)salSo.get();
        salSoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
        List<SalSoDRespVO> salSodRespVoS = this.salSoDService.findmaxIdOne(salSoDO.getId());
        int totalizers = 0;
        for (SalSoDRespVO ss : salSodRespVoS) {
            if (ss.getQty() == null) {
                ss.setQty(Double.valueOf(0.0));
            }
            if (ss.getShippedQty() == null) {
                ss.setShippedQty(Double.valueOf(0.0));
            }
            if (ss.getCancelQty() == null) {
                ss.setCancelQty(Double.valueOf(0.0));
            }
            if (ss.getQty() - ss.getShippedQty() - ss.getCancelQty() == 0.0) continue;
            ++totalizers;
        }
        if (salSoDO.getAllowPartalDeliver().booleanValue()) {
            if (totalizers != 0) {
                salSoDO.setDocStatus(UdcEnum.SAL_SO_STATUS_CF.getValueCode());
            } else {
                salSoDO.setDocStatus(UdcEnum.SAL_SO_STATUS_DONE.getValueCode());
            }
        } else {
            salSoDO.setDocStatus(UdcEnum.SAL_SO_STATUS_DONE.getValueCode());
        }
        this.salSoRepoProc.updateDocstatusAndLogisById(salSoDO.getDocStatus(), salSoDO.getLogisStatus(), salSoDO.getId());
    }

    private void countsalSodAndSoAlloc(SalDoDDO salDodDO, Long soAllocId, List<SalSoDDO> salSodDoList, List<SalSoAllocDO> salSoAllocList) {
        SalSoAllocRespVO salSoAllocVO;
        Optional<SalSoAllocRespVO> salSoAlloc2;
        Optional<SalSoDRespVO> idOne = this.salSoDService.findIdOne(soAllocId);
        SalSoDRespVO salSod = idOne.get();
        if (salSod.getShippedQty() == null) {
            salSod.setShippedQty(Double.valueOf(0.0));
        }
        salSod.setShippedQty(Double.valueOf(salSod.getShippedQty() + salDodDO.getQty2()));
        salSod.setTransPrice(salSod.getTransPrice() != null ? salSod.getTransPrice() : BigDecimal.ZERO);
        salSod.setTaxRate(Double.valueOf(salSod.getTaxRate() != null ? salSod.getTaxRate() : 0.0));
        salSod.setDoAmt(salSod.getDoAmt() != null ? salSod.getDoAmt() : BigDecimal.ZERO);
        BigDecimal doamtNew = new BigDecimal(1.0 + salSod.getTaxRate()).multiply(salSod.getTransPrice()).multiply(new BigDecimal(salDodDO.getQty2()));
        salSod.setDoAmt(salSod.getDoAmt().add(doamtNew));
        SalSoDDO salSodo = new SalSoDDO();
        BeanUtils.copyProperties((Object)salSod, (Object)salSodo);
        salSodDoList.add(salSodo);
        if (soAllocId != null && soAllocId != 0L && (salSoAlloc2 = this.salSoAllocService.findIdOne(soAllocId)).isPresent() && (salSoAllocVO = salSoAlloc2.get()) != null) {
            if (salSoAllocVO.getShippedQty() == null) {
                salSoAllocVO.setShippedQty(Double.valueOf(0.0));
            }
            if (salDodDO.getQty2() == null) {
                salDodDO.setQty2(0.0);
            }
            salSoAllocVO.setShippedQty(Double.valueOf(salSoAllocVO.getShippedQty() + salDodDO.getQty2()));
            SalSoAllocDO salsoallocdo = new SalSoAllocDO();
            BeanUtils.copyProperties((Object)salSoAllocVO, (Object)salsoallocdo);
            salSoAllocList.add(salsoallocdo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void submitsaldodd(SalDoDDO salDodDO, SalDoDO salDoDO) {
        if (salDoDO.getDocStatus().equals(UdcEnum.SAL_DO_STATUS_CF.getValueCode())) {
            salDodDO.setQty2(salDodDO.getQty());
            salDodDO.setCancelQty(salDodDO.getQty() - salDodDO.getQty2());
        } else {
            salDodDO.setQty2(0.0);
        }
        salDodDO.setModifyTime(LocalDateTime.now());
        salDodDO.setTransPrice(salDodDO.getTransPrice() == null ? BigDecimal.ZERO : salDodDO.getTransPrice());
        salDodDO.setNetAmt(salDodDO.getQty() != null && salDodDO.getTransPrice() != null ? BigDecimal.valueOf(salDodDO.getQty()).multiply(salDodDO.getTransPrice()) : null);
        BigDecimal multiply = new BigDecimal(salDodDO.getTaxRate()).multiply(salDodDO.getTransPrice());
        BigDecimal price = salDodDO.getTransPrice().add(multiply);
        salDodDO.setAmt(salDodDO.getQty() != null && price != null ? BigDecimal.valueOf(salDodDO.getQty()).multiply(price) : null);
        salDodDO.setTaxAmt(salDodDO.getAmt() != null && salDodDO.getNetAmt() != null ? salDodDO.getAmt().subtract(salDodDO.getNetAmt()) : null);
        salDodDO.setQty(salDodDO.getQty() != null ? salDodDO.getQty() : 0.0);
        salDodDO.setCostPrice(salDodDO.getCostPrice() != null ? salDodDO.getCostPrice() : BigDecimal.ZERO);
        salDodDO.setCostAmt(salDodDO.getCostPrice().multiply(new BigDecimal(salDodDO.getQty())));
    }

    @Transactional(rollbackFor={Exception.class})
    void countSalDo(List<SalDoDDO> salDodDoS, List<SalDoDDO> salDodDos2, SalDoDO salDoDO) {
        BigDecimal taxAmts = new BigDecimal(0);
        BigDecimal netAmts = new BigDecimal(0);
        BigDecimal amts = new BigDecimal(0);
        Double qtys = 0.0;
        Double qty2s = 0.0;
        Double volumes = 0.0;
        Double grossWeights = 0.0;
        for (SalDoDDO salDodVO : salDodDoS) {
            salDodVO.setQty(salDodVO.getQty() != null ? salDodVO.getQty() : 0.0);
            salDodVO.setNetAmt(salDodVO.getNetAmt() != null ? salDodVO.getNetAmt() : BigDecimal.ZERO);
            salDodVO.setTaxAmt(salDodVO.getTaxAmt() != null ? salDodVO.getTaxAmt() : BigDecimal.ZERO);
            salDodVO.setAmt(salDodVO.getAmt() != null ? salDodVO.getAmt() : BigDecimal.ZERO);
            salDodVO.setVolume(salDodVO.getVolume() != null ? salDodVO.getVolume() : 0.0);
            salDodVO.setGrossWeight(salDodVO.getGrossWeight() != null ? salDodVO.getGrossWeight() : 0.0);
            salDodVO.setQty2(salDodVO.getQty2() != null ? salDodVO.getQty2() : 0.0);
            qtys = qtys + salDodVO.getQty();
            qty2s = qty2s + salDodVO.getQty2();
            taxAmts = taxAmts.add(salDodVO.getTaxAmt());
            amts = amts.add(salDodVO.getAmt());
            netAmts = netAmts.add(salDodVO.getNetAmt());
            volumes = volumes + salDodVO.getVolume();
            grossWeights = grossWeights + salDodVO.getGrossWeight();
        }
        for (SalDoDDO salDodVO : salDodDos2) {
            salDodVO.setQty(salDodVO.getQty() != null ? salDodVO.getQty() : 0.0);
            salDodVO.setNetAmt(salDodVO.getNetAmt() != null ? salDodVO.getNetAmt() : BigDecimal.ZERO);
            salDodVO.setTaxAmt(salDodVO.getTaxAmt() != null ? salDodVO.getTaxAmt() : BigDecimal.ZERO);
            salDodVO.setAmt(salDodVO.getAmt() != null ? salDodVO.getAmt() : BigDecimal.ZERO);
            salDodVO.setVolume(salDodVO.getVolume() != null ? salDodVO.getVolume() : 0.0);
            salDodVO.setGrossWeight(salDodVO.getGrossWeight() != null ? salDodVO.getGrossWeight() : 0.0);
            salDodVO.setQty2(salDodVO.getQty2() != null ? salDodVO.getQty2() : 0.0);
            qtys = qtys + salDodVO.getQty();
            qty2s = qty2s + salDodVO.getQty2();
            taxAmts = taxAmts.add(salDodVO.getTaxAmt());
            amts = amts.add(salDodVO.getAmt());
            netAmts = netAmts.add(salDodVO.getNetAmt());
            volumes = volumes + salDodVO.getVolume();
            grossWeights = grossWeights + salDodVO.getGrossWeight();
        }
        salDoDO.setTaxAmt(taxAmts);
        salDoDO.setNetAmt(netAmts);
        salDoDO.setAmt(amts);
        salDoDO.setQty(qtys);
        salDoDO.setQty2(qty2s);
        salDoDO.setVolume(volumes);
        salDoDO.setGrossWeight(grossWeights);
        this.update(salDoDO);
    }

    @Transactional(rollbackFor={Exception.class})
    void testsalDo(SalDoSaveVO param) {
        List salsods = null;
        if (!CollectionUtils.isEmpty((Collection)param.getSalDodSaleList())) {
            List collect = param.getSalDodSaleList().stream().map(SalDoDSaveVO::getRelateDocDid).collect(Collectors.toList());
            QSalSoDDO salSodDO = QSalSoDDO.salSoDDO;
            JPAQuery where = (JPAQuery)this.salSoDRepoProc.selectqty(null).where((Predicate)salSodDO.id.in(collect));
            salsods = where.fetch();
        }
        List finalSalsods = salsods;
        param.getSalDodSaleList().stream().forEach(t -> {
            List<SalDoDRespVO> byrelateDocDidqty = this.salDoDService.findByrelateDocDidqty(t.getRelateDocDid());
            double saldodqty = 0.0;
            if (byrelateDocDidqty != null) {
                saldodqty = byrelateDocDidqty.stream().filter(saldodd -> saldodd.getQty() != null).mapToDouble(SalDoDRespVO::getQty).sum();
            }
            if (finalSalsods == null) {
                saldodqty = 0.0;
            }
            double saldodqtyw = saldodqty;
            if (t.getSoQty() == null) {
                t.setSoQty(Double.valueOf(0.0));
            }
            if (t.getQty() == null) {
                t.setQty(Double.valueOf(0.0));
            }
            if (t.getCancelQty() == null) {
                t.setCancelQty(Double.valueOf(0.0));
            }
            finalSalsods.stream().forEach(s -> {
                if (t.getRelateDocDid().equals(s.getId())) {
                    if (s.getQty() == null) {
                        s.setQty(Double.valueOf(0.0));
                    }
                    if (s.getShippedQty() == null) {
                        s.setShippedQty(Double.valueOf(0.0));
                    }
                    if (s.getCancelQty() == null) {
                        s.setCancelQty(Double.valueOf(0.0));
                    }
                    if (s.getQty() - s.getShippedQty() - s.getCancelQty() - t.getQty() - saldodqtyw < 0.0) {
                        throw new BusinessException(ApiCode.FAIL, "\u8d85\u8ba2\u5355\u91cf\u53d1\u8d27\uff0c\u8bf7\u4fee\u6539\u53d1\u8d27\u6570 ");
                    }
                }
            });
            if (t.getSoQty() - t.getQty() < 0.0) {
                throw new BusinessException(ApiCode.FAIL, "\u8d85\u8ba2\u5355\u91cf\u53d1\u8d27\uff0c\u8bf7\u4fee\u6539\u672c\u6b21\u53d1\u8d27\u6570 ");
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    void textsaldod(List<SalDoDSaveVO> param) {
        param.stream().forEach(t -> {
            if (t.getSoQty() == null) {
                t.setSoQty(Double.valueOf(0.0));
            }
            if (t.getQty() == null) {
                t.setQty(Double.valueOf(0.0));
            }
            if (t.getSoQty() - t.getQty() < 0.0) {
                throw new BusinessException(ApiCode.FAIL, "\u8d85\u8ba2\u5355\u91cf\u53d1\u8d27\uff0c\u8bf7\u4fee\u6539\u672c\u6b21\u53d1\u8d27\u6570 ");
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    Long conservesaldo(SalDoSaveVO param) {
        BigDecimal taxAmts = new BigDecimal(0);
        BigDecimal netAmts = new BigDecimal(0);
        BigDecimal amts = new BigDecimal(0);
        Double qtys = 0.0;
        Double qty2s = 0.0;
        Double volumes = 0.0;
        Double grossWeights = 0.0;
        List salDodSaveList = param.getSalDodSaleList();
        Iterator iterator = salDodSaveList.iterator();
        while (iterator.hasNext()) {
            SalDoDSaveVO v2;
            v2.setTransPrice((v2 = (SalDoDSaveVO)iterator.next()).getTransPrice() != null ? v2.getTransPrice() : BigDecimal.ZERO);
            v2.setPrice(v2.getPrice() != null ? v2.getPrice() : BigDecimal.ZERO);
            v2.setQty(Double.valueOf(v2.getQty() != null ? v2.getQty() : 0.0));
            v2.setGrossWeight(Double.valueOf(v2.getGrossWeight() != null ? v2.getGrossWeight() : 0.0));
            v2.setVolume(Double.valueOf(v2.getVolume() != null ? v2.getVolume() : 0.0));
            v2.setNetAmt(v2.getQty() != null && v2.getTransPrice() != null ? BigDecimal.valueOf(v2.getQty()).multiply(v2.getTransPrice()) : new BigDecimal(0));
            v2.setAmt(v2.getQty() != null && v2.getPrice() != null ? BigDecimal.valueOf(v2.getQty()).multiply(v2.getPrice()) : new BigDecimal(0));
            v2.setTaxAmt(v2.getAmt() != null && v2.getNetAmt() != null ? v2.getAmt().subtract(v2.getNetAmt()) : new BigDecimal(0));
            v2.setCostPrice(v2.getCostPrice() != null ? v2.getCostPrice() : new BigDecimal(0));
            v2.setCostAmt(v2.getCostPrice().multiply(new BigDecimal(v2.getQty())));
            v2.setCreateTime(LocalDateTime.now());
            v2.setModifyTime(LocalDateTime.now());
            v2.setMasId(param.getId());
            amts = amts.add(v2.getAmt());
            netAmts = netAmts.add(v2.getNetAmt());
            taxAmts = taxAmts.add(v2.getTaxAmt());
            qtys = qtys + v2.getQty();
            volumes = volumes + v2.getVolume();
            grossWeights = grossWeights + v2.getGrossWeight();
        }
        param.setTaxAmt(taxAmts);
        param.setNetAmt(netAmts);
        param.setAmt(amts);
        param.setQty(qtys);
        param.setVolume(volumes);
        param.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
        param.setGrossWeight(grossWeights);
        param.setDocDate(LocalDateTime.now());
        SalDoDO salDoDO = new SalDoDO();
        BeanUtils.copyProperties((Object)param, (Object)salDoDO);
        salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_DR.getValueCode());
        this.update(salDoDO);
        List salDodDos = salDodSaveList.stream().map(SalDodCovert.INSTANCE::voToDO).collect(Collectors.toList());
        List<SalDoDDO> salDodDoS = salDodDos.stream().filter(v -> v.getId() != null).collect(Collectors.toList());
        List salDodDoS2 = salDodDos.stream().filter(v -> v.getId() == null).collect(Collectors.toList());
        if (salDodDoS.size() > 0) {
            this.updateSalDodBatch(salDodDoS);
        }
        if (salDodDoS2.size() > 0) {
            this.salDoDRepo.saveAll(salDodDoS2);
        }
        return param.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    Long conservesalso(SalDoSaveVO param) {
        BigDecimal taxAmts = new BigDecimal(0);
        BigDecimal netAmts = new BigDecimal(0);
        BigDecimal amts = new BigDecimal(0);
        Double qtys = 0.0;
        Double qty2s = 0.0;
        Double volumes = 0.0;
        Double grossWeights = 0.0;
        List salDodSaveList = param.getSalDodSaleList();
        ArrayList<SalDoDDO> salDodCreateParams = new ArrayList<SalDoDDO>();
        for (SalDoDSaveVO sal : salDodSaveList) {
            SalDoDDO salDoDdO = new SalDoDDO();
            BeanUtils.copyProperties((Object)sal, (Object)salDoDdO);
            salDoDdO.setCreateTime(LocalDateTime.now());
            salDoDdO.setModifyTime(LocalDateTime.now());
            salDoDdO.setTransPrice(salDoDdO.getTransPrice() == null ? new BigDecimal(0) : salDoDdO.getTransPrice());
            salDoDdO.setPrice(salDoDdO.getPrice() == null ? new BigDecimal(0) : salDoDdO.getPrice());
            salDoDdO.setQty(salDoDdO.getQty() != null ? salDoDdO.getQty() : 0.0);
            salDoDdO.setNetAmt(salDoDdO.getQty() != null && salDoDdO.getTransPrice() != null ? BigDecimal.valueOf(salDoDdO.getQty()).multiply(salDoDdO.getTransPrice()) : new BigDecimal(0));
            salDoDdO.setAmt(salDoDdO.getQty() != null && salDoDdO.getPrice() != null ? BigDecimal.valueOf(salDoDdO.getQty()).multiply(salDoDdO.getPrice()) : new BigDecimal(0));
            salDoDdO.setTaxAmt(salDoDdO.getAmt() != null && salDoDdO.getNetAmt() != null ? salDoDdO.getAmt().subtract(salDoDdO.getNetAmt()) : new BigDecimal(0));
            salDoDdO.setCostPrice(salDoDdO.getCostPrice() != null ? salDoDdO.getCostPrice() : new BigDecimal(0));
            salDoDdO.setCostAmt(salDoDdO.getCostPrice().multiply(new BigDecimal(salDoDdO.getQty())));
            salDoDdO.setGrossWeight(salDoDdO.getGrossWeight() != null ? salDoDdO.getGrossWeight() : 0.0);
            salDoDdO.setVolume(salDoDdO.getVolume() != null ? salDoDdO.getVolume() : 0.0);
            amts = amts.add(salDoDdO.getAmt());
            netAmts = netAmts.add(salDoDdO.getNetAmt());
            taxAmts = taxAmts.add(salDoDdO.getTaxAmt());
            qtys = qtys + salDoDdO.getQty();
            volumes = volumes + salDoDdO.getVolume();
            grossWeights = grossWeights + salDoDdO.getGrossWeight();
            salDodCreateParams.add(salDoDdO);
        }
        param.setTaxAmt(taxAmts);
        param.setNetAmt(netAmts);
        param.setAmt(amts);
        param.setQty(qtys);
        param.setVolume(volumes);
        param.setGrossWeight(grossWeights);
        SalDoDO salDoDO = new SalDoDO();
        BeanUtils.copyProperties((Object)param, (Object)salDoDO);
        salDoDO.setGenType(UdcEnum.COM_DOC_GEN_TYPE_MANU.getValueCode());
        salDoDO.setDocStatus(UdcEnum.SAL_DO_STATUS_DR.getValueCode());
        salDoDO.setDocNo(this.getInvAjDocNo(salDoDO));
        salDoDO.setDocDate(LocalDateTime.now());
        salDoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
        salDoDO.setDocCls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
        Long id = ((SalDoDO)this.salDoRepo.save(salDoDO)).getId();
        salDodCreateParams.stream().forEach(v -> v.setMasId(id));
        if (salDodCreateParams.size() > 0) {
            this.salDoDRepo.saveAll(salDodCreateParams);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(SalDoSaveVO param) throws ExecutionException, InterruptedException {
        Long id = 0L;
        if (CollectionUtils.isEmpty((Collection)param.getSalDodSaleList())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u751f\u6210\u53d1\u8d27\u5355\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d1\u8d27\u5355\u660e\u7ec6\u662f\u5426\u6709\u503c");
        }
        this.textsaldod(param.getSalDodSaleList());
        id = param.getId() != null ? this.conservesaldo(param) : this.conservesalso(param);
        return String.valueOf(id);
    }

    @Override
    public void exportSearchDo(HttpServletResponse response, SalDoQueryParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        param.setDocCls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
        SalDoQueryParamVO salDoSelectParam = new SalDoQueryParamVO();
        if (!CollectionUtil.isEmpty((Collection)param.getIds())) {
            salDoSelectParam.setIds(param.getIds());
            salDoSelectParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        } else {
            salDoSelectParam = param;
        }
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"createTime"));
        salDoSelectParam.setOrders(orders);
        List records = this.searchDo(salDoSelectParam).getRecords();
        List<SalDoExImport> salDoExImports = this.exportSearchsalDo(param, records);
        ExcelWriteUtil.excelWrite1(response, salDoExImports, SalDoExImport.class, "\u53d1\u8d27\u5355\u67e5\u8be2", "\u53d1\u8d27\u5355\u67e5\u8be2");
    }

    @Override
    @SysCodeProc
    public PagingVO<SalDoRespVO> searchDo(SalDoQueryParamVO param) throws ExecutionException, InterruptedException {
        PagingVO paging = new PagingVO();
        try {
            if (!StringUtils.isEmpty((Object)param.getOuIdString())) {
                param.setOuId(Long.valueOf(Long.parseLong(param.getOuIdString())));
            }
        }
        catch (Exception e) {
            return paging;
        }
        if (!StringUtils.isEmpty((Object)param.getPhysicalWhCode())) {
            List whids = this.invWhService.findIdByPhyCode(param.getPhysicalWhCode()).stream().distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(whids)) {
                param.setWhIds(whids);
            } else {
                return paging;
            }
        }
        try {
            if (!StringUtils.isEmpty((Object)param.getCustIdString())) {
                param.setCustId(Long.valueOf(Long.parseLong(param.getCustIdString())));
            }
        }
        catch (Exception e) {
            return paging;
        }
        List<Long> masIds = null;
        if (param.getCustName() != null) {
            ArrayList orgCustVOS = new ArrayList();
            List collect = orgCustVOS.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            param.setCustIdlist(collect);
        }
        if (!StringUtils.isEmpty((Object)param.getItemName())) {
            masIds = this.salDoDService.findItemNameByLike(param.getItemName());
            if (CollectionUtils.isEmpty(masIds)) {
                PagingVO pagingVO = new PagingVO();
                return pagingVO;
            }
            param.setMasIds(masIds);
        }
        if (!StringUtils.isEmpty((Object)param.getEmpName())) {
            ArrayList userIds = new ArrayList();
            if (!CollectionUtils.isEmpty(userIds)) {
                param.setCreateUserIds(userIds);
            } else {
                return paging;
            }
        }
        QSalDoDO salDo = QSalDoDO.salDoDO;
        BooleanExpression predicate = salDo.isNotNull();
        JPAQuery<SalDoRespVO> jpaQuery = this.salDoRepoproc.selectsalDo(param);
        if (!StringUtils.isEmpty((Object)param.getHavaReturnedAll())) {
            jpaQuery.where((Predicate)salDo.id.notIn(this.salDoDService.findReturnedQtyEqQty2Ids()));
        }
        long dataCount = jpaQuery.fetchCount();
        this.salDoRepoproc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QSalDoDO.salDoDO);
        List lists = jpaQuery.fetch();
        List collect = Optional.ofNullable(lists.stream()).orElseThrow(() -> {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, ApiCode.BUSINESS_EXCEPTION.getMsg());
        }).map(SalDoRespVO::getId).collect(Collectors.toList());
        this.trans(lists);
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    List<SalDoRespVO> trans(List<SalDoRespVO> lists) {
        List collect15 = lists.stream().map(SalDoRespVO::getRecvCountry).filter(Objects::nonNull).collect(Collectors.toList());
        List collect16 = lists.stream().map(SalDoRespVO::getRecvProvince).filter(Objects::nonNull).collect(Collectors.toList());
        List collect17 = lists.stream().map(SalDoRespVO::getRecvCounty).filter(Objects::nonNull).collect(Collectors.toList());
        List collect18 = lists.stream().map(SalDoRespVO::getRecvCity).filter(Objects::nonNull).collect(Collectors.toList());
        collect15.removeAll(collect16);
        collect15.removeAll(collect17);
        collect15.removeAll(collect18);
        collect15.addAll(collect16);
        collect15.addAll(collect17);
        collect15.addAll(collect18);
        ArrayList byDistCodes = new ArrayList();
        if (!CollectionUtils.isEmpty(collect15)) {
            // empty if block
        }
        List custids = lists.stream().map(SalDoRespVO::getCustId).filter(Objects::nonNull).collect(Collectors.toList());
        List empids = lists.stream().map(SalDoRespVO::getCreateUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List createUserIds = lists.stream().map(SalDoRespVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List whids = lists.stream().map(SalDoRespVO::getWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> soids = lists.stream().map(SalDoRespVO::getRelateDocId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> collect10 = lists.stream().map(SalDoRespVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List collect6 = lists.stream().map(SalDoRespVO::getSaleGroup).filter(Objects::nonNull).collect(Collectors.toList());
        List ouids = lists.stream().map(SalDoRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList());
        List buids = lists.stream().map(SalDoRespVO::getBuId).filter(Objects::nonNull).collect(Collectors.toList());
        List soscenes = lists.stream().map(SalDoRespVO::getSoScene).filter(Objects::nonNull).collect(Collectors.toList());
        List itembrands = lists.stream().map(SalDoRespVO::getSaleGroup).collect(Collectors.toList());
        ArrayList orgBuVos = new ArrayList();
        if (!CollectionUtils.isEmpty(buids)) {
            // empty if block
        }
        ArrayList orgCustVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(custids)) {
            // empty if block
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(createUserIds)) {
            // empty if block
        }
        List orgWhVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(whids)) {
            try {
                orgWhVoS = this.invWhService.findIdBatch(whids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<Object> salSoVoS = java.util.Collections.synchronizedList(new ArrayList());
        if (CollectionUtils.isEmpty(soids)) {
            try {
                salSoVoS = this.salSoService.findIdBatch(soids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList orgOuDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(ouids)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(soscenes)) {
            // empty if block
        }
        List<Object> salDodVoS = new ArrayList();
        try {
            salDodVoS = this.salDoDService.findByMasId(collect10);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List<Object> finalSalDodVoS = salDodVoS;
        ArrayList finalOrgBuVos = orgBuVos;
        ArrayList finalOrgOuVos = orgOuDoS;
        ArrayList finalOrgCustVoS = orgCustVoS;
        List finalOrgWhVoS = orgWhVoS;
        List<Object> finalSalSoVoS = salSoVoS;
        ArrayList finalSysUserDoS = sysUserDoS;
        Map<Object, Object> distMap = new HashMap(16);
        if (!org.springframework.util.CollectionUtils.isEmpty(byDistCodes)) {
            distMap = byDistCodes.stream().collect(Collectors.toMap(ComDistrictComboVO::getCode, ComDistrictComboVO::getName, (o1, o2) -> o2));
        }
        HashMap finalDistMap = distMap;
        lists.stream().forEach(v -> {
            Optional<OrgBuVO> first;
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)byDistCodes)) {
                if (finalDistMap.containsKey(v.getRecvCountry())) {
                    v.setRecvCountryName((String)finalDistMap.get(v.getRecvCountry()));
                }
                if (finalDistMap.containsKey(v.getRecvProvince())) {
                    v.setRecvProvinceName((String)finalDistMap.get(v.getRecvProvince()));
                }
                if (finalDistMap.containsKey(v.getRecvCounty())) {
                    v.setRecvCountyName((String)finalDistMap.get(v.getRecvCounty()));
                }
                if (finalDistMap.containsKey(v.getRecvCity())) {
                    v.setRecvCityName((String)finalDistMap.get(v.getRecvCity()));
                }
            }
            v.setOuterOu(!StringUtils.isEmpty((Object)v.getOuterOu()) ? v.getOuterOu() : "");
            v.setOuterType(!StringUtils.isEmpty((Object)v.getOuterType()) ? v.getOuterType() : "");
            v.setOuterNo(!StringUtils.isEmpty((Object)v.getOuterNo()) ? v.getOuterNo() : "");
            v.setOuterOuTypeNo(v.getOuterOu() + v.getOuterType() + v.getOuterNo());
            v.setRecvCountryName(!StringUtils.isEmpty((Object)v.getRecvCountryName()) ? v.getRecvCountryName() : "");
            v.setRecvProvinceName(!StringUtils.isEmpty((Object)v.getRecvProvinceName()) ? v.getRecvProvinceName() : "");
            v.setRecvCityName(!StringUtils.isEmpty((Object)v.getRecvCityName()) ? v.getRecvCityName() : "");
            v.setRecvDetailaddr(!StringUtils.isEmpty((Object)v.getRecvDetailaddr()) ? v.getRecvDetailaddr() : "");
            v.setRecvSite(v.getRecvCountryName() + v.getRecvProvinceName() + v.getRecvCityName() + v.getRecvDetailaddr());
            if (!CollectionUtils.isEmpty((Collection)finalSalDodVoS)) {
                List salDodVosList = finalSalDodVoS.stream().filter(s -> v.getId().equals(s.getMasId())).filter(Objects::nonNull).collect(Collectors.toList());
                v.setSalDodRespVOList(salDodVosList);
            }
            if (v.getBuId() == null || (first = finalOrgBuVos.stream().filter(t -> v.getBuId().equals(t.getId())).findFirst()).isPresent()) {
                // empty if block
            }
            if (v.getSoScene() != null) {
                // empty if block
            }
            if (v.getCreateUserId() != null && (first = finalSysUserDoS.stream().filter(e -> v.getCreateUserId().equals(e.getId())).findFirst()).isPresent()) {
                v.setEmpName(((SysUserDO)first.get()).getFirstName());
            }
            if (v.getOuId() == null || (first = finalOrgOuVos.stream().filter(o -> v.getOuId().equals(o.getId())).findFirst()).isPresent()) {
                // empty if block
            }
            if (v.getCustId() != null && (first = finalOrgCustVoS.stream().filter(o -> v.getCustId().equals(o.getId())).findFirst()).isPresent()) {
                v.setCustCode(((OrgCustVO)first.get()).getCustCode());
                v.setCustName(((OrgCustVO)first.get()).getCustName());
            }
            if (v.getWhId() != null && (first = finalOrgWhVoS.stream().filter(o -> v.getWhId().equals(o.getId())).findFirst()).isPresent()) {
                v.setWhCode(((InvWhRespVO)first.get()).getWhCode());
                v.setWhName(((InvWhRespVO)first.get()).getWhName());
                v.setWhAddrNo(((InvWhRespVO)first.get()).getAddrNo());
                v.setPhysicalWhCode(((InvWhRespVO)first.get()).getPhysicalWhCode() != null && ((InvWhRespVO)first.get()).getWhAbbr() != null ? ((InvWhRespVO)first.get()).getPhysicalWhCode() + " " + ((InvWhRespVO)first.get()).getWhAbbr() : null);
            }
            if (v.getRelateDocId() != null && (first = finalSalSoVoS.stream().filter(o -> v.getRelateDocId().equals(o.getId())).findFirst()).isPresent()) {
                v.setSalSoDocNo(((SalSoRespVO)first.get()).getDocNo());
                v.setCustSoNo(((SalSoRespVO)first.get()).getCustSoNo());
                v.setRecvCountry(((SalSoRespVO)first.get()).getRecvCountry());
                v.setRecvProvince(((SalSoRespVO)first.get()).getRecvProvince());
                v.setRecvCity(((SalSoRespVO)first.get()).getRecvCity());
                v.setRecvCounty(((SalSoRespVO)first.get()).getRecvCounty());
                v.setRecvStreet(((SalSoRespVO)first.get()).getRecvStreet());
                v.setRecvDetailaddr(((SalSoRespVO)first.get()).getRecvDetailaddr());
                v.setInvalidDate(((SalSoRespVO)first.get()).getInvalidDate());
            }
        });
        List whdaddrno = lists.stream().map(SalDoRespVO::getWhAddrNo).collect(Collectors.toList());
        ArrayList tmpList2 = new ArrayList();
        if (!CollectionUtils.isEmpty(whdaddrno)) {
            // empty if block
        }
        ArrayList finalTmpList = tmpList2;
        lists.stream().forEach(v -> {
            Optional<InvAddrAddressVO> first;
            if (v.getWhAddrNo() != null && (first = finalTmpList.stream().filter(o -> v.getWhAddrNo().equals(o.getAddrNo())).findFirst()).isPresent()) {
                v.setWhCity(first.get().getCity());
            }
        });
        return lists;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelSalDoBatch(List<String> ids) {
        List<Long> ids2 = ids.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        this.salDoRepo.cancelSalDoBatch("N", ids2);
    }

    @Override
    public List<SalDoRespVO> findByIds(List<Long> ids) {
        return this.salDoRepo.findByIdIn(ids).stream().map(SalDoCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public Optional<SalDoRespVO> findIdSalDoid(String id) throws ExecutionException, InterruptedException {
        JPAQuery<SalDoRespVO> jpaQuery = this.salDoRepoproc.select(null);
        QSalDoDO qsalDo = QSalDoDO.salDoDO;
        jpaQuery.where((Predicate)qsalDo.id.eq((Object)Long.valueOf(id)));
        SalDoRespVO salDo = (SalDoRespVO)jpaQuery.fetchOne();
        SalDoRespVO salDoRespVO = this.addSalDo(salDo);
        this.tranSalDo(salDoRespVO);
        salDoRespVO.setOuterOu(!StringUtils.isEmpty((Object)salDoRespVO.getOuterOu()) ? salDoRespVO.getOuterOu() : "");
        salDoRespVO.setOuterType(!StringUtils.isEmpty((Object)salDoRespVO.getOuterType()) ? salDoRespVO.getOuterType() : "");
        salDoRespVO.setOuterNo(!StringUtils.isEmpty((Object)salDoRespVO.getOuterNo()) ? salDoRespVO.getOuterNo() : "");
        salDoRespVO.setOuterOuTypeNo(salDoRespVO.getOuterOu() + salDoRespVO.getOuterType() + salDoRespVO.getOuterNo());
        List<SalDoDRespVO> salDodRespVoList = this.salDoDService.findByMasId(Long.valueOf(id));
        if (!CollectionUtils.isEmpty(salDodRespVoList)) {
            salDoRespVO.setSalDodRespVOList(salDodRespVoList);
        }
        return Optional.ofNullable(salDoRespVO);
    }

    public SalDoRespVO addSalDo(SalDoRespVO salDo) {
        Optional<SalSoRespVO> salSoRespVO;
        if (salDo.getRelateDocId() != null && (salSoRespVO = this.salSoService.findIdOne(salDo.getRelateDocId())).isPresent()) {
            SalSoRespVO soRespVO = salSoRespVO.get();
            salDo.setCustSoNo(soRespVO.getCustSoNo());
            salDo.setRecvCountry(soRespVO.getRecvCountry());
            salDo.setRecvProvince(soRespVO.getRecvProvince());
            salDo.setRecvCity(soRespVO.getRecvCity());
            salDo.setRecvCounty(soRespVO.getRecvCounty());
            salDo.setRecvStreet(soRespVO.getRecvStreet());
            salDo.setRecvContactName(soRespVO.getRecvContactName());
            salDo.setRecvContactTel(soRespVO.getRecvContactTel());
            salDo.setRecvDetailaddr(soRespVO.getRecvDetailaddr());
            salDo.setDeliverStoreType(soRespVO.getDeliverStoreType());
            salDo.setAllowPartalDeliver(soRespVO.getAllowPartalDeliver());
            salDo.setCustSoDate(soRespVO.getCustSoDate());
            salDo.setDeliverMethod(soRespVO.getDeliverMethod());
        }
        return salDo;
    }

    void tranSalDo(SalDoRespVO salSoVO) {
        Object orgEmpVO = null;
        Object orgCustVO = null;
        Object orgWhVO = null;
    }

    @Override
    @SysCodeProc
    public Optional<SalDoRespVO> findIdSalSoid(String salsoid) throws ExecutionException, InterruptedException {
        SalDoRespVO salDoVO = this.salSoService.createSalDo(Long.valueOf(salsoid));
        this.tranSalDo(salDoVO);
        List<Object> salDodList = new ArrayList();
        try {
            salDodList = this.salDoDService.createsaldod(Long.valueOf(salsoid));
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u660e\u7ec6\u4e2d\u6570\u636e\u4e0d\u5b58\u5728" + salsoid);
        }
        if (salDodList != null) {
            salDodList.stream().forEach(v -> {
                v.setOuId(salDoVO.getOuId());
                v.setBdId(salDoVO.getBdId());
                v.setBuId(salDoVO.getBuId());
                v.setBdId(salDoVO.getBdId());
                v.setCustId(salDoVO.getCustId());
                v.setSoQty(v.getQty());
                v.setRelateDocNo(salDoVO.getRelateDocNo());
            });
            List<SalDoDRespVO> salDodRespVoList = salDodList.stream().filter(t -> t.getQty() > 0.0).collect(Collectors.toList());
            this.tranSalDods(salDodRespVoList);
            salDoVO.setSalDodRespVOList(salDodRespVoList);
        }
        return Optional.ofNullable(salDoVO);
    }

    void tranSalDods(List<SalDoDRespVO> salDodVoS) {
        List itemIds = salDodVoS.stream().map(SalDoDRespVO::getItemId).collect(Collectors.toList());
        List modifyUserIds = salDodVoS.stream().map(SalDoDRespVO::getModifyUserId).collect(Collectors.toList());
        List lotNoS = salDodVoS.stream().map(v -> v.getItemId() + "_" + v.getVariId() + "_" + v.getLotNo()).collect(Collectors.toList());
        ArrayList itmItemVoS = new ArrayList();
        ArrayList invItemPkgVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(itemIds)) {
            // empty if block
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(modifyUserIds)) {
            // empty if block
        }
        ArrayList byAndItemIdAndLotNo = new ArrayList();
        if (!CollectionUtils.isEmpty(lotNoS)) {
            // empty if block
        }
        salDodVoS.stream().forEach(v -> {
            Optional<ItmItemVO> first;
            if (v.getItemId() != null) {
                Optional<InvItemPkgVO> itmItemPkgVO;
                first = itmItemVoS.stream().filter(i -> v.getItemId().equals(i.getId())).findFirst();
                if (first.isPresent()) {
                    v.setItemCode(first.get().getItemCode());
                    v.setItemName(first.get().getItemName());
                    v.setItemSpec(first.get().getPackageSpec());
                    v.setBrand(first.get().getBrand());
                    v.setBrandName(first.get().getBrandName());
                    v.setBrand2(first.get().getBrand2());
                    v.setBrand2Name(first.get().getBrand2Name());
                    v.setUom(first.get().getUom());
                }
                if ((itmItemPkgVO = invItemPkgVoS.stream().filter(t -> v.getItemId().equals(t.getItemId())).findFirst()).isPresent()) {
                    v.setWeightUom(itmItemPkgVO.get().getWeightUom());
                }
            }
            if ((first = byAndItemIdAndLotNo.stream().filter(s -> (s.getLotNo() + s.getVariId() + s.getItemId()).equals(v.getLotNo() + v.getVariId() + v.getItemId())).findFirst()).isPresent()) {
                v.setManuDate(((InvLotVO)first.get()).getManuDate());
                v.setExpireDate(((InvLotVO)first.get()).getExpireDate());
            }
        });
        List collect2 = salDodVoS.stream().map(SalDoDRespVO::getBrand).collect(Collectors.toList());
        List itmBrandVoS = null;
        salDodVoS.stream().forEach(v -> {
            Optional<ComC2VO> first;
            if (!StringUtils.isEmpty((Object)v.getBrand()) && (first = itmBrandVoS.stream().filter(o -> v.getBrand().equals(o.getC2Code())).findFirst()).isPresent()) {
                v.setBrandName(first.get().getC2Name());
            }
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<SalDoRespVO> search(SalDoQueryParamVO param) {
        Page ret = this.salDoRepo.findAll(this.salDoRepoproc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().map(SalDoCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(collect).build();
    }

    @Override
    @SysCodeProc
    public Optional<SalDoRespVO> findIdOne(Long id) {
        return this.salDoRepo.findById(id).map(SalDoCovert.INSTANCE::doToRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SalDoRespVO> findIdBatch(List<Long> idList) {
        return this.salDoRepo.findAllById(idList).stream().map(SalDoCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.salDoRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.salDoRepo.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalDoDO salDo = QSalDoDO.salDoDO;
        BooleanExpression predicate = salDo.isNotNull();
        Optional optionalItem = this.salDoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalDoDO do1 = (SalDoDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salDoRepo.save(do1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        ids.forEach(id -> {
            QSalDoDO salDo = QSalDoDO.salDoDO;
            BooleanExpression predicate = salDo.isNotNull();
            Optional optionalItem = this.salDoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salDo.id.eq(id))));
            if (!optionalItem.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
            }
            SalDoDO do1 = (SalDoDO)optionalItem.get();
            do1.setDeleteFlag(1);
            this.salDoRepo.save(do1);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    void changeInvStk(SalDoDO salDoVO, List<SalDoDDO> salDodVoS) {
        ArrayList<InvStkCommon28InVO> invStkCommon28InVoS = new ArrayList<InvStkCommon28InVO>();
        for (SalDoDDO salDodVO : salDodVoS) {
            InvStkCommon28InVO invStkCommon28InVO = new InvStkCommon28InVO();
            invStkCommon28InVO.setQty(salDodVO.getQty2());
            invStkCommon28InVO.setDocNo(salDoVO.getDocNo());
            invStkCommon28InVO.setLineNo(salDodVO.getLineNo());
            invStkCommon28InVO.setOpDate(LocalDateTime.now());
            invStkCommon28InVO.setCreateUserId(salDoVO.getModifyUserId());
            String relateDocCls = salDoVO.getRelateDocCls();
            if (UdcEnum.COM_DOC_CLS_SO.getValueCode().equals(relateDocCls)) {
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_01_01);
            } else if (UdcEnum.COM_DOC_CLS_DO.getValueCode().equals(relateDocCls)) {
                invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_01_01);
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            invStkCommon28InVO.setInvStk28Enum2(InvStk28Enum.O_TYPE_01_02);
            invStkCommon28InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
            invStkCommon28InVO.setSrcDocId(salDoVO.getId());
            invStkCommon28InVO.setSrcDocDid(salDodVO.getRelateDocDid());
            invStkCommon28InVO.setItemId(salDodVO.getItemId());
            if (salDodVO.getVariId() != null && salDodVO.getVariId() == 0L) {
                salDodVO.setVariId(null);
            }
            invStkCommon28InVO.setVariId(salDodVO.getVariId());
            invStkCommon28InVO.setWhId(salDodVO.getWhId());
            invStkCommon28InVO.setDeter1(salDodVO.getDeter1());
            invStkCommon28InVO.setDeter2(salDodVO.getDeter2());
            invStkCommon28InVO.setDeter3(salDodVO.getDeter3());
            invStkCommon28InVO.setLotNo(salDodVO.getLotNo());
            invStkCommon28InVO.setUom(salDodVO.getUom());
            invStkCommon28InVoS.add(invStkCommon28InVO);
        }
        this.invStkCommonService.invStkCommon28(invStkCommon28InVoS);
    }

    @Transactional(rollbackFor={Exception.class})
    void changeInvStk2Public(List<SalDoSaveVO> param) {
        ArrayList<InvStkCommon28InVO> invStkCommon28InVoS = new ArrayList<InvStkCommon28InVO>();
        for (SalDoSaveVO salDoCreateParam : param) {
            List salDodCreateParamList = salDoCreateParam.getSalDodSaleList();
            for (SalDoDSaveVO salDodVO : salDodCreateParamList) {
                InvStkCommon28InVO invStkCommon28InVO = new InvStkCommon28InVO();
                invStkCommon28InVO.setQty(salDodVO.getQty2());
                invStkCommon28InVO.setDocNo(salDoCreateParam.getDocNo());
                invStkCommon28InVO.setLineNo(salDodVO.getLineNo());
                invStkCommon28InVO.setOpDate(LocalDateTime.now());
                invStkCommon28InVO.setCreateUserId(salDodVO.getModifyUserId());
                String relateDocCls = salDoCreateParam.getRelateDocCls();
                if (UdcEnum.COM_DOC_CLS_SO.getValueCode().equals(relateDocCls)) {
                    invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_01_01);
                } else if (UdcEnum.COM_DOC_CLS_DO.getValueCode().equals(relateDocCls)) {
                    invStkCommon28InVO.setInvStk28Enum1(InvStk28Enum.O_TYPE_01_01);
                } else {
                    throw new BusinessException(ApiCode.FAIL, "\u9500\u552e\u8ba2\u5355\u51fa\u5e93\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                invStkCommon28InVO.setInvStk28Enum2(InvStk28Enum.O_TYPE_01_02);
                invStkCommon28InVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_DO.getValueCode());
                invStkCommon28InVO.setSrcDocId(salDoCreateParam.getId());
                invStkCommon28InVO.setSrcDocDid(salDodVO.getRelateDocDid());
                invStkCommon28InVO.setItemId(salDodVO.getItemId());
                if (salDodVO.getVariId() != null && salDodVO.getVariId() == 0L) {
                    salDodVO.setVariId(null);
                }
                invStkCommon28InVO.setVariId(salDodVO.getVariId());
                invStkCommon28InVO.setWhId(salDodVO.getWhId());
                invStkCommon28InVO.setDeter1(salDodVO.getDeter1());
                invStkCommon28InVO.setDeter2(salDodVO.getDeter2());
                invStkCommon28InVO.setDeter3(salDodVO.getDeter3());
                invStkCommon28InVO.setLotNo(salDodVO.getLotNo());
                invStkCommon28InVO.setUom(salDodVO.getUom());
                invStkCommon28InVoS.add(invStkCommon28InVO);
            }
        }
        this.invStkCommonService.invStkCommon28(invStkCommon28InVoS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SalDoDO objDo) {
        Optional optional = this.salDoRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (SalDoDO)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.salDoRepo.save((SalDoDO)optional.get());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSalDodBatch(List<SalDoDDO> objDo) {
        List longStream = objDo.stream().map(BaseModel::getId).collect(Collectors.toList());
        List optional = this.salDoDRepo.findAllById(longStream);
        if (Collections.isEmpty((Collection)optional)) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        optional.stream().forEach(v -> objDo.stream().forEach(o -> {
            if (v.getId().equals(o.getId())) {
                BeanCopyUtil.beanCopy(o, v);
            }
        }));
        this.salDoDRepo.saveAll(optional);
    }

    public SalDoServiceImpl(SalDoRepo salDoRepo, SalSoRepo salSoRepo, SalSoAllocRepoProc salSoAllocRepoProc, SalDoRepoProc salDoRepoproc, SalDoDService salDoDService, SalSoAllocRepo salSoAllocRepo, SalSoService salSoService, SalSoRepoProc salSoRepoProc, SalSoDRepo salSodRepo, SalSoDRepoProc salSoDRepoProc, SalDoDRepo salDoDRepo, SalSoDService salSoDService, InvWhService invWhService, SalSoAllocService salSoAllocService, InvStkCommonService invStkCommonService, InvStkCommonService InvStkCommonService2, SysNumberRuleService sysNumberRuleService, InvLotService invLotService, PurSs2Service purSs2Service) {
        this.salDoRepo = salDoRepo;
        this.salSoRepo = salSoRepo;
        this.salSoAllocRepoProc = salSoAllocRepoProc;
        this.salDoRepoproc = salDoRepoproc;
        this.salDoDService = salDoDService;
        this.salSoAllocRepo = salSoAllocRepo;
        this.salSoService = salSoService;
        this.salSoRepoProc = salSoRepoProc;
        this.salSodRepo = salSodRepo;
        this.salSoDRepoProc = salSoDRepoProc;
        this.salDoDRepo = salDoDRepo;
        this.salSoDService = salSoDService;
        this.invWhService = invWhService;
        this.salSoAllocService = salSoAllocService;
        this.invStkCommonService = invStkCommonService;
        this.InvStkCommonService = InvStkCommonService2;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invLotService = invLotService;
        this.purSs2Service = purSs2Service;
    }
}

