/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.sal.convert.SalSoAllocCovert;
import com.elitesland.sal.entity.QSalSoAllocDO;
import com.elitesland.sal.entity.SalSoAllocDO;
import com.elitesland.sal.param.SalSoAllocQueryParamVO;
import com.elitesland.sal.repo.SalSoAllocRepo;
import com.elitesland.sal.repo.SalSoAllocRepoProc;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="salSoAllocService")
public class SalSoAllocServiceImpl
implements SalSoAllocService {
    private final SalSoAllocRepo salSoAllocRepo;
    private final SalSoAllocRepoProc salSoAllocRepoproc;

    @Override
    @SysCodeProc
    public List<SalSoAllocRespVO> findLotNoSodIdBatch(List<Long> idList) {
        QSalSoAllocDO salSolloc = QSalSoAllocDO.salSoAllocDO;
        Iterable all = this.salSoAllocRepo.findAll((Predicate)salSolloc.deleteFlag.eq((Object)0).or((Predicate)salSolloc.deleteFlag.isNull()).and((Predicate)salSolloc.soDId.in(idList)));
        return Lists.newArrayList((Iterable)all).stream().map(SalSoAllocCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    public List<Long> findMasIdByLotNo(String lontNo) {
        List<Tuple> allByIdIn = this.salSoAllocRepo.findMasIdByLotNo(lontNo);
        List<Long> collect = allByIdIn.stream().filter(v -> !StringUtils.isEmpty((Object)v) && v.get(0) != null).map(v -> Long.valueOf(v.get(0).toString())).collect(Collectors.toList());
        return collect;
    }

    @Override
    @SysCodeProc
    public List<SalSoAllocRespVO> findbySalsods(List<Long> soDid) {
        JPAQuery jpaQuery = (JPAQuery)this.salSoAllocRepoproc.selectMadIdlsit(null).where(this.salSoAllocRepoproc.wherefindbySalsods(soDid));
        long dataCount = jpaQuery.fetchCount();
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalSoAllocRespVO> search(SalSoAllocQueryParamVO param) {
        Page ret = this.salSoAllocRepo.findAll(this.salSoAllocRepoproc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().map(SalSoAllocCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(collect).build();
    }

    @Override
    @SysCodeProc
    public Optional<SalSoAllocRespVO> findIdOne(Long id) {
        return this.salSoAllocRepo.findById(id).map(SalSoAllocCovert.INSTANCE::doToRespVO);
    }

    @Override
    public List<SalSoAllocRespVO> findIdBatch(List<Long> idList) {
        return this.salSoAllocRepo.findAllById(idList).stream().map(SalSoAllocCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.salSoAllocRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.salSoAllocRepo.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalSoAllocDO salSolloc = QSalSoAllocDO.salSoAllocDO;
        BooleanExpression predicate = salSolloc.isNotNull();
        Optional optionalItem = this.salSoAllocRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSolloc.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalSoAllocDO do1 = (SalSoAllocDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salSoAllocRepo.save(do1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        ids.forEach(id -> {
            QSalSoAllocDO salSolloc = QSalSoAllocDO.salSoAllocDO;
            BooleanExpression predicate = salSolloc.isNotNull();
            Optional optionalItem = this.salSoAllocRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSolloc.id.eq(id))));
            if (!optionalItem.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
            }
            SalSoAllocDO do1 = (SalSoAllocDO)optionalItem.get();
            do1.setDeleteFlag(1);
            this.salSoAllocRepo.save(do1);
        });
    }

    public SalSoAllocServiceImpl(SalSoAllocRepo salSoAllocRepo, SalSoAllocRepoProc salSoAllocRepoproc) {
        this.salSoAllocRepo = salSoAllocRepo;
        this.salSoAllocRepoproc = salSoAllocRepoproc;
    }
}

