/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.inv.dto.ItmItemVO;
import com.elitesland.inv.service.InvItemPkgService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.resp.InvItemPkgRespVO;
import com.elitesland.sal.convert.SalSodCovert;
import com.elitesland.sal.entity.QSalSoDDO;
import com.elitesland.sal.entity.SalSoDDO;
import com.elitesland.sal.param.SalSoDQueryParamVO;
import com.elitesland.sal.repo.SalSoDRepo;
import com.elitesland.sal.repo.SalSoDRepoProc;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.service.SalSoDService;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.sal.vo.resp.SalSoDRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.entity.SysUserDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="salSoDService")
public class SalSoDServiceImpl
implements SalSoDService {
    private final SalSoDRepo salSoDRepo;
    private final SalSoDRepoProc salSoDRepoProc;
    private final SalSoAllocService salSoAllocService;
    private final InvItemPkgService invItemPkgService;

    @Override
    public List<Long> findMasIdByLike(String itmKeyWord) {
        QSalSoDDO salSod = QSalSoDDO.salSoDDO;
        JPAQuery<Long> where = this.salSoDRepoProc.selectMasId(itmKeyWord);
        return where.fetch();
    }

    @Override
    public void updateReturnedQtyAndCoAmtById(Double returnedQty, BigDecimal coAmt, Long id) {
        this.salSoDRepoProc.updateReturnedQtyAndCoAmtById(returnedQty, coAmt, id);
    }

    @Override
    public List<SalSoDDO> findSalSodDosByMasId(Long masId) {
        return this.salSoDRepoProc.findSalSodDosByMasId(masId);
    }

    @Override
    @SysCodeProc
    public List<SalSoDRespVO> findAllById(List<Long> ids) throws ExecutionException, InterruptedException {
        List<SalSoDRespVO> lists = Optional.ofNullable(this.salSoDRepo.findAllById(ids).stream()).orElseThrow(() -> {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }).map(v -> {
            SalSoDRespVO salSodVo = new SalSoDRespVO();
            BeanUtils.copyProperties((Object)v, (Object)salSodVo);
            return salSodVo;
        }).collect(Collectors.toList());
        this.tranList(lists);
        return lists;
    }

    List<SalSoDRespVO> tranList(List<SalSoDRespVO> lists) throws ExecutionException, InterruptedException {
        List itemids = lists.stream().map(SalSoDRespVO::getItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ids = lists.stream().map(BaseModelVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List modifyUserIds = lists.stream().map(BaseModelVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(modifyUserIds)) {
            // empty if block
        }
        List<Object> salSoAllocVos = new ArrayList();
        if (!CollectionUtils.isEmpty(ids)) {
            try {
                salSoAllocVos = this.salSoAllocService.findLotNoSodIdBatch(ids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList itmItemVoS = new ArrayList();
        List invItempkgVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(itemids)) {
            try {
                invItempkgVoS = this.invItemPkgService.findByItemIdIn(itemids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<Object> finalSalSoAllocVos = salSoAllocVos;
        ArrayList finalInvItempkgVoS = invItempkgVoS;
        lists.stream().forEach(v -> {
            Optional<SalSoAllocRespVO> first;
            v.setShippedQty(Double.valueOf(v.getShippedQty() != null ? v.getShippedQty() : 0.0));
            v.setReturnedQty(Double.valueOf(v.getReturnedQty() != null ? v.getReturnedQty() : 0.0));
            v.setCancelQty(Double.valueOf(v.getCancelQty() != null ? v.getCancelQty() : 0.0));
            v.setCancelQty(Double.valueOf(v.getCancelQty() != null ? v.getCancelQty() : 0.0));
            if (v.getTransPrice() != null && v.getCancelQty() != null && v.getShippedQty() != null) {
                v.setSendPrice(BigDecimal.valueOf(v.getShippedQty()).multiply(v.getTransPrice()));
                v.setGetPrice(BigDecimal.valueOf(v.getCancelQty()).multiply(v.getTransPrice()));
            }
            if (v.getId() != null && (first = finalSalSoAllocVos.stream().filter(t -> v.getId().equals(t.getSoDId())).findFirst()).isPresent()) {
                v.setLotNo(first.get().getLotNo());
            }
            if (v.getItemId() != null) {
                Optional<ItmItemVO> first3;
                first = finalInvItempkgVoS.stream().filter(t -> v.getItemId().equals(t.getItemId())).findFirst();
                if (first.isPresent()) {
                    if (((InvItemPkgRespVO)first.get()).getVolume() != null) {
                        v.setVolume(Double.valueOf(String.valueOf(((InvItemPkgRespVO)first.get()).getVolume())));
                    }
                    v.setWeightUom(((InvItemPkgRespVO)first.get()).getWeightUom());
                }
                if ((first3 = itmItemVoS.stream().filter(t -> v.getItemId().equals(t.getId())).findFirst()).isPresent()) {
                    v.setItemCode(first3.get().getItemCode());
                    v.setItemName(first3.get().getItemName());
                    v.setBrand(first3.get().getBrand());
                    v.setBrand2(first3.get().getBrand2());
                    v.setUom(first3.get().getUom());
                    if (first3.get().getTaxRate() != null) {
                        v.setTaxRate(Double.valueOf(String.valueOf(first3.get().getTaxRate())));
                    }
                    v.setDeter1(first3.get().getTempType());
                    v.setPackageSpec(first3.get().getPackageSpec());
                }
            }
            if (v.getModifyUserId() != null && (first = sysUserDoS.stream().filter(e -> v.getModifyUserId().equals(e.getId())).findFirst()).isPresent()) {
                v.setEmpName(((SysUserDO)first.get()).getFirstName());
            }
        });
        return lists;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalSoDRespVO> search(SalSoDQueryParamVO param) {
        Page ret = this.salSoDRepo.findAll(this.salSoDRepoProc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().map(SalSodCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(collect).build();
    }

    @Override
    @SysCodeProc
    public Optional<SalSoDRespVO> findIdOne(Long id) {
        return this.salSoDRepo.findById(id).map(SalSodCovert.INSTANCE::doToRespVO);
    }

    @Override
    public List<SalSoDRespVO> findmaxIdOne(Long id) {
        SalSoDQueryParamVO salSodQueryParam = new SalSoDQueryParamVO();
        salSodQueryParam.setMasId(id);
        JPAQuery<SalSoDRespVO> jpaQuery = this.salSoDRepoProc.select(salSodQueryParam);
        long dataCount = jpaQuery.fetchCount();
        List fetch = jpaQuery.fetch();
        return fetch;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SalSoDRespVO> findIdBatch(List<Long> idList) {
        return this.salSoDRepo.findAllById(idList).stream().map(SalSodCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.salSoDRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.salSoDRepo.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalSoDDO salSod = QSalSoDDO.salSoDDO;
        BooleanExpression predicate = salSod.isNotNull();
        Optional optionalItem = this.salSoDRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSod.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalSoDDO do1 = (SalSoDDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salSoDRepo.save(do1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        ids.forEach(id -> {
            QSalSoDDO salSod = QSalSoDDO.salSoDDO;
            BooleanExpression predicate = salSod.isNotNull();
            Optional optionalItem = this.salSoDRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSod.id.eq(id))));
            if (!optionalItem.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
            }
            SalSoDDO do1 = (SalSoDDO)optionalItem.get();
            do1.setDeleteFlag(1);
            this.salSoDRepo.save(do1);
        });
    }

    @Override
    public void updateReturnReasonCodeById(String returnReasonCode, Long id) {
        this.salSoDRepoProc.updateReturnReasonCodeById(returnReasonCode, id);
    }

    public SalSoDServiceImpl(SalSoDRepo salSoDRepo, SalSoDRepoProc salSoDRepoProc, SalSoAllocService salSoAllocService, InvItemPkgService invItemPkgService) {
        this.salSoDRepo = salSoDRepo;
        this.salSoDRepoProc = salSoDRepoProc;
        this.salSoAllocService = salSoAllocService;
        this.invItemPkgService = invItemPkgService;
    }
}

