/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.BaseModel;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.inv.service.InvLotService;
import com.elitesland.inv.service.InvWhAreaService;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.inv.vo.resp.InvWhRespVO;
import com.elitesland.org.service.OrgBuService;
import com.elitesland.org.service.OrgOuService;
import com.elitesland.sal.constant.SalEnum;
import com.elitesland.sal.entity.QSalDoDO;
import com.elitesland.sal.entity.SalDoDDO;
import com.elitesland.sal.entity.SalDoDO;
import com.elitesland.sal.entity.SalSoAllocDO;
import com.elitesland.sal.entity.SalSoDDO;
import com.elitesland.sal.entity.SalSoDO;
import com.elitesland.sal.entity.importentity.SalDoReturnExcelImport;
import com.elitesland.sal.param.SalRdoQueryParamVO;
import com.elitesland.sal.repo.SalDoDRepo;
import com.elitesland.sal.repo.SalDoDRepoProc;
import com.elitesland.sal.repo.SalDoRepo;
import com.elitesland.sal.repo.SalDoRepoProc;
import com.elitesland.sal.repo.SalSoAllocRepo;
import com.elitesland.sal.repo.SalSoDRepo;
import com.elitesland.sal.repo.SalSoDRepoProc;
import com.elitesland.sal.repo.SalSoRepo;
import com.elitesland.sal.repo.SalSoRepoProc;
import com.elitesland.sal.service.SalDoDService;
import com.elitesland.sal.service.SalDoService;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.service.SalSoDService;
import com.elitesland.sal.service.SalSoReturnService;
import com.elitesland.sal.service.SalSoService;
import com.elitesland.sal.vo.resp.SalDoDRespVO;
import com.elitesland.sal.vo.resp.SalRdoDRespVO;
import com.elitesland.sal.vo.resp.SalRdoRespVO;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.sal.vo.resp.SalSoRespVO;
import com.elitesland.sal.vo.save.SalRdoDSaveVO;
import com.elitesland.sal.vo.save.SalRdoSaveVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.system.entity.SysUserDTO;
import com.elitesland.system.service.SysNumberRuleService;
import com.elitesland.system.service.SysUdcService;
import com.elitesland.system.service.SysUserService;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.util.ExcelWriteUtil;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="salSoReturnService")
public class SalSoReturnServiceImpl
implements SalSoReturnService {
    private static final Logger log = LoggerFactory.getLogger(SalSoReturnServiceImpl.class);
    private final SalSoRepoProc salSoRepoProc;
    private final SalSoService salSoService;
    private final SalSoAllocRepo salSoAllocRepo;
    private final SalSoRepo salSoRepo;
    private final SalSoRepoProc salSodRepoProc;
    private final SalDoRepo salDoRepo;
    private final SalSoDRepo salSoDRepo;
    private final SalDoRepoProc salDoRepoProc;
    private final SalDoDRepo salDodRepo;
    private final SalDoDRepoProc salDodRepoProc;
    private final SalSoDService salSoDService;
    private final SalSoDRepoProc salSoDRepoProc;
    private final SysUserService sysUserService;
    private final OrgOuService orgOuService;
    private final InvWhService invWhService;
    private final OrgBuService orgBuService;
    private final SalSoAllocService salSoAllocService;
    private final SalDoDService salDoDService;
    private final SalDoService salDoService;
    private final SysUdcService sysUdcService;
    private final InvWhService orgWhService;
    private final InvLotService invLotService;
    private final InvWhAreaService orgWhAreaService;
    public static final Integer EXPIRE_TIME = 5;
    private final SysNumberRuleService sysNumberRuleService;
    private List<SalRdoRespVO> salDoVoS;

    private String getInvAjDocNo(SalDoDO salDoDO) {
        String docNo = null;
        docNo = this.sysNumberRuleService.generateCode("DOSO", List.of(String.valueOf(salDoDO.getOuId())));
        return docNo;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalRdoRespVO> searchReturnDo(SalRdoQueryParamVO param) throws ExecutionException, InterruptedException, ExecutionException, InterruptedException {
        List<Object> salRsoIds;
        PagingVO pagingVO = new PagingVO();
        if (param != null && !StringUtils.isEmpty((Object)param.getCustKeyWord())) {
            String custKeyWord = param.getCustKeyWord();
            ArrayList custIds = new ArrayList();
            param.setCustIds(custIds);
        }
        if (param != null && !StringUtils.isEmpty((Object)param.getReturnWhKeyWord())) {
            String returnWhkeyWord = param.getReturnWhKeyWord();
            List<Object> whIds = new ArrayList();
            try {
                whIds = this.invWhService.list(returnWhkeyWord).stream().map(orgWhListVO -> orgWhListVO.getId()).collect(Collectors.toList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(whIds)) {
                param.setWhIds(whIds);
            } else {
                return pagingVO;
            }
        }
        if (param != null && !StringUtils.isEmpty((Object)param.getItmKeyWord())) {
            List<Object> doids = new ArrayList();
            try {
                doids = this.salDoDService.findMasIdByLike(param.getItmKeyWord());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(doids)) {
                param.setIds(doids);
            } else {
                return pagingVO;
            }
        }
        if (param != null && !StringUtils.isEmpty((Object)param.getDoDocNo())) {
            salRsoIds = new ArrayList();
            try {
                salRsoIds = this.findSalRsoByDoDocNo(param.getDoDocNo()).stream().map(BaseModel::getId).collect(Collectors.toList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(salRsoIds)) {
                param.setSalRdoIds(salRsoIds);
            } else {
                return pagingVO;
            }
        }
        if (param != null && !StringUtils.isEmpty((Object)param.getSoDocNo())) {
            salRsoIds = new ArrayList();
            try {
                salRsoIds = this.findSalRsoIdsBySoDocNo(param.getSoDocNo());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(salRsoIds)) {
                param.setSalRsoIds(salRsoIds);
            } else {
                return pagingVO;
            }
        }
        QSalDoDO qSalDoDO = QSalDoDO.salDoDO;
        JPAQuery jpaQuery = (JPAQuery)this.salDoRepoProc.selectR(null).where(this.salDoRepoProc.whereRdo(param));
        long total = jpaQuery.fetchCount();
        jpaQuery.orderBy(qSalDoDO.modifyTime.desc());
        List salDoVoS = jpaQuery.fetch();
        List<Long> soIdList = salDoVoS.stream().map(salDoVO -> salDoVO.getId()).collect(Collectors.toList());
        ArrayList<SalRdoDRespVO> salDodVoS = new ArrayList();
        try {
            salDodVoS = this.salDoDService.findByrMasId(soIdList);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tian(salDoVoS, salDodVoS);
        pagingVO.setRecords(salDoVoS);
        pagingVO.setTotal(Long.valueOf(total));
        return pagingVO;
    }

    @Override
    @SysCodeProc
    public Optional<SalRdoRespVO> selectReturnbyid(String id) throws ExecutionException, InterruptedException, ExecutionException, InterruptedException {
        JPAQuery<SalRdoRespVO> jpaQuery = this.salDoRepoProc.selectR(null);
        QSalDoDO saldo = QSalDoDO.salDoDO;
        jpaQuery.where((Predicate)saldo.id.eq((Object)Long.valueOf(id)));
        SalRdoRespVO salDo = (SalRdoRespVO)jpaQuery.fetchOne();
        List<SalRdoDRespVO> salDodRespVoList = this.salDoDService.findByrMasId(Long.valueOf(id));
        this.tian(List.of(salDo), salDodRespVoList);
        return Optional.ofNullable(salDo);
    }

    @Override
    public List<SalSoDO> findSalRsoByDoDocNo(String doDocNo) {
        return this.salSoRepoProc.findSalRsoByDoDocNo(doDocNo);
    }

    @Override
    public List<Long> findSalRsoIdsBySoDocNo(String soDocNo) {
        return this.salSoRepo.findSalRsoBySoDocNo(soDocNo);
    }

    @Override
    public List<Map<Long, SalSoDO>> findSalSosByRsoId(List<Long> rSoIds) {
        HashMap<Long, SalSoDO> salsoMap = new HashMap<Long, SalSoDO>(16);
        List<Map<String, Object>> salSos = this.salSoRepo.findSalSosByRsoIds(rSoIds);
        ArrayList<Map<Long, SalSoDO>> salSoMaps = new ArrayList<Map<Long, SalSoDO>>();
        if (!org.springframework.util.CollectionUtils.isEmpty(salSos)) {
            for (Map<String, Object> salSo : salSos) {
                SalSoDO salSoDO = new SalSoDO();
                salSoDO.setId(Long.valueOf(salSo.get("id").toString()));
                salSoDO.setDocNo(salSo.get("docNo").toString());
                salsoMap.put(Long.valueOf(salSo.get("rsoId").toString()), salSoDO);
                salSoMaps.add(salsoMap);
            }
        }
        return salSoMaps;
    }

    private void tian(List<SalRdoRespVO> lists, List<SalRdoDRespVO> sodVoS) {
        List<Long> soDidList = sodVoS.stream().map(BaseModelVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List ouids = lists.stream().map(SalRdoRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList());
        List custids = lists.stream().map(SalRdoRespVO::getCustId).filter(Objects::nonNull).collect(Collectors.toList());
        List createUserIds = lists.stream().map(SalRdoRespVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List whids = lists.stream().map(SalRdoRespVO::getWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List soids = lists.stream().map(SalRdoRespVO::getRelateDocId).filter(Objects::nonNull).collect(Collectors.toList());
        List itembrands = lists.stream().map(SalRdoRespVO::getSaleGroup).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList orgOuDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(ouids)) {
            // empty if block
        }
        ArrayList orgCustVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(custids)) {
            // empty if block
        }
        List orgWhVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(whids)) {
            try {
                orgWhVoS = this.invWhService.findIdBatch(whids);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(createUserIds)) {
            // empty if block
        }
        List<Object> salSoAllocVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(soDidList)) {
            try {
                salSoAllocVoS = this.salSoAllocService.findLotNoSodIdBatch(soDidList);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        List distCodeList = new ArrayList();
        List recvCountryCodes = lists.stream().filter(f -> !StringUtils.isEmpty((Object)f.getRecvCountry())).map(SalRdoRespVO::getRecvCountry).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recvProvinceCodes = lists.stream().filter(f -> !StringUtils.isEmpty((Object)f.getRecvProvince())).map(SalRdoRespVO::getRecvProvince).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recvCountyCodes = lists.stream().filter(f -> !StringUtils.isEmpty((Object)f.getRecvCounty())).map(SalRdoRespVO::getRecvCounty).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recvRecvCityCodes = lists.stream().filter(f -> !StringUtils.isEmpty((Object)f.getRecvCity())).map(SalRdoRespVO::getRecvCity).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        distCodeList.addAll(recvCountryCodes);
        distCodeList.addAll(recvProvinceCodes);
        distCodeList.addAll(recvCountyCodes);
        distCodeList.addAll(recvRecvCityCodes);
        distCodeList = distCodeList.stream().distinct().collect(Collectors.toList());
        ArrayList comDistrictComboVOList = new ArrayList();
        if (!CollectionUtils.isEmpty(distCodeList)) {
            // empty if block
        }
        List<Long> soIds = lists.stream().filter(o -> o.getRelateDocId() != null).map(SalRdoRespVO::getRelateDocId).collect(Collectors.toList());
        List salSoDoS = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(soIds)) {
            try {
                salSoDoS = this.salSoRepo.findAllById(soIds);
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        ArrayList finalSalSoDoS = salSoDoS;
        List<Object> salSos = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(soIds)) {
            try {
                salSos = this.findSalSosByRsoId(soIds);
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        }
        Map<Object, Object> distMap = new HashMap(16);
        if (!org.springframework.util.CollectionUtils.isEmpty(comDistrictComboVOList)) {
            distMap = comDistrictComboVOList.stream().collect(Collectors.toMap(ComDistrictComboVO::getCode, ComDistrictComboVO::getName, (o1, o2) -> o2));
        }
        ArrayList finalSysUserList = sysUserDoS;
        List finalOrgWhVoS = orgWhVoS;
        List<Object> finalSalSos = salSos;
        HashMap finalDistMap = distMap;
        lists.forEach(e -> {
            Optional<SalSoRespVO> salSoVoOptional;
            orgOuDoS.stream().filter(ou -> ou.getId().equals(e.getOuId())).findFirst().ifPresent(o -> e.setOuName(o.getName()));
            orgCustVoS.stream().filter(c -> c.getId().equals(e.getCustId())).findFirst().ifPresent(o -> {
                e.setCustName(o.getCustName());
                e.setCustCode(o.getCustCode());
            });
            finalOrgWhVoS.stream().filter(c -> c.getId().equals(e.getWhId())).findFirst().ifPresent(o -> {
                e.setWhName(o.getWhName());
                e.setWhCode(o.getWhCode());
                e.setWhType(o.getWhType());
                e.setWhType2(o.getWhType2());
            });
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)finalSysUserList)) {
                finalSysUserList.stream().filter(c -> c.getId().equals(e.getModifyUserId())).findFirst().ifPresent(o -> e.setEmpName(o.getUsername()));
            }
            List salSodVoS = sodVoS.stream().filter(soD -> soD.getMasId().equals(e.getId())).collect(Collectors.toList());
            e.setSalDodRespVOList(salSodVoS);
            e.setDocStatus2(e.getDocStatus());
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)finalSalSoDoS)) {
                finalSalSoDoS.stream().filter(o -> o.getId().equals(e.getRelateDocId())).findFirst().ifPresent(o -> {
                    e.setCustSoNo(o.getCustSoNo());
                    e.setDoDocNo(o.getRelateDocNo());
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)finalSalSos)) {
                        finalSalSos.stream().filter(so -> so.containsKey(o.getId())).findFirst().ifPresent(so -> e.setSoDocNo(((SalSoDO)so.get(o.getId())).getDocNo()));
                    }
                });
            }
            if (!(StringUtils.isEmpty((Object)e.getOuterOu()) || StringUtils.isEmpty((Object)e.getOuterType()) || StringUtils.isEmpty((Object)e.getOuterOu()))) {
                e.setOuterOuTypeNo(e.getOuterOu() + e.getOuterType() + e.getOuterNo());
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)comDistrictComboVOList)) {
                if (finalDistMap.containsKey(e.getRecvCountry())) {
                    e.setRecvCountryName((String)finalDistMap.get(e.getRecvCountry()));
                }
                if (finalDistMap.containsKey(e.getRecvProvince())) {
                    e.setRecvProvinceName((String)finalDistMap.get(e.getRecvProvince()));
                }
                if (finalDistMap.containsKey(e.getRecvCounty())) {
                    e.setRecvCountyName((String)finalDistMap.get(e.getRecvCounty()));
                }
                if (finalDistMap.containsKey(e.getRecvCity())) {
                    e.setRecvCityName((String)finalDistMap.get(e.getRecvCity()));
                }
            }
            if (!StringUtils.isEmpty((Object)e.getRelateDocId()) && (salSoVoOptional = this.salSoService.findById(e.getRelateDocId())).isPresent()) {
                SalSoRespVO salSoVO = salSoVoOptional.get();
                e.setDeliverStoreType(salSoVO.getDeliverStoreType());
                e.setReturnMatFlag(salSoVO.getReturnMatFlag());
            }
        });
    }

    @Override
    public List<SalDoReturnExcelImport> exportSalDo(List<SalRdoRespVO> salDoVoS) {
        ArrayList<SalDoReturnExcelImport> salDoReturnExcelImports = new ArrayList<SalDoReturnExcelImport>();
        salDoVoS.stream().forEach(v -> {
            List salDodVoS = v.getSalDodRespVOList();
            salDodVoS.stream().forEach(a -> {
                SalDoReturnExcelImport salDoReturnExcelImport = new SalDoReturnExcelImport();
                BeanCopyUtil.beanCopy(a, salDoReturnExcelImport);
                BeanCopyUtil.beanCopy(v, salDoReturnExcelImport);
                salDoReturnExcelImport.setAmt2(a.getAmt());
                salDoReturnExcelImport.setRemark2(a.getRemark());
                salDoReturnExcelImport.setNetAm2(a.getNetAmt());
                salDoReturnExcelImport.setTaxAmt2(a.getTaxAmt());
                salDoReturnExcelImport.setLotNo(StringUtils.isEmpty((Object)a.getLotNo()) ? "/" : a.getLotNo());
                salDoReturnExcelImport.setRemark2(StringUtils.isEmpty((Object)a.getRemark()) ? "/" : a.getRemark());
                salDoReturnExcelImport.setItemCsCode(StringUtils.isEmpty((Object)a.getItemCsCode()) ? "/" : a.getItemCsCode());
                salDoReturnExcelImport.setWhName(v.getWhCode() + " " + v.getWhName() + " " + v.getTransportTempName());
                salDoReturnExcelImport.setQty(a.getQty2());
                salDoReturnExcelImports.add(salDoReturnExcelImport);
            });
        });
        return salDoReturnExcelImports;
    }

    @Override
    public void exportSalDoReturn(HttpServletResponse response, SalRdoQueryParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        SalRdoQueryParamVO salDoQueryParamVO = new SalRdoQueryParamVO();
        if (!CollectionUtil.isEmpty((Collection)param.getIds())) {
            salDoQueryParamVO.setIds(param.getIds());
            salDoQueryParamVO.setSize(Integer.valueOf(Integer.MAX_VALUE));
        } else {
            salDoQueryParamVO = param;
        }
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"createTime"));
        salDoQueryParamVO.setOrders(orders);
        List salDoVoS = this.searchReturnDo(salDoQueryParamVO).getRecords();
        List<SalDoReturnExcelImport> salDoReturnExcelImports = this.exportSalDo(salDoVoS);
        ExcelWriteUtil.excelWrite1(response, salDoReturnExcelImports, SalDoReturnExcelImport.class, "\u9500\u552e\u8ba2\u5355\u9000\u8d27\u5165\u5e93\u5355", "\u9500\u552e\u8ba2\u5355\u9000\u8d27\u5165\u5e93\u5355\u660e\u7ec6");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SalSoDO createKcReturn(SalRdoSaveVO param) throws ExecutionException, InterruptedException {
        SalSoDO salSoDO = this.insertOrUpdateSalRso(param, true);
        return salSoDO;
    }

    private SalSoDO insertOrUpdateSalRso(SalRdoSaveVO param, boolean isNew) {
        ArrayList<SalSoDDO> salSodDoList = new ArrayList<SalSoDDO>();
        ArrayList<SalSoAllocDO> salSoAllocDOList = new ArrayList<SalSoAllocDO>();
        boolean isSubmit = param.isSubmit();
        boolean isWhPhysical = false;
        boolean intfFlag = param.getIntfFlag();
        boolean isJcReturn = false;
        boolean isCf = true;
        String docType = null;
        boolean hasWorkflow = false;
        this.checkDocStatus(param, isWhPhysical, isJcReturn, docType);
        SalSoDO salSoDO = new SalSoDO();
        BeanUtils.copyProperties((Object)param, (Object)salSoDO);
        this.createSalso(salSoDO, param, isCf, docType, isJcReturn, salSodDoList, salSoAllocDOList, isNew, isSubmit, isWhPhysical);
        if (isNew) {
            this.salSoRepo.save(salSoDO);
        } else {
            this.salSoUpdate(salSoDO);
        }
        this.saveSodAndAlloc(param, isNew, isSubmit, isJcReturn, salSodDoList, salSoAllocDOList, salSoDO);
        return salSoDO;
    }

    void saveSodAndAlloc(SalRdoSaveVO param, boolean isNew, boolean isSubmit, boolean isJcReturn, List<SalSoDDO> salSodDoList, List<SalSoAllocDO> salSoAllocDOList, SalSoDO salSoDO) {
        Long masId = salSoDO.getId();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)param.getSalRdodSaleList())) {
            salSodDoList.forEach(t -> t.setMasId(masId));
            if (!isNew) {
                this.salSoDRepo.deleteByMasId(masId);
            }
            List salSodDoBatch = this.salSoDRepo.saveAll(salSodDoList);
            Map<Double, Long> salSodIdMap = salSodDoBatch.stream().collect(Collectors.toMap(SalSoDDO::getLineNo, BaseModel::getId));
            salSoAllocDOList.forEach(t -> {
                t.setMasId(masId);
                t.setSoDId((Long)salSodIdMap.get(t.getLineNo()));
            });
            if (!isNew) {
                this.salSoAllocRepo.deleteByMasId(masId);
            }
            List salSoAllocDoBatch = this.salSoAllocRepo.saveAll(salSoAllocDOList);
            if (isSubmit) {
                if (!isJcReturn) {
                    this.startWorkflow(salSoDO.getId());
                } else {
                    this.insertSalRdo(null, salSoDO, salSodDoBatch, salSoAllocDoBatch, false);
                }
            }
        } else if (!isNew) {
            this.salSoDRepo.deleteByMasId(masId);
        }
    }

    void createSalso(SalSoDO salSoDO, SalRdoSaveVO param, boolean isCf, String docType, boolean isJcReturn, List<SalSoDDO> salSodDoList, List<SalSoAllocDO> salSoAllocDOList, boolean isNew, boolean isSubmit, boolean isWhPhysical) {
        Double totalQty = 0.0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal soGrossWeight = new BigDecimal("0.00");
        BigDecimal soVolume = new BigDecimal("0.00");
        BigDecimal soQty = new BigDecimal("0.00");
        BigDecimal soTaxAmt = new BigDecimal("0.00");
        BigDecimal soAmt = new BigDecimal("0.00");
        BigDecimal soNetAmt = new BigDecimal("0.00");
        Map<Long, SalDoDRespVO> salDodVoMap = null;
        HashMap<Long, Double> occupiedQtyMap = null;
        ArrayList<Long> relateDocIds = new ArrayList<Long>();
        Double lineNo = 0.0;
        List salDodCreateParams = param.getSalRdodSaleList();
        Map<Long, SalSoAllocRespVO> salSoAllocVoMap = new HashMap<Long, SalSoAllocRespVO>(16);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)salDodCreateParams)) {
            if (isJcReturn) {
                List<Long> soAllocIds;
                List<Long> singleMasId = Collections.singletonList(param.getRelateDocId());
                List<SalDoDRespVO> salDodVoList = this.salDoDService.findByMasIds(singleMasId);
                if (param.getSalRdodSaleList().size() != salDodVoList.size()) {
                    isCf = false;
                    docType = "DB".equals(param.getRelateDocType()) ? "C2" : "CI";
                }
                salDodVoMap = salDodVoList.stream().collect(Collectors.toMap(SalDoDRespVO::getId, t -> t));
                relateDocIds.add(param.getRelateDocId());
                List<SalSoDDO> submittedSalRsodList = this.salSoDRepoProc.findSalRsoDdosByRelateDocId(relateDocIds);
                if (!org.springframework.util.CollectionUtils.isEmpty(submittedSalRsodList)) {
                    occupiedQtyMap = new HashMap<Long, Double>(16);
                    for (SalSoDDO salRsod : submittedSalRsodList) {
                        Long relateDocDid = salRsod.getRelateDocDid();
                        Double occupiedQty = salRsod.getQty() == null ? 0.0 : salRsod.getQty();
                        if (occupiedQtyMap.containsKey(relateDocDid)) {
                            occupiedQtyMap.put(relateDocDid, (Double)occupiedQtyMap.get(relateDocDid) + occupiedQty);
                            continue;
                        }
                        occupiedQtyMap.put(relateDocDid, occupiedQty);
                    }
                }
                if (!org.springframework.util.CollectionUtils.isEmpty(soAllocIds = param.getSalRdodSaleList().stream().filter(o -> o.getSoAllocId() != null).map(SalRdoDSaveVO::getSoAllocId).collect(Collectors.toList()))) {
                    salSoAllocVoMap = this.salSoAllocService.findIdBatch(soAllocIds).stream().collect(Collectors.toMap(BaseModelVO::getId, t -> t));
                }
            }
            String returnReasonCode = param.getReturnReasonCode();
            Boolean returnMatFlag = param.getReturnMatFlag();
            Long custId = param.getCustId();
            for (SalRdoDSaveVO salDodCreateParam : salDodCreateParams) {
                lineNo = lineNo + 1.0;
                this.createAddSalDo(salDodCreateParam, salSoAllocDOList, lineNo, salSoDO, isJcReturn, soGrossWeight, soVolume, soQty, soTaxAmt, soAmt, soNetAmt, salSoAllocVoMap, totalQty, totalAmt, salDodVoMap, occupiedQtyMap, docType, param, isCf, custId, salSodDoList);
            }
        }
        salSoDO.setDocCls(UdcEnum.COM_DOC_CLS_RSO.getValueCode());
        salSoDO.setDocType(docType);
        salSoDO.setGrossWeight(soGrossWeight.doubleValue());
        salSoDO.setVolume(soVolume.doubleValue());
        salSoDO.setQty(soQty.doubleValue());
        salSoDO.setTaxAmt(soTaxAmt);
        salSoDO.setAmt(soAmt);
        salSoDO.setNetAmt(soNetAmt);
        if (isNew) {
            salSoDO.setId(null);
            ArrayList<String> runtimeValues = new ArrayList<String>();
            runtimeValues.add(salSoDO.getOuId().toString().substring(salSoDO.getOuId().toString().length() - 3));
            String docNo = this.sysNumberRuleService.generateCode(docType, runtimeValues);
            salSoDO.setDocNo(docNo);
        }
        salSoDO.setDocStatus(UdcEnum.SAL_RSO_STATUS_DR.getValueCode());
        salSoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
        if (isJcReturn) {
            if (isSubmit) {
                salSoDO.setDocStatus(UdcEnum.SAL_RSO_STATUS_WF.getValueCode());
                salSoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
            }
        } else if (isSubmit) {
            salSoDO.setDocStatus(UdcEnum.SAL_RSO_STATUS_WF.getValueCode());
            if (!isWhPhysical) {
                salSoDO.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_DS.getValueCode());
            }
        }
    }

    void createAddSalDo(SalRdoDSaveVO salDodCreateParam, List<SalSoAllocDO> salSoAllocDOList, Double lineNo, SalSoDO salSoDO, boolean isJcReturn, BigDecimal soGrossWeight, BigDecimal soVolume, BigDecimal soQty, BigDecimal soTaxAmt, BigDecimal soAmt, BigDecimal soNetAmt, Map<Long, SalSoAllocRespVO> salSoAllocVoMap, Double totalQty, BigDecimal totalAmt, Map<Long, SalDoDRespVO> salDodVoMap, Map<Long, Double> occupiedQtyMap, String docType, SalRdoSaveVO param, boolean isCf, Long custId, List<SalSoDDO> salSodDoList) {
        Long ouId = salDodCreateParam.getOuId();
        Long buId = salDodCreateParam.getBuId();
        Long bdId = salDodCreateParam.getBdId();
        Long pcId = salDodCreateParam.getPcId();
        Long whId = salDodCreateParam.getWhId();
        if (whId == null) {
            whId = salSoDO.getWhId();
        }
        String deter1 = salDodCreateParam.getDeter1();
        String deter2 = salDodCreateParam.getDeter2();
        String deter3 = salDodCreateParam.getDeter3();
        Long itemId = salDodCreateParam.getItemId();
        Double qty = salDodCreateParam.getQty();
        String uom = salDodCreateParam.getUom();
        Double uomRatio = salDodCreateParam.getUomRatio();
        Double packQty = salDodCreateParam.getPackQty();
        String packUom = salDodCreateParam.getPackUom();
        Double netWeight = salDodCreateParam.getNetWeight();
        Double grossWeight = salDodCreateParam.getGrossWeight();
        String weightUom = salDodCreateParam.getWeightUom();
        Double volume = salDodCreateParam.getVolume();
        String volumeUom = salDodCreateParam.getVolumeUom();
        Long variId = salDodCreateParam.getVariId();
        String taxRateNo = salDodCreateParam.getTaxRateNo();
        Double taxRate = salDodCreateParam.getTaxRate();
        String currCode = salDodCreateParam.getCurrCode();
        BigDecimal basePrice = salDodCreateParam.getBasePrice();
        String priceType = salDodCreateParam.getPriceType();
        BigDecimal price = salDodCreateParam.getPrice();
        BigDecimal netPrice = salDodCreateParam.getNetPrice();
        BigDecimal transPrice = salDodCreateParam.getTransPrice();
        netPrice = netPrice == null ? BigDecimal.ZERO : netPrice;
        price = netPrice.multiply(new BigDecimal(1.0 + taxRate));
        BigDecimal transTaxPrice = transPrice.multiply(new BigDecimal(1.0 + taxRate));
        BigDecimal taxAmt = salDodCreateParam.getTaxAmt();
        BigDecimal amt = salDodCreateParam.getAmt();
        BigDecimal netAmt = salDodCreateParam.getNetAmt();
        String relateDocCls = salDodCreateParam.getRelateDocCls();
        String relateDocType = salDodCreateParam.getRelateDocType();
        Long relateDocId = salDodCreateParam.getRelateDocId();
        String relateDocNo = salDodCreateParam.getRelateDocNo();
        Long relateDocDid = salDodCreateParam.getRelateDocDid();
        Double relateDocLineNo = salDodCreateParam.getRelateDocLineno();
        String remark = salDodCreateParam.getRemark();
        if (grossWeight != null) {
            soGrossWeight = soGrossWeight.add(new BigDecimal(grossWeight.toString()));
        }
        if (volume != null) {
            soVolume = soVolume.add(new BigDecimal(volume.toString()));
        }
        if (qty != null) {
            soQty = soQty.add(new BigDecimal(qty.toString()));
        }
        if (taxAmt != null) {
            soTaxAmt = soTaxAmt.add(taxAmt);
        }
        if (amt != null) {
            soAmt = soAmt.add(amt);
        }
        if (netAmt != null) {
            soNetAmt = soNetAmt.add(netAmt);
        }
        Long soAllocId = salDodCreateParam.getSoAllocId();
        String lotNo = salDodCreateParam.getLotNo();
        Double allocQty = null;
        Double shippedQty = null;
        if (isJcReturn) {
            if (soAllocId == null) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u6279\u6b21\u6570\u636e\u4e3a\u7a7a\uff0c\u884c\u53f7\uff1a" + lineNo);
            }
            SalSoAllocRespVO salSoAllocVO = salSoAllocVoMap.get(soAllocId);
            if (salSoAllocVO == null) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u6279\u6b21\u6570\u636e\u4e3a\u7a7a\uff0c\u884c\u53f7\uff1a" + lineNo);
            }
            lotNo = salSoAllocVO.getLotNo();
            allocQty = salSoAllocVO.getAllocQty();
            shippedQty = salSoAllocVO.getShippedQty();
        }
        totalQty = totalQty + qty;
        totalAmt = totalAmt.add(amt);
        if (isJcReturn) {
            double occupiedQty;
            SalDoDRespVO salDodVO = salDodVoMap.get(salDodCreateParam.getRelateDocDid());
            if (salDodVO == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u83b7\u53d6\u5230\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f");
            }
            double remainQty = salDodVO.getQty2() - (salDodVO.getReturnedQty() == null ? 0.0 : salDodVO.getReturnedQty());
            double d = occupiedQty = occupiedQtyMap == null ? 0.0 : occupiedQtyMap.getOrDefault(salDodCreateParam.getRelateDocDid(), 0.0);
            if (remainQty - occupiedQty < Math.abs(salDodCreateParam.getQty())) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53ef\u9000\u8d27\u6570\u91cf\u4e0d\u8db3\uff0c\u884c\u53f7\uff1a" + lineNo);
            }
            if (isCf && !salDodVO.getQty2().equals(Math.abs(qty))) {
                isCf = false;
                docType = "DB".equals(param.getRelateDocType()) ? "C2" : "CI";
            }
        }
        SalSoDDO salSodDO = new SalSoDDO();
        BeanUtils.copyProperties((Object)salDodCreateParam, (Object)salSodDO);
        salSodDO.setLineNo(lineNo);
        salSodDO.setOuId(ouId);
        salSodDO.setBuId(buId);
        salSodDO.setBdId(bdId);
        salSodDO.setPcId(pcId);
        salSodDO.setWhId(whId);
        salSodDO.setCustId(custId);
        salSodDO.setDeter1(deter1);
        salSodDO.setDeter2(deter2);
        salSodDO.setDeter3(deter3);
        salSodDO.setCurrCode(salSoDO.getCurrCode());
        salSodDO.setItemId(itemId);
        salSodDO.setQty(qty);
        salSodDO.setUom(uom);
        salSodDO.setReturnedQty(null);
        salSodDO.setUomRatio(uomRatio);
        salSodDO.setPackQty(packQty);
        salSodDO.setPackUom(packUom);
        salSodDO.setNetWeight(netWeight);
        salSodDO.setGrossWeight(grossWeight);
        salSodDO.setWeightUom(weightUom);
        salSodDO.setVolume(volume);
        salSodDO.setVolumeUom(volumeUom);
        salSodDO.setBasePrice(basePrice);
        salSodDO.setPriceType(priceType);
        salSodDO.setPrice(price);
        salSodDO.setNetPrice(netPrice);
        salSodDO.setTransPrice(transPrice);
        salSodDO.setTransTaxPrice(transTaxPrice);
        salSodDO.setTaxRateNo(taxRateNo);
        salSodDO.setTaxRate(taxRate);
        salSodDO.setCurrCode(currCode);
        salSodDO.setTaxAmt(taxAmt);
        salSodDO.setAmt(amt);
        salSodDO.setNetAmt(netAmt);
        if (isJcReturn) {
            salSodDO.setRelateDocCls(relateDocCls);
            salSodDO.setRelateDocType(relateDocType);
            salSodDO.setRelateDocId(relateDocId);
            salSodDO.setRelateDocNo(relateDocNo);
            salSodDO.setRelateDocDid(relateDocDid);
            salSodDO.setRelateDocLineno(relateDocLineNo);
        }
        salSodDO.setRemark(remark);
        salSodDO.setReturnedQty(0.0);
        if (StringUtils.isEmpty((Object)salDodCreateParam.getReturnReasonCode())) {
            salSodDO.setReturnReasonCode(param.getReturnReasonCode());
        }
        salSodDO.setReturnMatFlag(param.getReturnMatFlag());
        salSodDoList.add(salSodDO);
        SalSoAllocDO salSoAllocDO = new SalSoAllocDO();
        salSoAllocDO.setLineNo(lineNo);
        salSoAllocDO.setWhId(salSoDO.getWhId());
        salSoAllocDO.setDeter1(salSoDO.getDeter1());
        salSoAllocDO.setDeter2(salSoDO.getDeter2());
        salSoAllocDO.setDeter3(salSoDO.getDeter3());
        salSoAllocDO.setItemId(itemId);
        salSoAllocDO.setLotNo(lotNo);
        salSoAllocDO.setAllocQty(allocQty);
        salSoAllocDO.setShippedQty(shippedQty);
        if (isJcReturn) {
            salSoAllocDO.setRelateDocCls(relateDocCls);
            salSoAllocDO.setRelateDocType(relateDocType);
            salSoAllocDO.setRelateDocId(relateDocId);
            salSoAllocDO.setRelateDocNo(relateDocNo);
            salSoAllocDO.setRelateDocDid(relateDocDid);
            salSoAllocDO.setRelateDocLineno(relateDocLineNo);
        }
        salSoAllocDO.setVariId(variId);
        salSoAllocDO.setRemark(remark);
        salSoAllocDOList.add(salSoAllocDO);
    }

    private void startWorkflow(Long id) {
        Optional salSoDoOptional = this.salSoRepo.findById(id);
        if (salSoDoOptional.isPresent()) {
            Optional user = null;
            this.sysUserService.current();
            if (!user.isPresent()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237");
            }
            Long userId = ((SysUserDTO)user.get()).getId();
            SalSoDO salSoDO = (SalSoDO)salSoDoOptional.get();
            String returnContractFlag = salSoDO.getReturnContractFlag();
            boolean flag = false;
            String flagName = "\u65e0\u9000\u8d27\u5408\u540c";
            if ("1".equals(returnContractFlag)) {
                flag = true;
                flagName = "\u6709\u9000\u8d27\u5408\u540c";
            }
            BigDecimal amt = salSoDO.getAmt() == null ? BigDecimal.valueOf(0L) : salSoDO.getAmt();
            HashMap<String, Comparable<BigDecimal>> variables = new HashMap<String, Comparable<BigDecimal>>(16);
            variables.put("money", amt);
            variables.put("hasReturnContract", Boolean.valueOf(flag));
            if (StringUtils.isEmpty((Object)salSoDO.getApprStatus())) {
                String procInstName = "\u5ba2\u6237\u4ed3\u5e93\u9000\u8d27\u6d41\u7a0b-" + flagName + "(" + amt + ")";
                System.out.println("-----------------\u9500\u552e\u9000\u8d27\u6d41\u7a0b\u542f\u52a8---------");
            }
            salSoDO.setDocStatus(UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
            salSoDO.setApprTime(LocalDateTime.now());
            salSoDO.setApprCreateUserId(userId);
            this.salSoRepo.save(salSoDO);
        }
    }

    private void checkDocStatus(SalRdoSaveVO param, boolean isWhPhysical, boolean isJcReturn, String docType) {
        if (!param.isSubmit()) {
            return;
        }
        if (param.getId() == null) {
            return;
        }
        if (!this.salSoRepo.existsById(param.getId())) {
            return;
        }
        Optional salSoDoOptional = this.salSoRepo.findById(param.getId());
        SalSoDO salSoDO = (SalSoDO)salSoDoOptional.get();
        ArrayList<String> docStatusList = new ArrayList<String>();
        docStatusList.add(UdcEnum.SAL_RSO_STATUS_DR.getValueCode());
        docStatusList.add(UdcEnum.SAL_RSO_STATUS_RJ.getValueCode());
        if (!docStatusList.contains(salSoDO.getDocStatus())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u8349\u7a3f\uff0c\u5df2\u62d2\u7edd\u72b6\u6001\u7684\u624d\u80fd\u63d0\u4ea4\uff01");
        }
        Optional whDO = this.orgWhService.findIdOne(param.getWhId());
        if (whDO.isEmpty()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u4ed3\u5e93\u4e3a\u7a7a");
        }
        String whType = ((InvWhRespVO)whDO.get()).getWhType2();
        if (UdcEnum.INV_WH_TYPE_PHYSICAL.getValueCode().equals(whType) || UdcEnum.INV_WH_TYPE_LOGICAL.getValueCode().equals(whType)) {
            isWhPhysical = true;
        } else if (UdcEnum.INV_WH_TYPE_CONSIGMENT.getValueCode().equals(whType)) {
            isWhPhysical = false;
        } else {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u4ed3\u5e93\u7c7b\u578b\u53ea\u652f\u6301\u7269\u7406\u4ed3\u3001\u5bc4\u552e\u4ed3\u548c\u865a\u62df\u4ed3");
        }
        isJcReturn = SalEnum.SAL_SE17.getCode().equals(param.getSoScene());
        docType = isJcReturn ? ("DB".equals(param.getRelateDocType()) ? "C1" : "CF") : "CO";
        if (param.isSubmit() && org.springframework.util.CollectionUtils.isEmpty((Collection)param.getSalRdodSaleList())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u9000\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
    }

    private void insertSalRdo(Long id, SalSoDO salSoDO, List<SalSoDDO> salSodDoS, List<SalSoAllocDO> salSoAllocDoS, boolean isCallBack) {
        boolean needUpdateQty = false;
        if (salSoDO == null || org.springframework.util.CollectionUtils.isEmpty(salSodDoS) || org.springframework.util.CollectionUtils.isEmpty(salSoAllocDoS)) {
            salSoDO = this.salSoRepoProc.findSalSoDoById(id);
            salSodDoS = this.salSoDRepoProc.findSalSodDosByMasId(id);
            salSoAllocDoS = this.salSoAllocRepo.findByMasIdIn(List.of(id));
        }
        Map<Long, SalSoAllocDO> salSoAllocDoMap = salSoAllocDoS.stream().collect(Collectors.toMap(SalSoAllocDO::getSoDId, t -> t));
        SalDoDO salDoDO = new SalDoDO();
        ArrayList<SalDoDDO> salDodDoList = new ArrayList<SalDoDDO>();
        BeanCopyUtil.beanCopy(salSoDO, salDoDO);
        this.createSalRdod(salDoDO, salSoDO, needUpdateQty, isCallBack);
        for (SalSoDDO salSodDO : salSodDoS) {
            this.createSalRdod(salSodDO, salDodDoList, salSoDO, salSoAllocDoMap);
        }
        this.salDoRepo.save(salDoDO);
        salDodDoList.forEach(o -> o.setMasId(salDoDO.getId()));
        this.salDodRepo.saveAll(salDodDoList).stream().map(BaseModel::getId).collect(Collectors.toList());
        if (needUpdateQty) {
            // empty if block
        }
    }

    void createSalRdod(SalDoDO salDoDO, SalSoDO salSoDO, boolean needUpdateQty, boolean isCallBack) {
        salDoDO.setId(null);
        ArrayList<String> runtimeValues = new ArrayList<String>();
        runtimeValues.add(salSoDO.getOuId().toString().substring(salSoDO.getOuId().toString().length() - 3));
        salDoDO.setDocNo("R" + this.sysNumberRuleService.generateCode(salSoDO.getDocType(), runtimeValues));
        salDoDO.setDocCls(UdcEnum.COM_DOC_CLS_RDO.getValueCode());
        salDoDO.setDocType(salSoDO.getDocType());
        salDoDO.setRelateDocCls(salSoDO.getDocCls());
        salDoDO.setRelateDocType(salSoDO.getDocType());
        salDoDO.setRelateDocId(salSoDO.getId());
        salDoDO.setRelateDocNo(salSoDO.getDocNo());
        String soDocStatus = salSoDO.getDocStatus();
        if (UdcEnum.SAL_RSO_STATUS_WR.getValueCode().equals(soDocStatus)) {
            salDoDO.setDocStatus(UdcEnum.SAL_RDO_STATUS_WR.getValueCode());
        } else if (UdcEnum.SAL_RSO_STATUS_WF.getValueCode().equals(salSoDO.getDocStatus()) || SalEnum.SAL_CO.getCode().equals(salSoDO.getDocType()) && isCallBack) {
            salDoDO.setDocStatus(UdcEnum.SAL_RDO_STATUS_WF.getValueCode());
        } else if (UdcEnum.SAL_RSO_STATUS_DONE.getValueCode().equals(soDocStatus)) {
            salDoDO.setDocStatus(UdcEnum.SAL_RDO_STATUS_DONE.getValueCode());
            needUpdateQty = true;
        }
        salDoDO.setCreateTime(null);
        salDoDO.setCreateUserId(salSoDO.getCreateUserId());
        salDoDO.setModifyTime(null);
        salDoDO.setModifyUserId(salSoDO.getModifyUserId());
        salDoDO.setDocDate(salSoDO.getDocTime());
        salDoDO.setDocTime(null);
    }

    void createSalRdod(SalSoDDO salSodDO, List<SalDoDDO> salDodDoList, SalSoDO salSoDO, Map<Long, SalSoAllocDO> salSoAllocDoMap) {
        SalDoDDO salDodDO = new SalDoDDO();
        BeanUtils.copyProperties((Object)salSodDO, (Object)salDodDO);
        salDodDO.setId(null);
        salDodDO.setLineNo(salSodDO.getLineNo());
        salDodDO.setLineType(salSodDO.getLineType());
        salDodDO.setOuId(salSodDO.getOuId());
        salDodDO.setBuId(salSodDO.getBuId());
        salDodDO.setBdId(salSodDO.getBdId());
        salDodDO.setPcId(salSodDO.getPcId());
        salDodDO.setSoAllocId(salSoAllocDoMap.get(salSodDO.getId()).getId());
        salDodDO.setCustId(salSodDO.getCustId());
        salDodDO.setWhId(salSodDO.getWhId());
        salDodDO.setDeter1(salSodDO.getDeter1());
        salDodDO.setDeter2(salSodDO.getDeter2());
        salDodDO.setDeter3(salSodDO.getDeter3());
        salDodDO.setItemId(salSodDO.getItemId());
        salDodDO.setQty(salSodDO.getQty());
        salDodDO.setUom(salSodDO.getUom());
        if (SalEnum.SAL_SE17.getCode().equals(salSoDO.getSoScene())) {
            salDodDO.setQty2(salSodDO.getQty());
        } else {
            salDodDO.setQty2(null);
        }
        salDodDO.setReturnedQty(null);
        salDodDO.setUomRatio(salSodDO.getUomRatio());
        salDodDO.setPackQty(salSodDO.getPackQty());
        salDodDO.setPackUom(salSodDO.getPackUom());
        salDodDO.setNetWeight(salSodDO.getNetWeight());
        salDodDO.setGrossWeight(salSodDO.getGrossWeight());
        salDodDO.setWeightUom(salSodDO.getWeightUom());
        salDodDO.setVolume(salSodDO.getVolume());
        salDodDO.setVolumeUom(salSodDO.getVolumeUom());
        salDodDO.setBasePrice(salSodDO.getBasePrice());
        salDodDO.setPriceType(salSodDO.getPriceType());
        salDodDO.setPrice(salSodDO.getNetPrice().multiply(new BigDecimal(1.0 + salSodDO.getTaxRate())));
        salDodDO.setNetPrice(salSodDO.getNetPrice());
        salDodDO.setTransPrice(salSodDO.getTransPrice() == null ? salSodDO.getNetPrice() : salSodDO.getTransPrice());
        salDodDO.setTaxRateNo(salSodDO.getTaxRateNo());
        salDodDO.setTaxRate(salSodDO.getTaxRate());
        salDodDO.setCurrCode(salSodDO.getCurrCode());
        salDodDO.setTaxAmt(salSodDO.getTaxAmt());
        salDodDO.setAmt(salSodDO.getAmt());
        salDodDO.setNetAmt(salSodDO.getNetAmt());
        salDodDO.setRelateDocCls(salSoDO.getDocCls());
        salDodDO.setRelateDocType(salSoDO.getDocType());
        salDodDO.setRelateDocNo(salSoDO.getDocNo());
        salDodDO.setRelateDocId(salSoDO.getId());
        salDodDO.setRelateDocDid(salSodDO.getId());
        salDodDO.setRelateDocLineno(salSodDO.getLineNo());
        salDodDO.setRemark(salSodDO.getRemark());
        salDodDO.setReturnedQty(0.0);
        salDodDO.setVariId(salSoAllocDoMap.get(salSodDO.getId()).getVariId());
        salDodDO.setLotNo(salSodDO.getLotNo());
        salDodDO.setReturnReasonCode(salSodDO.getReturnReasonCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void salSoUpdate(SalSoDO item) {
        Optional optional = this.salSoRepo.findById(item.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + item.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(item, (SalSoDO)optional.get(), BeanCopyUtil.getNullPropertyNames(item));
        this.salSoRepo.save((SalSoDO)optional.get());
    }

    public SalSoReturnServiceImpl(SalSoRepoProc salSoRepoProc, SalSoService salSoService, SalSoAllocRepo salSoAllocRepo, SalSoRepo salSoRepo, SalSoRepoProc salSodRepoProc, SalDoRepo salDoRepo, SalSoDRepo salSoDRepo, SalDoRepoProc salDoRepoProc, SalDoDRepo salDodRepo, SalDoDRepoProc salDodRepoProc, SalSoDService salSoDService, SalSoDRepoProc salSoDRepoProc, SysUserService sysUserService, OrgOuService orgOuService, InvWhService invWhService, OrgBuService orgBuService, SalSoAllocService salSoAllocService, SalDoDService salDoDService, SalDoService salDoService, SysUdcService sysUdcService, InvWhService orgWhService, InvLotService invLotService, InvWhAreaService orgWhAreaService, SysNumberRuleService sysNumberRuleService) {
        this.salSoRepoProc = salSoRepoProc;
        this.salSoService = salSoService;
        this.salSoAllocRepo = salSoAllocRepo;
        this.salSoRepo = salSoRepo;
        this.salSodRepoProc = salSodRepoProc;
        this.salDoRepo = salDoRepo;
        this.salSoDRepo = salSoDRepo;
        this.salDoRepoProc = salDoRepoProc;
        this.salDodRepo = salDodRepo;
        this.salDodRepoProc = salDodRepoProc;
        this.salSoDService = salSoDService;
        this.salSoDRepoProc = salSoDRepoProc;
        this.sysUserService = sysUserService;
        this.orgOuService = orgOuService;
        this.invWhService = invWhService;
        this.orgBuService = orgBuService;
        this.salSoAllocService = salSoAllocService;
        this.salDoDService = salDoDService;
        this.salDoService = salDoService;
        this.sysUdcService = sysUdcService;
        this.orgWhService = orgWhService;
        this.invLotService = invLotService;
        this.orgWhAreaService = orgWhAreaService;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

