/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sal.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.elitesland.core.base.ApiCode;
import com.elitesland.core.base.PagingVO;
import com.elitesland.core.base.param.AbstractOrderQueryParam;
import com.elitesland.core.exception.BusinessException;
import com.elitesland.extension.UdcEnum;
import com.elitesland.inv.dto.ComDistrictComboVO;
import com.elitesland.inv.service.InvWhService;
import com.elitesland.inv.vo.BaseModelVO;
import com.elitesland.org.vo.OrgBuVO;
import com.elitesland.sal.convert.SalSoCovert;
import com.elitesland.sal.entity.QSalSoDO;
import com.elitesland.sal.entity.SalSoDO;
import com.elitesland.sal.entity.importentity.SalSoExVO;
import com.elitesland.sal.param.SalSoQueryParamVO;
import com.elitesland.sal.repo.SalSoRepo;
import com.elitesland.sal.repo.SalSoRepoProc;
import com.elitesland.sal.service.SalDoDService;
import com.elitesland.sal.service.SalSoAllocService;
import com.elitesland.sal.service.SalSoDService;
import com.elitesland.sal.service.SalSoService;
import com.elitesland.sal.vo.resp.SalDoDRespVO;
import com.elitesland.sal.vo.resp.SalDoRespVO;
import com.elitesland.sal.vo.resp.SalSoAllocRespVO;
import com.elitesland.sal.vo.resp.SalSoRespVO;
import com.elitesland.system.annotation.SysCodeProc;
import com.elitesland.util.BeanCopyUtil;
import com.elitesland.util.ExcelWriteUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="salSoService")
public class SalSoServiceImpl
implements SalSoService {
    private static final Logger log = LoggerFactory.getLogger(SalSoServiceImpl.class);
    private final SalSoRepo salSoRepo;
    private final SalSoRepoProc salSoRepoProc;
    private final SalSoAllocService salSoAllocService;
    private final SalSoDService salSoDService;
    private final SalDoDService salDoDService;
    private final InvWhService invWhService;

    @SysCodeProc
    public List<SalSoAllocRespVO> filterSalSo(SalSoQueryParamVO param) {
        List collect;
        List<Long> masId = null;
        if (param.getCustName() != null) {
            ArrayList orgCustvos = new ArrayList();
            collect = orgCustvos.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                param.setCustIdlist(collect);
            } else {
                return null;
            }
        }
        if (!StringUtils.isEmpty((Object)param.getOuId())) {
            ArrayList allLike = new ArrayList();
            collect = allLike.stream().map(OrgBuVO::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                return null;
            }
            param.setBuIds(collect);
        }
        ArrayList longs = new ArrayList();
        List whId = null;
        if (!StringUtils.isEmpty((Object)param.getPhysicalWhCode())) {
            whId = this.invWhService.findIdByPhyCode(param.getPhysicalWhCode()).stream().distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(whId)) {
                longs.addAll(whId);
                param.setWhIdByPhyCodeList(longs);
            } else {
                return null;
            }
        }
        if (!StringUtils.isEmpty((Object)param.getItemName())) {
            try {
                masId = this.salSoDService.findMasIdByLike(param.getItemName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            param.setMasIds(masId);
            if (!CollectionUtils.isEmpty(masId)) {
                return null;
            }
        }
        if (!StringUtils.isEmpty((Object)param.getLotNo())) {
            try {
                masId = this.salSoAllocService.findMasIdByLotNo(param.getLotNo());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            param.setMasIds(masId);
            if (!CollectionUtils.isEmpty(masId)) {
                return null;
            }
        }
        QSalSoDO salSo = QSalSoDO.salSoDO;
        BooleanExpression predicate = salSo.isNotNull();
        List lists = new ArrayList();
        try {
            JPAQuery jpaQuery = (JPAQuery)this.salSoRepoProc.select(null).where(this.salSoRepoProc.whereHandover(param));
            lists = jpaQuery.fetch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Long> collect2 = lists.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<Object> salSoAllocvos = new ArrayList();
        try {
            salSoAllocvos = this.salSoAllocService.findbySalsods(collect2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Object> salDodRespVoList = new ArrayList();
        try {
            salDodRespVoList = this.salDoDService.findByRelateDocIds(collect2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<Long, Double> salsoallocmap = salDodRespVoList.stream().collect(Collectors.groupingBy(SalDoDRespVO::getSoAllocId, Collectors.summingDouble(v -> v.getQty())));
        salDodRespVoList.stream().forEach(v -> v.setQty((Double)salsoallocmap.get(v.getSoAllocId())));
        List<Object> finalSalDodRespVoList = salDodRespVoList;
        salSoAllocvos.stream().forEach(v -> {
            if (v.getId() != null) {
                Optional<SalDoDRespVO> first = finalSalDodRespVoList.stream().filter(e -> v.getId().equals(e.getSoAllocId())).findFirst();
                v.setQty3(Double.valueOf(first.isPresent() ? first.get().getQty() : 0.0));
            }
            v.setAllocQty(Double.valueOf(v.getAllocQty() != null ? v.getAllocQty() : 0.0));
            v.setShippedQty(Double.valueOf(v.getShippedQty() != null ? v.getShippedQty() : 0.0));
            v.setQty3(Double.valueOf(v.getQty3() != null ? v.getQty3() : 0.0));
            v.setQty4(Double.valueOf(v.getAllocQty() - v.getShippedQty() - v.getQty3()));
        });
        List<SalSoAllocRespVO> salSoAllocVOList = salSoAllocvos.stream().filter(t -> t.getQty4() > 0.0).collect(Collectors.toList());
        return salSoAllocVOList;
    }

    @Override
    @SysCodeProc
    public SalDoRespVO createSalDo(Long id) {
        Optional<SalSoRespVO> salSoRespVO = this.salSoRepo.findById(id).map(SalSoCovert.INSTANCE::doToRespVO);
        if (salSoRespVO.isPresent()) {
            return this.createSalDoRespVO(salSoRespVO.get());
        }
        return null;
    }

    @Override
    @SysCodeProc
    public Long findrelateDocIdById(Long docid) {
        return this.salSoRepo.findrelateDocIdById(docid);
    }

    @Override
    @SysCodeProc
    public Optional<SalSoRespVO> findById(Long docid) {
        Optional salSoDO = this.salSoRepo.findById(docid);
        SalSoRespVO salSoVO = new SalSoRespVO();
        if (salSoDO != null && salSoDO.isPresent()) {
            BeanCopyUtil.beanCopy((Serializable)salSoDO.get(), salSoVO);
        }
        return Optional.ofNullable(salSoVO);
    }

    @Override
    public void updateReturnReasonCodeById(String returnReasonCode, Long id) {
    }

    public List<SalSoExVO> exportWaitHandoverOrderw(List<SalSoRespVO> salSoVoS) throws ExecutionException, InterruptedException {
        ArrayList<SalSoExVO> salSoExVoS = new ArrayList<SalSoExVO>();
        if (salSoVoS.size() > 0) {
            salSoVoS.stream().forEach(salSoVO -> {
                List salSodDetailVoList = salSoVO.getSalSodRespVOList();
                if (salSodDetailVoList.size() > 0) {
                    salSodDetailVoList.stream().forEach(salSodDetailVo -> {
                        SalSoExVO salSoExVo = new SalSoExVO();
                        BeanCopyUtil.beanCopy(salSoVO, salSoExVo);
                        BeanCopyUtil.beanCopy(salSodDetailVo, salSoExVo);
                        salSoExVo.setWhAbbr1(salSoVO.getPhysicalWhCode());
                        salSoExVo.setTaxAmt1(salSodDetailVo.getTaxAmt());
                        salSoExVo.setEmpName1(salSodDetailVo.getEmpName());
                        salSoExVoS.add(salSoExVo);
                    });
                } else {
                    SalSoExVO salSoExVo = new SalSoExVO();
                    BeanCopyUtil.beanCopy(salSoVO, salSoExVo);
                    salSoExVoS.add(salSoExVo);
                }
            });
        }
        return salSoExVoS;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalSoRespVO> waitHandoverOrder(SalSoQueryParamVO param) throws ExecutionException, InterruptedException {
        param.setAllowPartalDeliver(Boolean.TRUE);
        param.setDocStatus(UdcEnum.SAL_SO_STATUS_CF.getValueCode());
        param.setDocCls(UdcEnum.COM_DOC_CLS_SO.getValueCode());
        try {
            if (!StringUtils.isEmpty((Object)param.getOuIdString())) {
                param.setOuId(Long.valueOf(Long.parseLong(param.getOuIdString())));
            }
        }
        catch (Exception e) {
            PagingVO pagingVO = new PagingVO();
            return pagingVO;
        }
        try {
            if (!StringUtils.isEmpty((Object)param.getCustIdString())) {
                param.setCustId(Long.valueOf(Long.parseLong(param.getCustIdString())));
            }
        }
        catch (Exception e) {
            PagingVO pagingVO = new PagingVO();
            return pagingVO;
        }
        PagingVO<SalSoRespVO> salSoVoPagingVO = this.waitHandoverOrders(param);
        if (salSoVoPagingVO == null) {
            PagingVO pagingVO = new PagingVO();
            return pagingVO;
        }
        Long dataCount = salSoVoPagingVO.getTotal();
        List records = salSoVoPagingVO.getRecords();
        List collect1 = records.stream().map(BaseModelVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Object> salSodDetailVoS = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)param.getSaldoids())) {
            try {
                salSodDetailVoS = this.salSoDService.findAllById(param.getSaldoids());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList finalSalSodDetailVoS = salSodDetailVoS;
        records.stream().forEach(v -> {
            if (!CollectionUtils.isEmpty((Collection)finalSalSodDetailVoS)) {
                List salSodRespVoS = finalSalSodDetailVoS.stream().filter(s -> v.getId().equals(s.getMasId())).collect(Collectors.toList());
                v.setSalSodRespVOList(salSodRespVoS);
            }
        });
        PagingVO paging = new PagingVO();
        paging.setRecords(records);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    public void exportWaitHandoverOrder(HttpServletResponse response, SalSoQueryParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(Integer.valueOf(Integer.MAX_VALUE));
        param.setAllowPartalDeliver(Boolean.TRUE);
        param.setDocStatus(UdcEnum.SAL_SO_STATUS_CF.getValueCode());
        param.setDocCls(UdcEnum.COM_DOC_CLS_SO.getValueCode());
        SalSoQueryParamVO salSoWaitHandoverQueryParam = new SalSoQueryParamVO();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)param.getIds())) {
            salSoWaitHandoverQueryParam.setIds(param.getIds());
            salSoWaitHandoverQueryParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            salSoWaitHandoverQueryParam.setAllowPartalDeliver(Boolean.TRUE);
            salSoWaitHandoverQueryParam.setDocStatus(UdcEnum.SAL_SO_STATUS_CF.getValueCode());
            salSoWaitHandoverQueryParam.setDocCls(UdcEnum.COM_DOC_CLS_SO.getValueCode());
        } else {
            salSoWaitHandoverQueryParam = param;
        }
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.desc((String)"createTime"));
        salSoWaitHandoverQueryParam.setOrders(orders);
        List salSoVoS = this.waitHandoverOrder(salSoWaitHandoverQueryParam).getRecords();
        List<SalSoExVO> salSoExVoS = this.exportWaitHandoverOrderw(salSoVoS);
        ExcelWriteUtil.excelWrite1(response, salSoExVoS, SalSoExVO.class, "\u5f85\u53d1\u8d27\u8ba2\u5355\u67e5\u8be2", "\u5f85\u53d1\u8d27\u8ba2\u5355\u67e5\u8be2");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDocAndLogisStatusById(Long id, String docStatus, String logisStatus) {
        this.salSoRepoProc.updateDocAndLogisStatusById(id, docStatus, logisStatus);
    }

    @SysCodeProc
    public PagingVO<SalSoRespVO> waitHandoverOrders(SalSoQueryParamVO param) {
        List<SalSoAllocRespVO> salSoAllocVoS = this.filterSalSo(param);
        if (CollectionUtils.isEmpty(salSoAllocVoS)) {
            PagingVO pagingVO = new PagingVO();
            return pagingVO;
        }
        Set idss = salSoAllocVoS.stream().map(SalSoAllocRespVO::getMasId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set soDid = salSoAllocVoS.stream().map(SalSoAllocRespVO::getSoDId).filter(Objects::nonNull).collect(Collectors.toSet());
        param.setSaldoids(new ArrayList(soDid));
        QSalSoDO salSo = QSalSoDO.salSoDO;
        BooleanExpression predicate = salSo.isNotNull();
        SalSoQueryParamVO salSos = new SalSoQueryParamVO();
        JPAQuery jpaQuery = (JPAQuery)this.salSoRepoProc.selctStaySalSo(salSos).where((Predicate)salSo.id.in(new ArrayList(idss)));
        long dataCount = jpaQuery.fetchCount();
        this.salSoRepoProc.openOrderAndLimit(jpaQuery, (AbstractOrderQueryParam)param, QSalSoDO.salSoDO);
        List lists = jpaQuery.fetch();
        this.trans(lists);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(Long.valueOf(dataCount));
        return paging;
    }

    private void trans(List<SalSoRespVO> lists) {
        List custids = lists.stream().map(SalSoRespVO::getCustId).filter(Objects::nonNull).collect(Collectors.toList());
        List whids = lists.stream().map(SalSoRespVO::getWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List createUserIds = lists.stream().map(BaseModelVO::getModifyUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List salegroups = lists.stream().map(SalSoRespVO::getSaleGroup).filter(Objects::nonNull).collect(Collectors.toList());
        List soScenes = lists.stream().map(SalSoRespVO::getSoScene).filter(Objects::nonNull).collect(Collectors.toList());
        List buids = lists.stream().map(SalSoRespVO::getBuId).filter(Objects::nonNull).collect(Collectors.toList());
        List currCodes = lists.stream().map(SalSoRespVO::getCurrCode).filter(Objects::nonNull).collect(Collectors.toList());
        List ouids = lists.stream().map(SalSoRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList());
        List collect15 = lists.stream().map(SalSoRespVO::getRecvCountry).filter(Objects::nonNull).collect(Collectors.toList());
        List collect16 = lists.stream().map(SalSoRespVO::getRecvProvince).filter(Objects::nonNull).collect(Collectors.toList());
        List collect17 = lists.stream().map(SalSoRespVO::getRecvCounty).filter(Objects::nonNull).collect(Collectors.toList());
        List collect18 = lists.stream().map(SalSoRespVO::getRecvCity).filter(Objects::nonNull).collect(Collectors.toList());
        collect15.removeAll(collect16);
        collect15.removeAll(collect17);
        collect15.removeAll(collect18);
        collect15.addAll(collect16);
        collect15.addAll(collect17);
        collect15.addAll(collect18);
        ArrayList byDistCodes = new ArrayList();
        if (!CollectionUtils.isEmpty(collect15)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(ouids)) {
            ArrayList arrayList = new ArrayList();
        }
        ArrayList comCurrVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(currCodes)) {
            // empty if block
        }
        ArrayList orgCustVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(custids)) {
            // empty if block
        }
        List orgWhVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(whids)) {
            try {
                orgWhVoS = this.invWhService.findIdBatch(whids);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(soScenes)) {
            // empty if block
        }
        ArrayList sysUserDoS = new ArrayList();
        if (!CollectionUtils.isEmpty(createUserIds)) {
            // empty if block
        }
        ArrayList orgBuVos = new ArrayList();
        if (!CollectionUtils.isEmpty(buids)) {
            // empty if block
        }
        List finalOrgWhVoS = orgWhVoS;
        Map<Object, Object> distMap = new HashMap(16);
        if (!org.springframework.util.CollectionUtils.isEmpty(byDistCodes)) {
            distMap = byDistCodes.stream().collect(Collectors.toMap(ComDistrictComboVO::getCode, ComDistrictComboVO::getName, (o1, o2) -> o2));
        }
        HashMap finalDistMap = distMap;
        lists.stream().forEachOrdered(v -> {
            Optional<OrgBuVO> first;
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)byDistCodes)) {
                if (finalDistMap.containsKey(v.getRecvCountry())) {
                    v.setRecvCountryName((String)finalDistMap.get(v.getRecvCountry()));
                }
                if (finalDistMap.containsKey(v.getRecvProvince())) {
                    v.setRecvProvinceName((String)finalDistMap.get(v.getRecvProvince()));
                }
                if (finalDistMap.containsKey(v.getRecvCounty())) {
                    v.setRecvCountyName((String)finalDistMap.get(v.getRecvCounty()));
                }
                if (finalDistMap.containsKey(v.getRecvCity())) {
                    v.setRecvCityName((String)finalDistMap.get(v.getRecvCity()));
                }
            }
            v.setRecvCountryName(!StringUtils.isEmpty((Object)v.getRecvCountryName()) ? v.getRecvCountryName() : "");
            v.setRecvProvinceName(!StringUtils.isEmpty((Object)v.getRecvProvinceName()) ? v.getRecvProvinceName() : "");
            v.setRecvCityName(!StringUtils.isEmpty((Object)v.getRecvCityName()) ? v.getRecvCityName() : "");
            v.setRecvDetailaddr(!StringUtils.isEmpty((Object)v.getRecvDetailaddr()) ? v.getRecvDetailaddr() : "");
            v.setRecvSite(v.getRecvCountryName() + v.getRecvProvinceName() + v.getRecvCityName() + v.getRecvDetailaddr());
            if (v.getCurrCode() != null) {
                // empty if block
            }
            if (v.getBuId() == null || (first = orgBuVos.stream().filter(t -> v.getBuId().equals(t.getId())).findFirst()).isPresent()) {
                // empty if block
            }
            if (v.getOuId() != null) {
                // empty if block
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    SalDoRespVO createSalDoRespVO(SalSoRespVO salSoRespVO) {
        SalDoRespVO vo = new SalDoRespVO();
        vo.setBuId(salSoRespVO.getBuId());
        vo.setBdId(salSoRespVO.getBdId());
        vo.setPcId(salSoRespVO.getPcId());
        vo.setWhId(salSoRespVO.getWhId());
        vo.setOuId(salSoRespVO.getOuId());
        vo.setDeter1(salSoRespVO.getDeter1());
        vo.setDeter2(salSoRespVO.getDeter2());
        vo.setDeter3(salSoRespVO.getDeter3());
        vo.setCrosswhFlag(salSoRespVO.getCrosswhFlag());
        vo.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
        vo.setCustSoDate(salSoRespVO.getCustSoDate());
        vo.setAgentEmpId(salSoRespVO.getAgentEmpId());
        vo.setSaleGroup(salSoRespVO.getSaleGroup());
        vo.setAllowPartalDeliver(salSoRespVO.getAllowPartalDeliver());
        vo.setDocType(salSoRespVO.getDocType());
        vo.setTaxRateNo(salSoRespVO.getTaxRateNo());
        vo.setDemandDate(salSoRespVO.getDemandDate());
        vo.setDocStatus(UdcEnum.SAL_DO_STATUS_DR.getValueCode());
        vo.setLogisStatus(UdcEnum.SAL_LOGIS_STATUS_NONDS.getValueCode());
        vo.setSoScene(salSoRespVO.getSoScene());
        vo.setDeliverStoreType(salSoRespVO.getDeliverStoreType());
        vo.setRecvContactName(salSoRespVO.getRecvContactName());
        vo.setRecvContactTel(salSoRespVO.getRecvContactTel());
        vo.setCustId(salSoRespVO.getCustId());
        vo.setCustSoNo(salSoRespVO.getCustSoNo());
        vo.setCustName(salSoRespVO.getCustName());
        vo.setCarrier(salSoRespVO.getCarrier());
        vo.setRecvContactName(salSoRespVO.getRecvContactName());
        vo.setRecvContactTel(salSoRespVO.getRecvContactTel());
        vo.setRecvCountry(salSoRespVO.getRecvCountry());
        vo.setRecvProvince(salSoRespVO.getRecvProvince());
        vo.setRecvCity(salSoRespVO.getRecvCity());
        vo.setRecvCountry(salSoRespVO.getRecvCountry());
        vo.setRecvStreet(salSoRespVO.getRecvStreet());
        vo.setRecvDetailaddr(salSoRespVO.getRecvDetailaddr());
        vo.setHomeCurr(salSoRespVO.getHomeCurr());
        vo.setCurrCode(salSoRespVO.getCurrCode());
        vo.setCurrRate(salSoRespVO.getCurrRate());
        vo.setRelateDocType(salSoRespVO.getDocType());
        vo.setDeliverMethod(salSoRespVO.getDeliverMethod());
        if (salSoRespVO != null && salSoRespVO.getTaxInclFlag() != null) {
            vo.setTaxInclFlag(Integer.valueOf(salSoRespVO.getTaxInclFlag() != false ? 1 : 0));
        }
        if (salSoRespVO != null && salSoRespVO.getIntfFlag() != null) {
            vo.setIntfFlag(Boolean.valueOf(salSoRespVO.getIntfFlag() != false));
        }
        vo.setRecvDeter1(salSoRespVO.getRecvDeter1());
        vo.setRecvDeter2(salSoRespVO.getRecvDeter2());
        vo.setRecvDeter3(salSoRespVO.getRecvDeter3());
        vo.setTaxCode(salSoRespVO.getTaxCode());
        vo.setRecvAddrNo(salSoRespVO.getRecvAddrNo());
        vo.setVolume(salSoRespVO.getVolume());
        vo.setGrossWeight(salSoRespVO.getGrossWeight());
        vo.setRelateDocNo(salSoRespVO.getDocNo());
        vo.setTransType(salSoRespVO.getTransType());
        vo.setTransportTemp(salSoRespVO.getTransportTemp());
        vo.setRelateDocCls(salSoRespVO.getRelateDocCls());
        vo.setRelateDocId(salSoRespVO.getRelateDocId());
        vo.setPackDemand(salSoRespVO.getPackDemand());
        vo.setDeliverInstruct(salSoRespVO.getDeliverInstruct());
        vo.setDeliverInstruc2(salSoRespVO.getDeliverInstruc2());
        vo.setRelateDocId(salSoRespVO.getId());
        vo.setDeliverMethod(salSoRespVO.getDeliverMethod());
        vo.setRecvWhId(salSoRespVO.getRecvWhId());
        vo.setRelateDocCls(UdcEnum.COM_DOC_CLS_SO.getValueCode());
        vo.setSalsoid(salSoRespVO.getId());
        return vo;
    }

    @Override
    @SysCodeProc
    public PagingVO<SalSoRespVO> search(SalSoQueryParamVO param) {
        Page ret = this.salSoRepo.findAll(this.salSoRepoProc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().map(SalSoCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(collect).build();
    }

    @Override
    @SysCodeProc
    public Optional<SalSoRespVO> findIdOne(Long id) {
        return this.salSoRepo.findById(id).map(SalSoCovert.INSTANCE::doToRespVO);
    }

    @Override
    public List<SalSoRespVO> findIdBatch(List<Long> idList) {
        return this.salSoRepo.findAllById(idList).stream().map(SalSoCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.salSoRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.salSoRepo.deleteById(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QSalSoDO salSo = QSalSoDO.salSoDO;
        BooleanExpression predicate = salSo.isNotNull();
        Optional optionalItem = this.salSoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SalSoDO do1 = (SalSoDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.salSoRepo.save(do1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        ids.forEach(id -> {
            QSalSoDO salSo = QSalSoDO.salSoDO;
            BooleanExpression predicate = salSo.isNotNull();
            Optional optionalItem = this.salSoRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)salSo.id.eq(id))));
            if (!optionalItem.isPresent()) {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
            }
            SalSoDO do1 = (SalSoDO)optionalItem.get();
            do1.setDeleteFlag(1);
            this.salSoRepo.save(do1);
        });
    }

    public SalSoServiceImpl(SalSoRepo salSoRepo, SalSoRepoProc salSoRepoProc, SalSoAllocService salSoAllocService, SalSoDService salSoDService, SalDoDService salDoDService, InvWhService invWhService) {
        this.salSoRepo = salSoRepo;
        this.salSoRepoProc = salSoRepoProc;
        this.salSoAllocService = salSoAllocService;
        this.salSoDService = salSoDService;
        this.salDoDService = salDoDService;
        this.invWhService = invWhService;
    }
}

