/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class ValidationUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtil.class);
    public static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> ValidResult validate(T obj) {
        Set validates = validator.validate(obj, new Class[]{Default.class});
        if (!CollectionUtils.isEmpty((Collection)validates)) {
            HashMap<String, String> errorMsgs = new HashMap<String, String>(validates.size());
            validates.forEach(cv -> errorMsgs.put(cv.getPropertyPath().toString(), cv.getMessage()));
            return new ValidResult(Boolean.TRUE, errorMsgs);
        }
        return ValidResult.noError();
    }

    public static <T> void validate(T obj, Consumer<ValidResult> consumer) {
        ValidResult validate = ValidationUtil.validate(obj);
        if (null != consumer) {
            consumer.accept(validate);
        }
    }

    public static <T> ValidResult validateProperty(T obj, String ... properties) {
        HashMap<String, String> errorMsgs = new HashMap<String, String>();
        if (null != properties) {
            Arrays.asList(properties).forEach(propertyName -> {
                Set validates = validator.validateProperty(obj, propertyName, new Class[]{Default.class});
                if (!CollectionUtils.isEmpty((Collection)validates)) {
                    validates.forEach(cv -> errorMsgs.put(cv.getPropertyPath().toString(), cv.getMessage()));
                }
            });
        }
        if (errorMsgs.size() != 0) {
            return new ValidResult(Boolean.TRUE, errorMsgs);
        }
        return ValidResult.noError();
    }

    public static class ValidResult {
        private boolean error;
        private Map<String, String> errorMsgs;

        ValidResult(boolean error, Map<String, String> errorMsgs) {
            this.error = error;
            this.errorMsgs = errorMsgs;
        }

        static ValidResult noError() {
            return new ValidResult(Boolean.FALSE, null);
        }

        public boolean isError() {
            return this.error;
        }

        public Map<String, String> getErrorMsgs() {
            return this.errorMsgs;
        }
    }
}

