package com.elitesland.inv.service;


import com.elitesland.inv.OpenApiApplication;
import com.elitesland.inv.dto.InvStkOpenRpcDTO;
import com.elitesland.inv.param.InvStkOpenRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * @author jeesie.jiang
 * @date 2023/08/03
 * <p>
 *  库存对外查询接口
 * </p>
 */
@Validated
@FeignClient(name = OpenApiApplication.NAME,path = OpenApiApplication.PATH + InvStkOpenRpcService.PATH)
public interface InvStkOpenRpcService {

    String PATH = "/invStk";

    /**
     * 查询在库商品库存可用量
     * @param param
     * @return
     */
    @PostMapping("/findInvStkByParam")
    List<InvStkOpenRpcDTO> findInvStkByParam(@RequestBody InvStkOpenRpcParam param);


}
