package com.elitesland.inv.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 在库商品查询
 * </p>
 *
 * @author jeesie.jiang
 * @date 2023/8/03
 */
@Data
@ApiModel(value = "invItmStkOpenRpcDTO", description = "在库商品库存查询")
public class InvStkOpenRpcDTO implements Serializable {

    private static final long serialVersionUID = 2123440351245698105L;

    @ApiModelProperty("库存ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("批次号")
    private String lotNo;


    @ApiModelProperty("图稿编号")
    private String draftNo;
    @ApiModelProperty("生产日期")
    private LocalDateTime produceDate;
    @ApiModelProperty("有效期至")
    private LocalDateTime expiredDate;
    @ApiModelProperty("产品批号")
    private String productNo;
    @ApiModelProperty("是否赠品")
    private Boolean giftFlag;
    @ApiModelProperty("订货单位")
    private String orderUom;
    @ApiModelProperty("订货数量")
    private BigDecimal orderNum;
    @ApiModelProperty("发货数量")
    private BigDecimal shipNum;
    @ApiModelProperty("应检数量")
    private BigDecimal inspectNum;
    @ApiModelProperty("采购价格")
    private BigDecimal purchasePrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;
    @ApiModelProperty("合同号")
    private String contractNo;
    @ApiModelProperty("项目编号")
    private String projNo;
    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("通用名称")
    private String generalName;
    @ApiModelProperty("商品名")
    private String productName;
    @ApiModelProperty("英文名称")
    private String englishName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("浓度规格")
    private String concSpec;
    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名称")
    private String manuFactoryName;
    @ApiModelProperty("批准文号")
    private String approvalNumber;
    @ApiModelProperty("产地")
    private String origin;
    @SysCode(
            sys = "yst-supp",
            mod = "DOSAGE_FORM"
    )
    @ApiModelProperty("剂型, [UDC]yst-supp:DOSAGE_FORM")
    private String dosageForm;
    @ApiModelProperty("剂型名称")
    private String dosageFormName;




}
