package com.elitesland.inv.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 在库商品查询
 * </p>
 *
 * @author jeesie.jiang
 * @date 2023/8/03
 */
@Data
@ApiModel(value = "invItmStkOpenRpcDTO", description = "在库商品库存查询")
public class InvStkOpenRpcDTO implements Serializable {

    private static final long serialVersionUID = 2123440351245698105L;

    @ApiModelProperty("库存ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("批次号")
    private String lotNo;






}
