package com.tll.investment.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.investment.Application;
import com.tll.investment.rpc.param.FormalAgreementInfoRPCDTO;
import com.tll.investment.rpc.param.vo.FormalAgreementInfoRPCVO;
import com.tll.investment.rpc.param.save.FormalAgreementStoreStatusDTO;
import com.tll.investment.rpc.param.vo.RpcUnifiedReturnVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = AgreementRpcService.URI)
@Validated
public interface FormalAgreementRpcService {
    String URI = Application.URI_PREFIX + "/formal/agreement";

    @ApiOperation(value = "更新正式签约建店状态")
    @PostMapping(value = "/update/storeBuildStatus")
    ApiResult<RpcUnifiedReturnVO> updateStoreBuildStatus(@Validated @RequestBody FormalAgreementStoreStatusDTO param);


    @PostMapping("/info")
    ApiResult<FormalAgreementInfoRPCVO> info(@Validated @RequestBody FormalAgreementInfoRPCDTO dto);
}
