package com.tll.investment.rpc.param.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: cbb
 * @Date: 2025/2/24 09:30
 * @Description 支付回调
 * <p>
 * <p>
 * <p>
 * 对接支付中心--支付回调
 */

@Data
@ApiModel(description = "支付回调详情--入参")
public class PaymentCallbackDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 业务单号
     */
    @ApiModelProperty("业务单号")
    @NotBlank(message = "业务单号不能为空")
    private String bizNo;


    /**
     * 完成时间
     */
    @ApiModelProperty("完成时间")
    private Date completeTime;


    /**
     * 交易流水号
     */
    @ApiModelProperty("交易流水号")
    private String transNo;

    /**
     * 交易状态
     */
    @ApiModelProperty("交易状态")
    private String transStatus;

}

