package com.tll.investment.rpc.param.vo;

import com.tll.investment.rpc.param.model.FranchiseFeeBilIDetailDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "加盟费账单响应实体数据")
public class IntentionCustomerVO implements Serializable {
    @ApiModelProperty("加盟费账单表主键id")
    private Long id;

    @ApiModelProperty("支付状态  0未支付，1已支付，2,已转账待确认，3已发起待支付，4已取消")
    private Integer payStatus;

    @ApiModelProperty("支付方式（线下收款-->POS扫码收款10，现金11，刷卡12；小程序支付-->微信20，支付宝21；银行卡转账-->30）")
    private Integer payType;

    @ApiModelProperty("支付完成时间")
    private LocalDateTime payCompletedTime;

    @ApiModelProperty("订单号")
    private String payTradeNo;

    @ApiModelProperty("交易单号")
    private String orderNo;

    @ApiModelProperty("支付凭证")
    private String payVoucherPic;

    @ApiModelProperty("加盟费明细")
    List<FranchiseFeeBilIDetailDO> franchiseFeeBilIDetailDOS;
}
