package com.tll.investment.rpc;

import com.tll.investment.Application;
import com.tll.investment.rpc.param.query.PaymentCallbackDTO;
import com.tll.investment.rpc.param.vo.PaymentCallbackVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Author: cbb
 * @Date: 2025/2/24 9:15
 * @Description
 */

@FeignClient(name = Application.NAME, path = PaymentCentRpcService.URI)
public interface PaymentCentRpcService {

    String URI = Application.URI_PREFIX + "/paymentCenter";


    /**
     * 支付中心--支付成功回调
     * @param dto
     * @return
     */
    @PostMapping("/callback")
    PaymentCallbackVo callback(@RequestBody @Validated PaymentCallbackDTO dto);
}
