package com.tll.investment.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.investment.Application;
import com.tll.investment.rpc.param.query.QueryStoreConfirmInfoRPCDTO;
import com.tll.investment.rpc.param.vo.StoreConfirmInfoRPCVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * title:
 * author: zq
 * create: 2025-03-13 10:40
 **/
@FeignClient(name = Application.NAME, path = StoreInfoCollectionRpcService.URI)
public interface StoreInfoCollectionRpcService {

    String URI = Application.URI_PREFIX + "/storeInfoCollection";

    /**
     * 根据商机编码查询新店收集信息
     *
     * @param dto
     * @return
     */
    @PostMapping(value = "/queryStoreConfirmByOpportunityNumber")
     ApiResult<StoreConfirmInfoRPCVO> queryStoreConfirmByOpportunityNumber(@Validated @RequestBody QueryStoreConfirmInfoRPCDTO dto);
}
