package com.tll.investment.rpc.param.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


@Data
@ApiModel(description = "加盟签约详情数据")
public class FormalAgreementInfoRPCVO implements Serializable {
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("加盟签约协议编号")
    private String formalAgreementNumber;

    @ApiModelProperty("意向协议编号")
    private String intentionAgreementNumber;

    @ApiModelProperty("活动优惠信息")
    private List<ActivityPromotionRegistrationVO> activityPromotionRegistrationVOList;

    @ApiModelProperty("账单信息")
    private FranchiseFeeBillRespVO franchiseFeeBillRespVO;

    @ApiModelProperty("商机编号")
    private String opportunityNumber;

    @ApiModelProperty("面试记录主键id")
    private Long interviewId;

    @ApiModelProperty("统一社会信用代码或身份证号码")
    private String unifiedSocialCreditCode;

    @ApiModelProperty("客户基本资料")
    private IntentionCustomerVO customerVO;

    @ApiModelProperty("签约进度：1协议起草中,2待缴纳意向金,3待签署协议,4意向已签署,5已取")
    private Integer signProgress;

    @ApiModelProperty("建店状态：0：未建店  1：已建店")
    private Integer storeBuildStatus;

    @ApiModelProperty("合同状态：0默认(创建草稿),1签署中,2已完成,3已作废,4已终止,5已逾期,6已拒签")
    private Integer contractStatus;

    @ApiModelProperty(value = "电子合同编号")
    private String electronicContractNumber;

    @ApiModelProperty("电子合同链接")
    private String contractUrl;

    @ApiModelProperty("电子合同模板名称")
    private String templateName;

    @ApiModelProperty("电子合同模板id")
    private String templateId;

    @ApiModelProperty(value = "纸质合同编号")
    private String paperContractNumber;

    @ApiModelProperty("纸质合同文件链接")
    private String paperContractUrl;

    @ApiModelProperty("纸质合同上传时间")
    private LocalDateTime paperContractUploadTime;

    @ApiModelProperty("加盟店的经营地址")
    private String franchiseAddress;

    @ApiModelProperty("合同年限")
    private String contractYears;

    @ApiModelProperty("合同类型：1:使用电子合同,2:不使用电子合同")
    private Integer contractType;

    @ApiModelProperty("合同开始日期")
    private LocalDateTime contractStartDate;

//    @ApiModelProperty("加盟方式")
//    private String joiningMode;

    @ApiModelProperty("合同结束日期")
    private LocalDateTime contractEndDate;

    @ApiModelProperty("乙方联系人姓名")
    private String partyBContact;

    @ApiModelProperty("乙方电子邮箱")
    private String partyBEmail;

    @ApiModelProperty("乙方住址")
    private String partyBAddress;

    @ApiModelProperty("乙方联系方式，如手机号码等")
    private String partyBPhone;

    @ApiModelProperty("招商经理ID")
    private Long managerId;

    @ApiModelProperty("招商经理名称")
    private String managerName;

    @ApiModelProperty("是否提交存为草稿：0-否，1-是")
    private Integer isSubmit;

    private Integer tempId;

    @ApiModelProperty(value = "是否为上传二次合同之后的(如上传完纸质合同再次上传电子合同)")
    private Boolean secondFlag = Boolean.FALSE;

    @ApiModelProperty("首次正式合同编号")
    private String firstContractNumber;

    @ApiModelProperty("重签正式合同编号")
    private String newContractNumber;

    @ApiModelProperty("重签正式合同类型")
    private Integer newContractType;

    @ApiModelProperty("签约完成时间")
    private Date completeTime;

    @ApiModelProperty("首次合同类型,用来记录法大大回调是否更新状态")
    private Integer firstContractType;

    @ApiModelProperty("是否是重签：1首次签署，2重新签署")
    private Integer isAgainSign;

    @ApiModelProperty("加盟费金额合计")
    private BigDecimal total;

    @ApiModelProperty("合同创建时间")
    private LocalDateTime contractCreateTime;

    @ApiModelProperty("身份证反面")
    private String reverseIdentityCard;

    @ApiModelProperty("身份证正面")
    private String identityCardNumber;

    @ApiModelProperty("法大大签署任务id,调用页面预览的时候会用到")
    private String signTaskId;
}
