package com.tll.investment.rpc.param.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
@Data
@ApiModel(description = "加盟费账单详情数据")
public class FranchiseFeeBilIDetailVO {

    @ApiModelProperty("加盟费账单表主键")
    @Column(name = "franchise_fee_bill_id")
    private Long FranchiseFeeBilIId;

    @ApiModelProperty("费用款项明细")
    @Column(name = "fee_item_detail")
    private String feeItemDetail;

    @ApiModelProperty("原价金额")
    @Column(name = "original_price")
    private BigDecimal originalPrice;

    @ApiModelProperty("减免/结转金额")
    @Column(name = "reduction_amount")
    private BigDecimal reductionAmount;

    @ApiModelProperty("减免/结转原因")
    @Column(name = "reduction_reason")
    private String reductionReason;

    @ApiModelProperty("待缴纳金额")
    @Column(name = "wait_pay_amount")
    private BigDecimal waitPayAmount;
}
