package com.tll.investment.rpc.param.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Author: cbb
 * @Date: 2025/2/24 09:48
 * @Description 支付中心统一响应
 */

@Data(staticConstructor =  "of")
@Accessors(chain = true)
@ApiModel(description = "支付中心响应")
public class PaymentCallbackVo<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 响应码
     */
    @ApiModelProperty("响应码")
    private int code;

    /**
     * 响应信息
     */
    @ApiModelProperty("响应信息")
    private String msg;

    /**
     * 响应数据
     */
    @ApiModelProperty("响应数据")
    private T data;


}