package com.tll.investment.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.investment.Application;
import com.tll.investment.rpc.param.StoreContractListDTO;
import com.tll.investment.rpc.param.vo.StoreContractListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = StoreContractRpcService.URI)
@Validated
public interface StoreContractRpcService {
    String URI = Application.URI_PREFIX + "/store/contract";

    /**
     * 门店合同记录
     *
     * @param param
     * @return
     */
    @PostMapping("/list")
    ApiResult<StoreContractListVO> storeContractList(@RequestBody StoreContractListDTO param);
}
