package com.tll.investment.rpc.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 更新OA合同信息参数
 * @Date: 2025/3/20 09:34
 * @Version: 1.0
 */
@Data
public class OAContractDTO implements Serializable {
    private static final long serialVersionUID = -6908036556042130699L;

    @ApiModelProperty(value = "门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    @NotBlank(message = "门店名称不能为空")
    private String storeName;

    @ApiModelProperty(value = "门店详细名称")
    @NotBlank(message = "门店详细名称名称不能为空")
    private String storeDetailName;

    @NotBlank(message = "门店详细地址不能为空")
    @ApiModelProperty(value = "门店详细地址")
    private String storeDetailAddress;

    @NotBlank(message = "是否补贴房源")
    @ApiModelProperty(value = "是否补贴房源")
    private Boolean isSubsidyHouse;
}
