package com.tll.investment.rpc.param.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author sunsx
 * @date 2025/09/15
 * @description 房屋租赁合同信息展示
 */
@Data
@ApiModel(description = "房屋租赁合同信息展示")
public class HouseRentalContractInfoVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("房补申请编号：展示高房补的申请单据号，点击可跳转到房补详情")
    private String subsidyAgreementNumber;

    @ApiModelProperty("合同链接：招商在创建高房补时上传的房租租赁合同链接，当有多个链接时都需要展示，点击链接可打开浏览下载")
    private List<String> contractUrls;

    @ApiModelProperty("房租（元/年）：招商在创建高房补时填写的房租")
    private BigDecimal rentAmount;

    @ApiModelProperty("登记人：高房补创建人")
    private String creator;

    @ApiModelProperty("登记时间：高房补创建时间（非审批通过时间）")
    private LocalDateTime createTime;

    @ApiModelProperty("合同开始时间：招商在创建高房补时选择的时间")
    private LocalDate contractStartTime;

    @ApiModelProperty("合同结束时间：招商在创建高房补时选择的时间")
    private LocalDate contractEndTime;

}
