package com.tll.investment.rpc.param.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author suns
 * @date 2025/04/22
 * @description 门店合同信息
 */

@Data
@ApiModel(description = "门店合同信息")
public class StoreContractInfoVO implements Serializable {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("合同编号")
    private String contractNumber;

    @ApiModelProperty("协议编号")
    private String agreementNumber;

    @ApiModelProperty("合同类型： 1.意向合同 2.正式合同 3.高房补贴合同 4.报货折扣合同")
    private Integer contractType;

    @ApiModelProperty("金额/折扣")
    private String amountDesc;

    @ApiModelProperty("签订人")
    private String signer;

    @ApiModelProperty("合同开始时间")
    @JsonFormat(pattern = "yyyy年MM月dd日")
    private LocalDate startDate;

    @ApiModelProperty("合同结束时间")
    @JsonFormat(pattern = "yyyy年MM月dd日")
    private LocalDate endDate;

}
