package com.elitesland.openplatform.api.rpc;

import com.elitesland.openplatform.api.rpc.params.AbstractMessageData;
import com.elitesland.openplatform.api.rpc.params.ClientInfoDTO;
import com.elitesland.openplatform.api.rpc.params.OpenApiMessage;
import com.elitesland.openplatform.api.rpc.params.PushResult;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 回调客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2022/1/27
 */
public interface OpenPlatformClientCall {

    /**
     * 异步推送消息
     *
     * @param message 消息
     * @param <T>     负载数据类型
     * @return 推送状态
     */
    <T extends AbstractMessageData> CompletableFuture<List<PushResult>> pushAsync(OpenApiMessage<T> message);

    /**
     * 查询消息推送结果
     *
     * @param key 消息标识
     * @return 推送结果
     */
    CompletableFuture<List<PushResult>> queryPushResult(@NotBlank(message = "消息标识为空") String key);

    /**
     * 获取客户信息
     *
     * @param clientKey 客户key
     * @return 客户信息
     */
    CompletableFuture<ClientInfoDTO> getClient(String clientKey);
}
