package com.elitesland.openplatform.api.rpc.params;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 调用客户端消息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/1/27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OpenApiMessage<T extends AbstractMessageData> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 客户端标识，若为空，则向所有在用客户端推送
     */
    private Long[] clientIds;

    /**
     * 业务应用类型，如yst-order
     */
    @NotBlank(message = "业务应用名称不能为空")
    private String app;

    /**
     * 消息的唯一标识
     */
    @NotBlank(message = "消息的标识不能为空")
    private String key;

    /**
     * 传送给客户端的数据
     */
    @NotNull(message = "负载数据不能为空")
    @Valid
    private T payload;
}
