package com.elitesland.openplatform.api.rpc.params;

import com.elitesland.openplatform.api.rpc.CallStatus;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 消息推送结果.
 *
 * @author Kaiser（wang shao）
 * @date 2022/1/27
 */
@Data
public class PushResult implements Serializable {
    private static final long serialVersionUID = -2769457739446699453L;

    /**
     * 消息标识
     */
    private String key;

    /**
     * 客户端ID
     */
    private Long clientId;

    /**
     * 推送状态
     */
    private CallStatus status;

    /**
     * 重试次数
     */
    private Integer retryTimes;

    /**
     * 最后一次推送时间
     */
    private LocalDateTime pushTime;

    /**
     * 发送失败原因
     */
    private String reason;
}
