package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.ss.PurSsRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurSsProvider.PATH)
public interface PurSsProvider {
    String PATH = "/purSs";

    @PostMapping("/updateCarrierInfo")
    ApiResult<Void> updateCarrierInfo(@RequestBody PurSsRpcDTO param);

    @PostMapping("/updateIsCarrige")
    ApiResult<Void> updateIsCarrige(@RequestBody PurSsRpcDTO param);

    @PostMapping("/findById")
    PurSsRpcDTO findById(@RequestBody Long id);


}
