package com.elitesland.pur.provider;

import com.elitesland.pur.Application;
import com.elitesland.pur.dto.PurPriceBaseDTO;
import com.elitesland.pur.dto.PurPriceBatchParamDTO;
import com.elitesland.pur.dto.PurPriceParamDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/06/22
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurPriceProvider.PATH)
public interface PurPriceProvider {
    String PATH = "/purPrice";
    /**
     * 根据获取采购价格DTO入参查询采购价格
     *
     * @param param 获取采购价格DTO入参
     * @return 采购价格
     */
    @GetMapping("/getPrice")
    ApiResult<PurPriceBaseDTO> getPriceByParam(@RequestBody @Valid PurPriceParamDTO param);

    /**
     * 批量查询采购价格
     *
     * @param priceBatchParam 批量获取采购价格DTO入参
     * @return 采购价格
     */
    @GetMapping("/getPriceList")
    ApiResult<List<PurPriceBaseDTO>> getPriceListByParam(@RequestBody @Valid PurPriceBatchParamDTO priceBatchParam);


}
