package com.elitesland.pur.dto.supp;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 采购对账单单据表明细(PurGrD)实体类
 * </p>
 *
 * @author tina.he
 * @since 2021-06-01 17:07:28
 */
@Data
@ApiModel(value = "PurUnionAccountDSaveDTO", description = "采购对账单单据表明细")
public class PurUnionAccountDSaveDTO implements Serializable {
    private static final long serialVersionUID = -3064679432105014951L;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("业务单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long billDId;

    @ApiModelProperty("业务单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long billId;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 收货地址
     */
    @ApiModelProperty("收货地址")
    private String recvAddr;

    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 采购订单行号
     */
    @ApiModelProperty("采购订单行号")
    private Double lineNo;

    /**
     * 采购收货单行号
     */
    @ApiModelProperty("采购收货单行号")
    private Double grLineNo;

    /**
     * 中间表行号
     */
    @ApiModelProperty("中间表行号")
    private Double tblLineNo;
    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * 订购数量
     */
    @ApiModelProperty("订购数量")
    private Double poQty;

    @ApiModelProperty("发货数量")
    private Double ssQty;
    /**
     * 收货数量
     */
    @ApiModelProperty("收货数量")
    private Double qty;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 收货数量2
     */
    @ApiModelProperty("收货数量2 - 和入库单位一致的收货数量")
    private Double qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private Double uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("配额分配金额(含税)")
    private BigDecimal partsAmtUse;

    @ApiModelProperty("配额分配金额(不含税)")
    private BigDecimal partsNetAmtUse;

    @ApiModelProperty("配额分配本币金额(含税)")
    private BigDecimal partsAmtLocalUse;

    @ApiModelProperty("配额分配本币金额(不含税)")
    private BigDecimal partsNetAmtLocalUse;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("收货单据编号")
    private String grNo;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "COM",mod = "DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("采购结算对账单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long purAccountCheckId;

    @ApiModelProperty(value = "是否生成采购结算对账单，0：未生成，1：已生成")
    private Integer accountFlag;
}
