package com.elitesland.pur.dto.supp;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 采购对账单单据表(PurUnionAccount)实体类
 * </p>
 *
 * @author tina.he
 * @since 2021-06-01 17:04:52
 */
@Data
@ApiModel(value = "PurUnionAccountDTO", description = "采购对账单单据表")
public class PurUnionAccountSaveDTO implements Serializable {
    private static final long serialVersionUID = 194589649559012783L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("业务单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long billId;

    @ApiModelProperty("采购场景类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long sceneTypeId;
    String sceneTypeCode;
    String sceneTypeName;

    @ApiModelProperty("单据类型 [UDC]PUR:ACCOUNTBILLTYPE")
    String billDocType;

    @ApiModelProperty("对账类型 [UDC]PUR:ACCOUNT_TYPE")
    String accountType;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:GR_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:GR_TYPE")
    private String docType;
    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    private String docStatus;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;

    /**
     * 采购订单订单时间
     */
    @ApiModelProperty("采购订单订单时间")
    private LocalDateTime docTime;
    /**
     * 采购订单ID
     */
    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;

    /**
     * 采购订单编号
     */
    @ApiModelProperty("采购订单编号")
    private String poNo;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvEmpId;

    /**
     * 收货人员工名字
     */
    @ApiModelProperty("收货人员工名字")
    @JsonSerialize(using = ToStringSerializer.class)
    private String recvEmpName;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private Double qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private Double qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("配额分配金额(含税)")
    private BigDecimal partsAmtUse;

    @ApiModelProperty("配额分配金额(不含税)")
    private BigDecimal partsNetAmtUse;

    @ApiModelProperty("配额分配本币金额(含税)")
    private BigDecimal partsAmtLocalUse;

    @ApiModelProperty("配额分配本币金额(不含税)")
    private BigDecimal partsNetAmtLocalUse;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    /**
     * 采购对账单单据表明细
     */
    @ApiModelProperty("采购对账单单据表明细")
    private List<PurUnionAccountDSaveDTO> purUnionAccountDSaveDTOList;


}
