package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.file.ComFileDTO;
import com.elitesland.pur.dto.ss.PurSsDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ComFileProvider.PATH)
public interface ComFileProvider {
    String PATH = "/comFile";

    @PostMapping("/findByFileCodeIn")
    ApiResult<List<ComFileDTO>> findByFileCodeIn(@RequestBody List<String> param);
}
