package com.elitesland.pur.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.supp.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/25
 */
@FeignClient(name = Application.NAME, path = Application.PATH + PurSuppProvider.PATH)
@Validated
public interface PurSuppProvider {
    String PATH = "/purSupp";

    /**
     * 根据入参查询供应商基础信息列表
     *
     * @param param 入参
     * @return 供应商基础信息出参对象列表
     */
    @GetMapping("/findBaseRpcDto")
    ApiResult<List<PurSuppBaseRpcDTO>> findBaseRpcDtoByParam(@RequestBody PurSuppBaseRpcParam param);

    /**
     * 根据入参查询供应商的银行信息列表
     *
     * @param param 入参
     * @return 供应商的银行信息出参对象列表
     */
    @GetMapping("/findBankAccRpcDto")
    ApiResult<List<PurSuppBankAccRpcDTO>> findBankAccRpcDtoByParam(@RequestBody PurSuppBankAccRpcParam param);

    /**
     * 根据入参查询供应商的联系信息列表
     *
     * @param param 入参
     * @return 供应商的联系信息出参对象列表
     */
    @GetMapping("/findAddressRpcDto")
    ApiResult<List<PurSuppAddressRpcDTO>> findAddressRpcDtoByParam(@RequestBody PurSuppAddressRpcParam param);

    /**
     * 根据供应商入参分页查询供应商部分信息
     *
     * @param param 供应商DTO入参
     * @return 供应商部分信息出参对象
     */
    //ApiResult<PagingVO<PurSuppBaseDTO>> searchSupp(PurSuppParamDTO param);

    /**
     * 根据ID批量查询供应商信息
     *
     * @param ids 供应商ID
     * @return 供应商对象
     */
    @PostMapping("/findBySuppIdBatch")
    ApiResult<List<PurSuppBaseDTO>> findBySuppIdBatch(@RequestBody List<Long> ids);

    /**
     * 根据供应商ID查询其银行信息
     *
     * @param id 供应商ID
     * @return 供应商的银行信息
     */
    @PostMapping("/findBankBySuppId")
    ApiResult<PurAddrBankAccDTO> findBankBySuppId(@RequestBody Long id);

}
