package com.elitesland.pur.file.vo;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.LastModifiedDate;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author tina.he
 * @date 2021-02-09
 */
@ApiModel(description = "文件上传结果对象")
@Data
public class ComFileUploadRespVO implements Serializable {
    private static final long serialVersionUID = -6856716509909310076L;

    @ApiModelProperty(value = "文件的ID")
    @JsonSerialize(using = ToStringSerializer.class)
    public Long id;

    @ApiModelProperty(value = "文件编码")
    public String fileCode;

    @LastModifiedDate
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "文件编码")
    private String originalName;

    @ApiModelProperty(value = "文件上传名称")
    private String uploadName;


}
