package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.rns.PurRnsRecvRpcSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 采购退货出库单
 *
 * @author chaofeng.xia
 * @date 2023/9/25 16:56
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurRnsRecvProvider.PATH)
public interface PurRnsRecvProvider {
    String PATH = "/purRnsRecv";

    /**
     * 创建采购退货出库单RPC接口
     *
     * @param purRnsRecvRpcSaveDTO 退货出库单信息
     * @return 采购出库单id
     */
    @PostMapping("/createByCrossCompany")
    ApiResult<Long> createByCrossCompany(@RequestBody PurRnsRecvRpcSaveDTO purRnsRecvRpcSaveDTO);
}
