package com.elitesland.pur.dto.gr;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "采购收货单明细")
public class PurGrDetailRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("明细ID")
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("入库批次")
    private String inLotNo;

    @ApiModelProperty("发货数量")
    private BigDecimal deliveryQty;

    @ApiModelProperty("入库数量")
    private BigDecimal inQty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("可退数量")
    private BigDecimal canRtnQty;

    @ApiModelProperty("关联明细id")
    private Long relateDocDid;
}