package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购退货出库单明细
 *
 * @author chaofeng.xia
 * @date 2023/9/25 16:55
 */
@Data
@ApiModel(value = "PurRnsRecvDSaveRpcDTO", description = "采购退货出库单明细")
public class PurRnsRecvDSaveRpcDTO implements Serializable {


    private static final long serialVersionUID = -7584620469185929635L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Double lineNo;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * 供应商发货单明细ID
     */
    @ApiModelProperty("供应商发货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ssDId;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;


    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 订购数量
     */
    @ApiModelProperty("订购数量")
    private Double poQty;

    @ApiModelProperty("发货数量")
    private BigDecimal ssQty;
    /**
     * 收货数量
     */
    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("本次收货数量")
    @Column(name = "ltst_qty", columnDefinition = "NUMERIC(20,8)   comment '本次收货数量'")
    Double ltstQty;

    @ApiModelProperty("本次收货数量2(库存数量)")
    @Column(name = "ltst_qty2", columnDefinition = "NUMERIC(20,8)   comment '本次收货数量2(库存数量)'")
    Double ltstQty2;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 收货数量2
     */
    @ApiModelProperty("收货数量2 - 和入库单位一致的收货数量")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private Double uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 交易单价 折扣后，不含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private Double transPrice;
    /**
     * 税额
     */
    @ApiModelProperty("税额（原币）")
    private BigDecimal taxAmt;


    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额（本币）")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额（本币）")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额（原币）")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额（原币）")
    private BigDecimal currNetAmt;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 发货仓库id
     */
    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 收货批次
     */
    @ApiModelProperty("收货批次")
    private String lotNo;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 整批号
     */
    @ApiModelProperty("整批号")
    private String batchNo;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 剩余效期天数
     */
    @ApiModelProperty("剩余效期天数")
    private Integer untilExpireDays;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Integer demandAapDays;
    /**
     * 是否新鲜度合格
     */
    @ApiModelProperty("是否新鲜度合格")
    private Integer isFressValid;

    @ApiModelProperty("到货保质期比例")
    private Double actualFreshPercent;
    /**
     * 供应商发货日期
     */
    @ApiModelProperty("供应商发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 异常备注
     */
    @ApiModelProperty("异常备注")
    private String exceptionDesc;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull
    private Long outerId;

    @ApiModelProperty("外部单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull
    private Long outerDid;

    /**
     * 外部单据行号
     */
    @ApiModelProperty("外部单据行号")
    private Double outerLineno;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private Double relateDocLineno;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private Double rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("品牌")
    private String dbrand;

    @ApiModelProperty("基价")
    private BigDecimal basePrice;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("折扣类型")
    private String discType;

    @ApiModelProperty("折扣率")
    private Double discRatio;

    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣描述")
    private String discDesc;

    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("已付数量")
    Double payedQty;

    @ApiModelProperty("已付金额")
    Double payedAmt;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("收货单据编号")
    String grNo;

    @ApiModelProperty("是否供应商仓库")
    private Integer isSuppWh;


    @ApiModelProperty("是否越库供应商仓库标志")
    private Integer isCrossFlagSuppWh;

    @ApiModelProperty("采购退货登记单签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("采购退货登记单主计量单位签收数量")
    private BigDecimal confirmQty2;

    @ApiModelProperty("采购退货登记单签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("采购退货登记单拒收中数量")
    private BigDecimal rejectingQty;

    @ApiModelProperty("已签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("已签收不含税金额")
    private BigDecimal confirmNetAmt;

    @ApiModelProperty("已签收外币含税金额")
    private BigDecimal confirmCurrAmt;

    @ApiModelProperty("已签收外币不含税金额")
    private BigDecimal confirmCurrNetAmt;
    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    private String stkItmStatus;


}
