package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购订单明细
 * @author feng
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "pur_po_d", description = "采购订单明细")
public class PurPodSaveVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 3221249667410292226L;
    /**
     * 主表ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("关联单据编号")
    String poNo;

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 事业部ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("事业部ID")
    private Long bdId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Integer lineNo;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
     Float purPaSrcLineNo;
    /**
     * 行类型 [UDC]PUR:PO_LINE_TYPE
     */
    @ApiModelProperty("行类型 [UDC]PUR:PO_LINE_TYPE")
    @SysCode(sys = "yst-purc",mod = "PO_LINE_TYPE")
    private String lineType;
    @ApiModelProperty("行类型名称")
    private String lineTypeName;

    /**
     * 暂挂原因码 [UDC]PUR:PO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]PUR:PO_HOLD_REASON")
    private String holdReasonCode;
    @ApiModelProperty("暂挂原因码名称")
    private String holdReasonCodeName;

    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 收货仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货仓库ID")
    private Long whId;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys="INV",mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys="yst-inv",mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;
    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 品项ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品项ID")
    private Long itemId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;
    /**
     * 品项规格
     */
    @ApiModelProperty("品项规格")
    private String itemSpec;

    @ApiModelProperty("品项ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId2;

    @ApiModelProperty("品项编号2")
    private String itemCode2;

    @ApiModelProperty("品项名称2")
    private String itemName2;

    @ApiModelProperty("品项规格2")
    private String itemSpec2;
    /**
     * 供应商品项编号
     */
    @ApiModelProperty("供应商品项编号")
    private String itemCsCode;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 数量
     */
    @ApiModelProperty("付款数量")
    private BigDecimal paQty;

    @ApiModelProperty("付款外币含税金额")
    BigDecimal paCurrAmt;
    /**
     * 数量
     */
    @ApiModelProperty("已付款数量")
    private BigDecimal amtQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 包装要求
     */
    @ApiModelProperty("包装要求")
    private String packDemand;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private BigDecimal weightRatio;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 不含税价格
     */
    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 未税单价(外币）
     */
    @ApiModelProperty("未税单价(外币）")
    private BigDecimal currNetPrice;
    /**
     * 含税单价(外币)
     */
    @ApiModelProperty("含税单价(外币)")
    private BigDecimal currPrice;
    /**
     * 价格本价格
     */
    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;
    /**
     * 价格本币种
     */
    @ApiModelProperty("价格本币种")
    private String pbCurr;
    private String pbCurrName;
    /**
     * 价格本单位
     */
    @ApiModelProperty("价格本单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pbUom;
    private String pbUomName;
    /**
     * 折扣类型
     */
    @ApiModelProperty("折扣类型")
    private String discType;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 折扣额
     */
    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 折扣后价格
     */
    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;
    /**
     * 交易单价 折扣后，不含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private BigDecimal transPrice;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    private LocalDateTime invDate;
    /**
     * 供应商税类型
     */
    @ApiModelProperty("供应商税类型")
    private String suppTaxType;
    /**
     * 商品税类型
     */
    @ApiModelProperty("商品税类型")
    private String itemTaxType;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 承诺数量
     */
    @ApiModelProperty("承诺数量")
    private BigDecimal promiseQty;
    /**
     * 通知发货数量
     */
    @ApiModelProperty("通知发货数量")
    private BigDecimal shipmentQty;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;
    /**
     * 发货单位
     */
    @ApiModelProperty("发货单位")
    private String shipmentUom;
    /**
     * 已收数量
     */
    @ApiModelProperty("已收数量")
    private BigDecimal acceptQty;
    /**
     * 已退数量
     */
    @ApiModelProperty("已退数量")
    private BigDecimal returnedQty;
    /**
     * 收货单位
     */
    @ApiModelProperty("收货单位")
    private String acceptUom;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime acceptDate;
    /**
     * 实际未发货数量
     */
    @ApiModelProperty("实际未发数量")
    private BigDecimal acUnshipQty;
    /**
     * 差异数量
     */
    @ApiModelProperty("差异数量")
    private BigDecimal diffQty;
    /**
     * 供应商送货状态
     */
    @ApiModelProperty("供应商送货状态")
    private String suppShipmentStatus;
    /**
     * 延交状态
     */
    @ApiModelProperty("延交状态")
    private String overdueStatus;
    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    private String recvStatus;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private BigDecimal demandFreshPercent;
    /**
     * 要求效期天数
     */
    @ApiModelProperty("要求效期天数")
    private Integer demandAapDays;
    /**
     * 原始交期
     */
    @ApiModelProperty("原始交期")
    private LocalDateTime origDate;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;
    /**
     * 供应商承诺交期
     */
    @ApiModelProperty("供应商承诺交期")
    private LocalDateTime promiseDate;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 供应商预约到货日期
     */
    @ApiModelProperty("供应商预约到货日期")
    private LocalDateTime scheduledArriveDate;
    /**
     * 最早收货日期
     */
    @ApiModelProperty("最早收货日期")
    private LocalDateTime firstRecvDate;
    /**
     * 最后收货日期
     */
    @ApiModelProperty("最后收货日期")
    private LocalDateTime lastRecvDate;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;
    /**
     * 收货允差2
     */
    @ApiModelProperty("收货允差2")
    private BigDecimal recvTolerance2;
    /**
     * 是否加急
     */
    @ApiModelProperty("是否加急")
    private Integer urgentFlag;
    /**
     * 催货说明
     */
    @ApiModelProperty("催货说明")
    private String urgeComment;
    /**
     * 供应商进度说明
     */
    @ApiModelProperty("供应商进度说明")
    private String suppComment;
    /**
     * 供方单号
     */
    @ApiModelProperty("供方单号")
    private String suppDocNo;
    /**
     * 取消数量
     */
    @ApiModelProperty("取消数量")
    private BigDecimal cancelQty;

    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    BigDecimal canceledQty;

    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    private LocalDateTime closeTime;
    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关闭用户ID")
    private Long closeUserId;
    /**
     * 免值标记
     */
    @ApiModelProperty("免值标记")
    @SysCode(sys = "yst-supp", mod = "ZEROVAL_TYPE")
    private String zerovalType;
    private String zerovalTypeName;
    /**
     * 促销ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("促销ID")
    private Long promId;
    /**
     * 促销编号
     */
    @ApiModelProperty("促销编号")
    private String promNo;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;

    @ApiModelProperty("是否启用批次")
    Boolean lotFlag;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    private String es6;
    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;
    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;
    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
    /**
     * EN1
     */
    @ApiModelProperty("EN1")
    private BigDecimal en1;
    /**
     * EN2
     */
    @ApiModelProperty("EN2")
    private BigDecimal en2;
    /**
     * EN3
     */
    @ApiModelProperty("EN3")
    private BigDecimal en3;
    /**
     * EN4
     */
    @ApiModelProperty("EN4")
    private BigDecimal en4;
    /**
     * EN5
     */
    @ApiModelProperty("EN5")
    private BigDecimal en5;
    /**
     * ED1
     */
    @ApiModelProperty("ED1")
    private LocalDateTime ed1;
    /**
     * ED2
     */
    @ApiModelProperty("ED2")
    private LocalDateTime ed2;
    /**
     * ED3
     */
    @ApiModelProperty("ED3")
    private LocalDateTime ed3;

    @ApiModelProperty("品牌code")
    private String dbrand;
    private String dbrandName;

    @ApiModelProperty("保质期天数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Integer storeExpireDays;

    @ApiModelProperty("基准日期")
    private LocalDateTime aapDate;

    @ApiModelProperty("订单日期")
    private LocalDateTime docTime;


    @ApiModelProperty("已付数量")
    BigDecimal payedQty;

    @ApiModelProperty("已付金额")
    BigDecimal payedAmt;

    @ApiModelProperty("已收货金额（含税）")
    BigDecimal recvAmt;

    @ApiModelProperty("请款人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long docEmpId;
    String docEmpName;

    @ApiModelProperty("来源单据类别[UDC]COM:DOC_CLS]")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    String rootDocType;

    @ApiModelProperty("来源单据ID")
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    String rootDocNo;

    @ApiModelProperty("来源单据明细ID")
    Long rootDocDid;

    @ApiModelProperty("来源单据行号")
    Integer rootDocLineNo;

    @ApiModelProperty("销售订单单据ID")
    Long soDocId;

    @ApiModelProperty("销售订单单据编号")
    String soDocNo;

    @ApiModelProperty("销售订单单据明细ID")
    Long soDocDid;

    @ApiModelProperty("销售订单来源单据行号")
    Integer soDocLineNo;

    @ApiModelProperty("字段拼接key")
    String suppAndOuIdKey;

    @ApiModelProperty("配额比例")
    BigDecimal partsRatio;
    @ApiModelProperty("出货方式")
    private String sellMethod;

    @ApiModelProperty("收货地址类型")
    private String recvAddrType;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;

    @ApiModelProperty("仓库编号")
    private String whCode;
    @ApiModelProperty("仓库类型")
    private String whType;
    @ApiModelProperty("仓库名称")
    private String whName;
    @ApiModelProperty("国家")
    private String country;
    @ApiModelProperty("省编码")
    private String province;
    @ApiModelProperty("市编码")
    private String city;
    @ApiModelProperty("区编码")
    private String county;
    @ApiModelProperty("收货门店编码")
    private String recvStoreCode;
    @ApiModelProperty("收货门店名称")
    private String recvStoreName;

    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;
    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;
    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;
    @ApiModelProperty("采购场景ID")
    private Long sceneTypeId;
}
