package com.elitesland.pur.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.PurAccountDTO;
import com.elitesland.pur.dto.supp.PurUnionAccountSaveDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * <p>
 * 采购对账单
 * </p>
 *
 * @author tina.he
 * @since 2021-06-07 10:01:49
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurAccountProvider.PATH)
public interface PurAccountProvider {

    String PATH = "/purAccount";

    /**
     * 修改类型
     *
     * @param purAccountDTO
     * @return docNos
     */
    @PostMapping("/updateStatus")
    ApiResult<Void> batchUpdateDocStatus(@RequestBody @Valid PurAccountDTO purAccountDTO);
}
