package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.rns.PurRnsRgrRpcDTO;
import com.elitesland.pur.dto.rns.PurRnsRpcDTO;
import com.elitesland.pur.dto.rns.PurRnsSaveRpcParam;
import com.elitesland.pur.dto.rns.PurRnsSaveRpcResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurRnsProvider.PATH)
public interface PurRnsProvider {
    String PATH = "/purRns";

    @PostMapping("/submitRns")
    ApiResult<PurRnsSaveRpcResult> submitRns(@RequestBody PurRnsSaveRpcParam purRnsSaveRpcParam);

    @GetMapping("/findById")
    ApiResult<PurRnsRpcDTO> findById(@RequestParam("id") Long id);

    @GetMapping("/findRgrByRns")
    ApiResult<PurRnsRgrRpcDTO> findRgrByRns(@RequestParam("id") Long id);


}
