package com.elitesland.pur.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 对账单明细表
 *
 * @author chaofeng.xia
 * @date 2024/4/15 18:00
 */
@Data
@ApiModel(value = "PurAccountCheckDParamVO", description = "对账单明细表")
public class PurAccountCheckDRpcParamVO implements Serializable {
    @ApiModelProperty("明细id")
    private Long id;

    @ApiModelProperty("明细ids")
    private List<Long> ids;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("主表ID")
    private List<Long> masIds;

    @ApiModelProperty("业务单据明细ID")
    private Long billDId;

    @ApiModelProperty("业务单据ID")
    private Long billId;

    @ApiModelProperty("对账单行号")
    private BigDecimal lineNo;

    @ApiModelProperty("中间表行号")
    private BigDecimal tblLineNo;

    @ApiModelProperty("单据类型")
    private String billDocType;

    @ApiModelProperty("对账类型")
    private String accountType;

    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("采购订单单据编号")
    private String poNo;

    @ApiModelProperty("品项ID")
    private Long itemId;
    private List<Long> itemIds;
    private String itemCode;
    private List<String> itemCodes;
    @ApiModelProperty("品项规格")
    private String itemSpec;
    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;
    @ApiModelProperty("品类(SPU)全路径名称")
    private String itemCateFullName;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("运输方式")
    private String transType;

    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("收货数量2")
    private BigDecimal qty2;

    @ApiModelProperty("单位2")
    private String uom2;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("收货人员工ID")
    private Long recvEmpId;

    @ApiModelProperty("收货人名字")
    private String recvEmpName;

    @ApiModelProperty("发货日期")
    private LocalDateTime recvDate;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

}
