package com.elitesland.pur.dto.gr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 采购收货单确认收货明细
 *
 * @author chaofeng.xia
 * @date 2024/5/7 17:52
 */
@Data
@ApiModel(value = "pur_gr_d", description = "采购收货单确认收货明细")
public class PurGrdConfirmRpcDTO implements Serializable {

    private static final long serialVersionUID = 7282982907839306540L;

    /**
     * 采购收货单明细id
     */
    private Long id;

    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime storageDate;

    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * 收货数量
     */
    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    /**
     * 收货批次
     */
    @ApiModelProperty("收货批次")
    private String lotNo;

    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;

    /**
     * 商品库存状态
     */
    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    private String stkItmStatus;

}
