package com.elitesland.pur.dto.ss;

import com.elitescloud.cloudt.common.annotation.SysCode;

import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class PurSsDTO extends BaseModelVO implements Serializable {

    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    private String ouCode;
    private String ouName;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;

    @ApiModelProperty("采购组织名称")
    private String buName;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:SS_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:SS_TYPE")
    @SysCode(sys = "yst-purc", mod = "SS_TYPE")
    private String docType;
    @ApiModelProperty("单据类型名称")
    private String docTypeName;
    /**
     * 单据状态 [UDC]PUR:SS_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    @SysCode(sys = "yst-purc", mod = "SS_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;

    @ApiModelProperty("发货总数")
    private Double qty;

    @ApiModelProperty("收货总数")
    private Double acceptQty;

    @ApiModelProperty("拒收总数")
    private BigDecimal rejectedQty;

    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 采购订单ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购订单ID")
    private Long poId;
    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;
    private String suppCode;
    private String suppName;
    /**
     * 供应商发货单号
     */
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    /**
     * 供应商送货单号(从采购单获取)
     * zhao.zhi.hao
     */
    @ApiModelProperty("供应商送货单号")
    private String suppDocNo1;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private String crosswhFlagName;
    /**
     * 仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;
    private String whCode;
    private String whName;
    private String whType;

    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    @ApiModelProperty("温层名称")
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;

    /**
     * 发货人(发货提交的当前登录人,在生成收货单使用)
     */
    @ApiModelProperty("发货人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long shipmentEmpId;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;

    @ApiModelProperty("发运国家")
    private String shipmentCountry;
    @ApiModelProperty("发运国家-名称")
    private String shipmentCountryName;
    @ApiModelProperty("省")
    private String shipmentProvince;
    @ApiModelProperty("省-名称")
    private String shipmentProvinceName;

    @ApiModelProperty("市")
    private String shipmentCity;
    @ApiModelProperty("市-名称")
    private String shipmentCityName;
    @ApiModelProperty("区")
    private String shipmentCounty;
    @ApiModelProperty("区-名称")
    private String shipmentCountyName;
    @ApiModelProperty("详细地址")
    private String shipmentDetailaddr;

    @ApiModelProperty("是否创建配送单")
    private Boolean carriageFlag  ;

    /**
     * 拒收原因
     */
    @ApiModelProperty("拒收原因")
    private String rejectReason;
    /**
     * 拒收时间
     */
    @ApiModelProperty("拒收时间")
    private LocalDateTime rejectTime;
    /**
     * 根ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("根ID")
    private Long rootId;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("关联单据类型")
    private String rootDocType;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2类别名称")
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联ID")
    private Long relateId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联2ID")
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal amt;

    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("外币含税金额")
    private Integer intfFlag;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("收货人名称")
    private String recvEmpName;

    @ApiModelProperty("收货人ID")
    private Long recvEmpId;

    @ApiModelProperty("仓库联系人电话")
    private String tel;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("收货地址")
    private String detailAddr;

    @ApiModelProperty("快递公司编号")
    private String logisticsOuCode;
    @ApiModelProperty("快递公司名称")
    private String logisticsOuName;
    @ApiModelProperty("物流单号")
    private String logisticsDocNo;

    @ApiModelProperty("车号")
    private String carNumber;

    @ApiModelProperty("司机")
    private String driver;

    @ApiModelProperty("司机电话")
    private String driverPhone;

    @ApiModelProperty("包装数量")
    private String packingQty;

    @ApiModelProperty("总重量")
    private String totalWeight;

    @ApiModelProperty("物流备注")
    private String logisticsRemark;

    @ApiModelProperty("供应商发货单")
    private List<PurSsDRespVO> purSsDRespVOList;

    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp",mod = "TP_TYPE")
    private String transType;
    @ApiModelProperty("运输方式名称")
    private String transTypeName;
    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;
    @ApiModelProperty("承运商联系人")
    private String carrierContactName;
    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;

    @ApiModelProperty("承运商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppId;
    @ApiModelProperty("承运商名称")
    private String carrierSuppName;

    @ApiModelProperty("出货方式")
    private String sellMethod;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("发货类型")
    @SysCode(sys = "yst-purc", mod = "SHIPMENT_TYPE")
    private String shipmentType;
    private String shipmentTypeName;

    @ApiModelProperty("采购场景编号")
    private String sceneTypeCode;
    private Long sceneTypeId;
}
