package com.elitesland.pur.dto.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "采购订单在线支付返回")
public class PurPoOnlinePayRpcDTO implements Serializable {
    private static final long serialVersionUID = 402129355488680789L;

    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("采购订单号")
    private String poNo;

    @ApiModelProperty("在线支付单号")
    private String onlinePayOrderNo;

    @ApiModelProperty("在线支付时间")
    private LocalDateTime onlinePayTime;

    @ApiModelProperty("在线支付金额")
    private BigDecimal onlinePayAmt;
}
