package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.po.*;
import com.elitesland.pur.dto.supp.PurPoSaveVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 采购订单
 * </p>
 *
 * @author tina.he
 * @since 2021-06-07 10:01:49
 */
@FeignClient(name = Application.NAME, path = Application.PATH + PurPoProvider.PATH)
@Validated
public interface PurPoProvider {
    String PATH = "/purPo";


    /**
     * 根据ID更新采购模块采购订单批次号、凭证号、传输状态、传输时间、失败原因
     *
     * @param paramVO 采购订单信息
     * @return
     */
    @PostMapping("/updatePurPo")
    ApiResult<Object> updatePurPoByParam(@RequestBody PurPoParamDTO paramVO);

    @GetMapping("/list")
    List<PurPoDTO> list(@RequestBody PurPoParamVO queryParam);

    /**
     * 创建单据
     *
     * @param createParam 创建信息
     * @return 主表id
     */
    @PostMapping("/createPurPo")
    Long createPurPo(@RequestBody PurPoSaveDTO createParam);

    /**
     * 根据采购单编号批量查询   @author shihao.ma 2020/8/10
     *
     * @param codeList 采购单编号集合
     * @return 查询结果
     */
    @PostMapping("/findCodeBatch")
    List<PurPoDTO> findCodeBatch(@RequestBody List<String> codeList);


    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @GetMapping("/search")
    PagingVO<PurPoDTO> search(@RequestBody PurPoParamVO queryParam);

    /**
     * 更新删除标识
     *
     * @param id id
     */
    // void updateDeleteFlag(Long id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping("/findIdBatch")
    List<PurPoDTO> findIdBatch(@RequestBody List<Long> idList);


    /**
     * 删除
     *
     * @param idList 对象集合
     */
    @DeleteMapping("/deleteBatch")
    void deleteBatch(@RequestBody List<Long> idList);

    /**
     * 创建
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    ApiResult<List<PurPoSaveDTO>> createBatch(@RequestBody List<PurPoSaveDTO> list);

    /**
     * 销售订单批量转采购订单
     *
     * @param purPoSaveDTOList 创建信息
     * @return 主表id
     */
    @PostMapping("/salConvertPurPo")
    ApiResult<List<SalSoAllPurPoDTO>> salConvertPurPo(@RequestBody List<PurPoSaveDTO> purPoSaveDTOList);

    /**
     * 销售配货生成采购订单（非越库）
     *
     * @param purPoSaveDTOList 创建信息
     * @return
     */
    @PostMapping("/salProducePurPo")
    List<SalSoReturnPurPoDTO> salProducePurPo(@RequestBody PurPoSaveDTO purPoSaveDTOList);

    /**
     * 销售转采购并提交采购单
     *
     * @param purPoSaveDTOList
     * @return
     */
    @PostMapping("/salProducePurPoAndCommit")
    List<SalSoReturnPurPoDTO> salProducePurPoAndCommit(@RequestBody List<PurPoSaveDTO> purPoSaveDTOList);

    @PostMapping("/salProducePurPoCommit")
    List<SalSoReturnPurPoDTO> salProducePurPoCommit(@RequestBody PurPoSaveDTO purPoSaveDTO);

    @PostMapping("/purPoCommit")
    Long purPoCommit(@RequestBody PurPoSaveDTO createParam);

    /**
     * 创建单据（物流快递调用专属接口）
     *
     * @param createParam 创建信息
     * @return 主表id
     */
    @PostMapping("/createPurPoOne")
    Long createPurPoOne(@RequestBody PurPoSaveVO createParam);

    /**
     * 查询单个单据（包含明细）
     *
     * @param id 主表id
     * @return 单据信息
     */
    @PostMapping("/findPurPoOne")
    ApiResult<PurPoDTO> findPurPoOne(@RequestBody Long id);

    /**
     * 查询采购订单支付信息
     *
     * @param poId
     * @return
     */
    @GetMapping("/findPayInfoByPoId")
    ApiResult<List<PurPoPayRpcDTO>> findPayInfoByPoId(@RequestParam("poId") Long poId);

    /**
     * 更新在线支付信息
     * @param payParamDTO
     */
    @PostMapping("/updateOnlinePay")
    void updateOnlinePay(@RequestBody PurPoOnlinePayParamDTO payParamDTO);

    /**
     * 查询采购订单在线支付信息
     * @param poId
     * @return
     */
    @GetMapping("/findOnlinePayInfo")
    PurPoOnlinePayRpcDTO findOnlinePayInfo(@RequestParam("poId") Long poId);

    /**
     * 关闭采购订单
     * @param ids
     */
    @PostMapping("/close")
    void closePo(@RequestBody List<Long> ids);
}

