package com.elitesland.pur.dto.supp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "PurSuppOuAddRpcDTO", description = "供应商增加归属公司")
public class PurSuppOuAddRpcDTO implements Serializable {
 private static final long serialVersionUID = -6883597717976510866L;


 @ApiModelProperty("公司ID")
 @JsonSerialize(using = ToStringSerializer.class)
 private Long ouId;

 @ApiModelProperty("公司编号")
 private String ouCode;

 @ApiModelProperty("供应商对象列表")
 private List<suppObject> suppObjectList;

 @Data
 public static class suppObject {

  @ApiModelProperty("供应商编码列表")
  public String suppCode;

  @ApiModelProperty("供应商ID")
  @JsonSerialize(using = ToStringSerializer.class)
  public Long suppId;

 }
}
