package com.elitesland.pur.dto.po;

import com.elitesland.pur.base.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单(PurPo)实体类
 *
 * @author liuqi
 * @since 2020-07-21 10:04:45
 */


@Data
@ApiModel(value = "pur_po", description = "采购订单")
public class PurPoDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -34281089348927283L;
    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * BUID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 预付款单ID
     */
    @ApiModelProperty("预付款单ID")
    Long paId;

    /**
     * 行号
     */
    @ApiModelProperty("行号")
    Double lineNo;
    /**
     * 事业部ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("事业部ID")
    private Long bdId;
    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司的地址号")
    private Long ouAddrNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库的地址号")
    private Long whAddrNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商的地址号")
    private Long suppAddrNo;

    /**
     * 发货数量
     */
    @ApiModelProperty("发货数量")
    Double shippedQty;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * zhao.zhi.hao
     * 表设计更改添加字段
     */
    @ApiModelProperty("供应商代理编号")
    private String suppAgencyCode;
    /**
     * 供应商联系人
     */
    @ApiModelProperty("供应商联系人")
    String suppContactName;
    /**
     * 供应商联系电话
     */
    @ApiModelProperty("供应商联系电话")
    String suppContactTel;
    /**
     * 供应商联系人邮箱
     */
    @ApiModelProperty("供应商联系人邮箱")
    String suppContactEmail;
    /**
     * 供应商传真
     */
    @ApiModelProperty("供应商传真")
    String suppContactFax;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据编号2
     */
    @ApiModelProperty("单据编号2")
    private String docNo2;
    /**
     * 单据类型 [UDC]PUR:PO_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:PO_TYPE")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE")
    private String docType;
    @ApiModelProperty("单据类型名称")
    private String docTypeName;
    /**
     * 单据类型2 [UDC]PUR:PO_TYPE2
     */
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    @SysCode(sys = "yst-purc", mod = "PO_TYPE2")
    private String docType2;
    @ApiModelProperty("单据类型2 [UDC]PUR:PO_TYPE2")
    private String docType2Name;
    /**
     * 单据类型3
     */
    @ApiModelProperty("单据类型3")
    private String docType3;
    /**
     * 单据状态 [UDC]PUR:PO_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:PO_STATUS")
    @SysCode(sys = "yst-purc", mod = "PO_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;
    /**
     * 单据状态2
     */
    @ApiModelProperty("单据状态2")
    private String docStatus2;
    /**
     * 单据状态3
     */
    @ApiModelProperty("单据状态3")
    private String docStatus3;
    /**
     * 流程实例id
     */
    @ApiModelProperty("流程实例ID")
    String apprProcInstId;
    @ApiModelProperty("任务名称")
    String apprTaskName;
    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "yst-supp", mod = "APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批状态名称")
    private String apprStatusName;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    /**
     * 审批人ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审批人ID")
    private Long apprUserId;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 订单时间
     */
    @ApiModelProperty("订单时间")
    private LocalDateTime docTime;

    /**
     * 是否团内 [UDC]ORG:SUPP_TYPE2
     */
    @ApiModelProperty("是否团内 [UDC]ORG:SUPP_TYPE2")
    @SysCode(sys = "yst-supp", mod = "SUPP_TYPE2")
    private String insideStatus;
    @ApiModelProperty("是否团内名称")
    private String insideStatusName;

    /**
     * 采购场景类型
     */
    @ApiModelProperty("采购场景类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sceneTypeId;

    @ApiModelProperty("采购场景类型名称")
    private String sceneTypeName;

    @ApiModelProperty("采购场景类型编码")
    private String sceneTypeCode;

    /**
     * 暂挂原因码 [UDC]PUR:PO_HOLD_REASON
     */
    @ApiModelProperty("暂挂原因码 [UDC]PUR:PO_HOLD_REASON")
    private String holdReasonCode;
    @ApiModelProperty("暂挂原因码名称")
    private String holdReasonCodeName;
    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 采购员员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("采购员员工名称")
    private String empName;
    /**
     * 跟单员员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("跟单员员工ID")
    private Long merchEmpId;

    @ApiModelProperty("跟单员员工ID")
    private String MerchEmpName;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 要求部门
     */
    @ApiModelProperty("要求部门")
    private String reqDept;
    /**
     * 项目号
     */
    @ApiModelProperty("项目号")
    private String projNo;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 采购来源
     */
    @ApiModelProperty("采购来源")
    @SysCode(sys = "yst-purc", mod = "PO_GEN_TYPE")
    private String poSource;
    private String poSourceName;
    /**
     * 采购方式
     */
    @ApiModelProperty("采购方式")
    private String poMode;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 是否需要预付款
     */
    @ApiModelProperty("是否需要预付款")
    private Integer needPrepayFlag;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    private String currName;
    /**
     * 已预付金额（含税）
     */
    @ApiModelProperty("已预付金额（含税）")
    BigDecimal prepaidAmt;

    /**
     * 剩余可付金额（含税）
     */
    @ApiModelProperty("剩余可付金额（含税）")
    BigDecimal remainAmt;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 是否含税
     */
    @ApiModelProperty("是否含税")
    private Integer taxInclFlag;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税总金额
     */
    @ApiModelProperty("含税总金额")
    private BigDecimal amt;
    /**
     * 未税总金额
     */
    @ApiModelProperty("未税总金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private Double qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 总数量2
     */
    @ApiModelProperty("总数量2")
    private Double qty2;
    /**
     * 数量2单位
     */
    @ApiModelProperty("数量2单位")
    private String qty2Uom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private Double netWeight;
    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private Double grossWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private Double volume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 付款条款
     */
    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    /**
     * MOQID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("MOQID")
    private Long moqId;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态")
    private String logisStatus;
    /**
     * 延交状态
     */
    @ApiModelProperty("延交状态")
    private String overdueStatus;
    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    private String recvStatus;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 要求效期天数
     */
    @ApiModelProperty("要求效期天数")
    private Integer demandAapDays;
    /**
     * 原始交期
     */
    @ApiModelProperty("原始交期")
    private LocalDateTime origDate;

    @ApiModelProperty("付款计划编号")
    private String payPlanNo;
    /**
     * 要求交期
     */
    @ApiModelProperty("要求交期")
    private LocalDateTime demandDate;
    /**
     * 供应商承诺交期
     */
    @ApiModelProperty("供应商承诺交期")
    private LocalDateTime promiseDate;
    /**
     * 要求供应商确认时间
     */
    @ApiModelProperty("要求供应商确认时间")
    private LocalDateTime demandConfirmTime;
    /**
     * 供应商回签状态
     */
    @ApiModelProperty("供应商回签状态")
    private String suppSignStatus;
    /**
     * 供应商确认时间
     */
    @ApiModelProperty("供应商确认时间")
    private LocalDateTime suppConfirmTime;
    /**
     * 供应商确认用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商确认用户ID")
    private Long suppConfirmUserid;
    /**
     * 供应商反馈
     */
    @ApiModelProperty("供应商反馈")
    private String suppRemark;
    /**
     * 发运类型
     */
    @ApiModelProperty("发运类型")
    private String shipmentType;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    @SysCode(sys = "yst-supp", mod = "TP_TYPE")
    private String transType;
    @ApiModelProperty("运输方式名称")
    private String transTypeName;
    /**
     * 运输温层 [UDC]INV:TRANSPORT_TEMP
     */
    @ApiModelProperty("运输温层 [UDC]INV:TRANSPORT_TEMP")
    @SysCode(sys = "yst-inv", mod = "TRANSPORT_TEMP")
    private String transportTemp;
    @ApiModelProperty("运输温层名称")
    private String transportTempName;
    /**
     * 收货仓库ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货仓库ID")
    private Long whId;
    /**
     * 收货仓库联系人
     */
    @ApiModelProperty("收货仓库联系人")
    private String whContactName;
    /**
     * 收货仓库联系人电话
     */
    @ApiModelProperty("收货仓库联系人电话")
    private String whContactTel;
    /**
     * 收货仓库联系人邮箱
     */
    @ApiModelProperty("收货仓库联系人邮箱")
    private String whContactEmail;
    /**
     * 交货要求
     */
    @ApiModelProperty("交货要求")
    private String shipmentInstruct;
    /**
     * 交货要求2
     */
    @ApiModelProperty("交货要求2")
    private String shipmentInstruct2;
    /**
     * 发运地址号
     */
    @ApiModelProperty("发运地址号")
    private Integer shipmentAddrNo;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;
    /**
     * 发运联系人邮箱
     */
    @ApiModelProperty("发运联系人邮箱")
    private String shipmentContactEmail;
    /**
     * 发运国家
     */
    @ApiModelProperty("发运国家")
    private String shipmentCountry;
    /**
     * 发运省
     */
    @ApiModelProperty("发运省")
    private String shipmentProvince;
    /**
     * 发运市
     */
    @ApiModelProperty("发运市")
    private String shipmentCity;
    /**
     * 发运区县
     */
    @ApiModelProperty("发运区县")
    private String shipmentCounty;
    /**
     * 发运乡镇街道
     */
    @ApiModelProperty("发运乡镇街道")
    private String shipmentStreet;
    /**
     * 发运详细地址
     */
    @ApiModelProperty("发运详细地址")
    private String shipmentDetailaddr;
    /**
     * 承运商供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppCode;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carrierSuppName;
    /**
     * 承运商
     */
    @ApiModelProperty("承运商")
    private String carrier;
    /**
     * 从地点 [UOM]COM:CITY
     */
    @ApiModelProperty("从地点 [UOM]COM:CITY")
    @SysCode(sys = "yst-supp", mod = "CITY")
    private String fromLoc;
    @ApiModelProperty("从地点名称")
    private String fromLocName;
    /**
     * 到地点 [UOM]COM:CITY
     */
    @ApiModelProperty("到地点 [UOM]COM:CITY")
    @SysCode(sys = "yst-supp", mod = "CITY")
    private String toLoc;
    @ApiModelProperty("到地点名称")
    private String toLocName;
    /**
     * 收货单位ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收货单位ID")
    private Long acceptOuId;
    /**
     * 到达港口 [UDC]COM:TP_PORT
     */
    @ApiModelProperty("到达港口 [UDC]COM:TP_PORT")
    @SysCode(sys = "yst-supp", mod = "TP_PORT")
    private String recvPort;
    @ApiModelProperty("到达港口名称")
    private String recvPortName;
    /**
     * 收货地址
     */
    @ApiModelProperty("收货地址")
    private String recvAddr;
    /**
     * 退货地址
     */
    @ApiModelProperty("退货地址")
    private String returnAddr;
    /**
     * 是否加急
     */
    @ApiModelProperty("是否加急")
    private Integer urgentFlag;
    /**
     * 是否允许早交
     */
    @ApiModelProperty("是否允许早交")
    private Integer allowAheadFlag;
    /**
     * 收货允差
     */
    @ApiModelProperty("收货允差")
    private Double recvTolerance;
    /**
     * 收货允差2
     */
    @ApiModelProperty("收货允差2")
    private Double recvTolerance2;
    /**
     * 采购申请ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购申请ID")
    private Long prId;
    /**
     * 采购申请单号
     */
    @ApiModelProperty("采购申请单号")
    private String prNo;
    /**
     * 采购计划ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购计划ID")
    private Long ppId;
    /**
     * 采购计划版本号
     */
    @ApiModelProperty("采购计划版本号")
    private String ppVersoin;
    /**
     * 合同ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 合同编号
     */
    @ApiModelProperty("合同编号")
    private String contractNo;
    /**
     * 供方合同号
     */
    @ApiModelProperty("供方合同号")
    private String suppContractNo;
    /**
     * 供方单号
     */
    @ApiModelProperty("供方单号")
    private String suppDocNo;
    /**
     * 采购RMA_ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购RMA_ID")
    private Long prmaId;
    private String prmaNo;
    /**
     * 取消数量
     */
    @ApiModelProperty("取消数量")
    private Double cancelQty;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;
    /**
     * 收货总数量
     */
    @ApiModelProperty("收货总数量")
    private Double acceptQty;

    @ApiModelProperty("拒收总数量")
    private BigDecimal rejectedQty;

    /**
     * 取消原因
     */
    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 取消用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 关闭日期
     */
    @ApiModelProperty("关闭日期")
    private LocalDateTime closeDate;

    @ApiModelProperty("预计付款日期")
    LocalDateTime prepaidDate;

    @ApiModelProperty("账款到期日")
    LocalDateTime dueDate;

    @ApiModelProperty("订单完成备注")
    private String finishComment;

    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关闭用户ID")
    private Long closeUserId;
    /**
     * 完成状态
     */
    @ApiModelProperty("完成状态")
    private String completeStatus;

    @ApiModelProperty("生成类型")
    @SysCode(sys = "yst-purc", mod = "PO_GEN_TYPE")
    private String genType;
    private String genTypeName;
    /**
     * 关联单据类别 来源销售单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 来源销售单等。[UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据类别名称")
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联ID")
    private Long realteId;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String realteNo;
    /**
     * 关联2ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联2ID")
    private Long realte2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String realte2No;
    /**
     * 备注2 货柜
     */
    @ApiModelProperty("备注2 货柜")
    private String remark2;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * 租户ID
     */
//    @JsonSerialize(using = ToStringSerializer.class)
//    @ApiModelProperty("租户ID")
//    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("免值标记")
    @SysCode(sys = "yst-supp", mod = "ZEROVAL_TYPE")
    private String zerovalType;
    private String zerovalTypeName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司地址")
    private String ouAddress;

    @ApiModelProperty("公司电话")
    private String ouPhone;

    @ApiModelProperty("公司传真")
    private String ouFax;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("供应商地址")
    private String suppAddress;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("原始参考数量")
    private Double origQty;

    @ApiModelProperty("原始参考金额")
    private BigDecimal origNetAmt;
    /**
     * 操作人ID
     */
    @ApiModelProperty("操作人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long operUserId;

    @ApiModelProperty(value = "维护人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long picEmpId;

    @ApiModelProperty(value = "维护人名称")
    @JsonSerialize(using = ToStringSerializer.class)
    private String picEmpName;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;

    @ApiModelProperty("采购明细")
    private List<PurPoDDTO> purPoDDTOList;

    @ApiModelProperty("收货联系人姓名")
    private String recvContactName;

    @ApiModelProperty("收货联系人电话")
    private String recvContactPhone;

    @ApiModelProperty("收货联系人传真号码")
    private String recvContactFax;

   // @ApiModelProperty("采购明细采购订单付款计划")
   // private List<PurPoPayplanRespVO> purPoPayplanRespVOlist;

    @ApiModelProperty("来源单据编号")
    String rootDocNo;

    @ApiModelProperty("批次号")
    String finBatchNumber;

    @ApiModelProperty("回传凭证号")
    String finVoucherNo;

    @ApiModelProperty("传输状态(财务批次同步状态)")
    String syncStatus;

    @ApiModelProperty("传输时间")
    LocalDateTime syncTime;

    @ApiModelProperty("失败原因")
    String syncFailReason;
    @ApiModelProperty("是否已申请预付：1是，0否")
    private Boolean prepayFlag;
    @ApiModelProperty("单据类别")
    private String docCls;
}
